/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml;

import flex2.compiler.mxml.Attribute;
import flex2.compiler.mxml.Token;
import flex2.compiler.mxml.rep.AtResource;
import flex2.compiler.util.LinkedQNameMap;
import flex2.compiler.util.QName;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Element
extends Token {
    private String uri;
    private String localPart;
    private LinkedQNameMap<Object> attributes;
    private Map<String, String> prefixMappings;
    private List<Token> children;

    protected Element(String uri, String localPart, int size) {
        this.uri = uri;
        this.localPart = localPart;
        if (size > 0) {
            this.attributes = new LinkedQNameMap(size);
        }
        this.prefixMappings = null;
    }

    public void addPrefixMapping(String uri, String prefix) {
        if (this.prefixMappings == null) {
            this.prefixMappings = new HashMap<String, String>(8);
        }
        this.prefixMappings.put(uri, prefix);
    }

    public void addAttribute(String uri, String localPart, Object value, int line) {
        if (this.attributes == null) {
            this.attributes = new LinkedQNameMap();
        }
        this.attributes.put(uri, localPart, new Attribute(uri, localPart, value, line));
    }

    public Attribute getAttribute(String localName) {
        return this.getAttribute("", localName);
    }

    public Attribute getAttribute(String uri, String localName) {
        if (this.attributes == null) {
            return null;
        }
        return (Attribute)this.attributes.get(uri, localName);
    }

    public Object getAttributeValue(String localName) {
        return this.getAttributeValue("", localName);
    }

    public Object getAttributeValue(String uri, String localName) {
        Attribute v = this.getAttribute(uri, localName);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public Object getAttributeValue(QName qname) {
        if (this.attributes == null) {
            return null;
        }
        Attribute v = (Attribute)this.attributes.get(qname);
        if (v != null) {
            return v.getValue();
        }
        return null;
    }

    public int getLineNumber(String localName) {
        return this.getLineNumber("", localName);
    }

    public int getLineNumber(String uri, String localName) {
        if (this.attributes == null) {
            return this.beginLine;
        }
        Attribute v = (Attribute)this.attributes.get(uri, localName);
        if (v != null) {
            return v.getLine();
        }
        return this.beginLine;
    }

    public int getLineNumber(QName qname) {
        if (this.attributes == null) {
            return this.beginLine;
        }
        Attribute v = (Attribute)this.attributes.get(qname);
        if (v != null) {
            return v.getLine();
        }
        return this.beginLine;
    }

    public Iterator<QName> getAttributeNames() {
        return this.attributes == null ? Collections.emptySet().iterator() : this.attributes.keySet().iterator();
    }

    public int getAttributeCount() {
        return this.attributes == null ? 0 : this.attributes.size();
    }

    public String getNamespace() {
        return this.uri;
    }

    public String getLocalPart() {
        return this.localPart;
    }

    public String getPrefix() {
        return this.prefixMappings == null ? null : this.prefixMappings.get(this.uri);
    }

    public void addChildren(List<Token> children) {
        if (this.children == null) {
            this.children = children;
        } else {
            this.children.addAll(children);
        }
    }

    public void addChild(Token child) {
        if (child != null) {
            if (this.children == null) {
                this.children = new ArrayList<Token>();
            }
            this.children.add(child);
        }
    }

    public void copy(Element element) {
        element.uri = this.uri;
        element.localPart = this.localPart;
        element.attributes = this.attributes;
        element.children = this.children;
        element.prefixMappings = this.prefixMappings;
    }

    public Token getChildAt(int index) {
        return this.children == null ? null : this.children.get(index);
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public List<Token> getChildren() {
        return this.children == null ? Collections.emptyList() : Collections.unmodifiableList(this.children);
    }

    public final Iterator getChildIterator() {
        return this.getChildren().iterator();
    }

    public void replaceNode(int index, List<Token> children) {
        this.children.remove(index);
        this.children.addAll(index, children);
    }

    public void removeAttribute(QName qname) {
        this.attributes.remove(qname);
    }

    public String getPrefix(String uri) {
        return this.prefixMappings == null ? null : this.prefixMappings.get(uri);
    }

    public void toStartElement(StringWriter w) {
        Iterator<String> k;
        String p = null;
        w.write(60);
        p = this.getPrefix(this.uri);
        if (p != null && p.length() > 0) {
            w.write(p);
            w.write(58);
        }
        w.write(this.localPart);
        Iterator<QName> i = this.getAttributeNames();
        while (i.hasNext()) {
            QName qName = i.next();
            w.write(32);
            p = this.getPrefix(qName.getNamespace());
            if (p != null && p.length() > 0) {
                w.write(p);
                w.write(58);
            }
            w.write(qName.getLocalPart());
            Object attr = this.getAttributeValue(qName);
            if (attr instanceof AtResource) {
                w.write("={");
                w.write(((AtResource)attr).getValueExpression());
                w.write("}");
                continue;
            }
            w.write("=\"");
            w.write(this.getAttributeValue(qName).toString());
            w.write("\"");
        }
        Iterator<String> iterator = k = this.prefixMappings == null ? null : this.prefixMappings.keySet().iterator();
        while (k != null && k.hasNext()) {
            String ns = k.next();
            String px = this.getPrefix(ns);
            if (px == null) continue;
            w.write(" xmlns");
            if (px.length() > 0) {
                w.write(58);
                w.write(px);
            }
            w.write("=\"");
            w.write(ns);
            w.write("\"");
        }
        w.write(62);
    }

    public void toEndElement(StringWriter w) {
        String p = null;
        w.write("</");
        p = this.getPrefix(this.uri);
        if (p != null && p.length() > 0) {
            w.write(p);
            w.write(58);
        }
        w.write(this.localPart);
        w.write(62);
    }
}

