/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.media;

import flash.swf.tags.DefineTag;
import flash.util.FileUtils;
import flex2.compiler.SymbolTable;
import flex2.compiler.Transcoder;
import flex2.compiler.TranscoderException;
import flex2.compiler.common.PathResolver;
import flex2.compiler.io.VirtualFile;
import flex2.compiler.media.AbstractTranscoder;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Map;

public class XMLTranscoder
extends AbstractTranscoder {
    public static final String ENCODING = "encoding";

    public XMLTranscoder() {
        super(new String[]{"text/xml"}, null, false);
    }

    public Transcoder.TranscodingResults doTranscode(PathResolver context, SymbolTable symbolTable, Map args, String className, boolean generateSource) throws TranscoderException {
        VirtualFile source = this.resolveSource(context, args);
        Transcoder.TranscodingResults results = new Transcoder.TranscodingResults(source);
        if (!generateSource) {
            throw new AbstractTranscoder.EmbedRequiresCodegen(source.getName(), className);
        }
        this.generateSource(results, className, args);
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void generateSource(Transcoder.TranscodingResults asset, String fullClassName, Map embedMap) throws TranscoderException {
        String encoding = (String)embedMap.get(ENCODING);
        String packageName = "";
        String className = fullClassName;
        int dot = fullClassName.lastIndexOf(46);
        if (dot != -1) {
            packageName = fullClassName.substring(0, dot);
            className = fullClassName.substring(dot + 1);
        }
        StringBuilder source = new StringBuilder(1024);
        source.append("package ");
        source.append(packageName);
        source.append(" { public class ");
        source.append(className);
        source.append(" { public static var data:XML = ");
        BufferedInputStream in = null;
        try {
            try {
                in = new BufferedInputStream(asset.assetSource.getInputStream());
                in.mark(3);
                InputStreamReader reader = new InputStreamReader((InputStream)in, FileUtils.consumeBOM((InputStream)in, (String)encoding));
                char[] line = new char[2000];
                int count = 0;
                while ((count = ((Reader)reader).read(line, 0, line.length)) >= 0) {
                    source.append(line, 0, count);
                }
                Object var14_14 = null;
            }
            catch (Exception e) {
                throw new AbstractTranscoder.UnableToReadSource(asset.assetSource.getName());
            }
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            try {
                if (in == null) throw throwable;
                in.close();
                throw throwable;
            }
            catch (Throwable throwable2) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (Throwable throwable) {}
        if (in != null) {
            in.close();
        }
        source.append("; } }");
        asset.generatedCode = source.toString();
    }

    public boolean isSupportedAttribute(String attr) {
        return ENCODING.equals(attr);
    }

    public String getAssociatedClass(DefineTag tag) {
        return "Object";
    }

    public void clear() {
    }
}

