/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.style;

import java.util.ArrayList;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.IterateInstr;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.instruct.Executable;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.AxisIterator;
import net.sf.saxon.om.ListIterator;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.style.SaxonFinally;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.style.XSLParam;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;

public class SaxonIterate
extends StyleElement {
    Expression select = null;

    public boolean isInstruction() {
        return true;
    }

    protected boolean isPermittedChild(StyleElement child) {
        return child instanceof XSLParam;
    }

    protected ItemType getReturnedItemType() {
        return this.getCommonChildItemType();
    }

    public boolean mayContainSequenceConstructor() {
        return true;
    }

    protected boolean mayContainParam() {
        return true;
    }

    public void prepareAttributes() throws XPathException {
        AttributeCollection atts = this.getAttributeList();
        String selectAtt = null;
        for (int a = 0; a < atts.getLength(); ++a) {
            int nc = atts.getNameCode(a);
            String f = this.getNamePool().getClarkName(nc);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                continue;
            }
            this.checkUnknownAttribute(nc);
        }
        if (selectAtt == null) {
            this.reportAbsence("select");
        } else {
            this.select = this.makeExpression(selectAtt);
        }
    }

    public void validate() throws XPathException {
        this.select = this.typeCheck("select", this.select);
        if (!this.hasChildNodes()) {
            this.compileWarning("An empty saxon:iterate instruction has no effect", "SXWN9009");
        }
    }

    public Expression compile(Executable exec) throws XPathException {
        NodeInfo node;
        AxisIterator children = this.iterateAxis((byte)3);
        ArrayList<NodeInfo> nonFinallyChildren = new ArrayList<NodeInfo>();
        Expression finallyExp = null;
        while ((node = (NodeInfo)children.next()) != null) {
            if (node instanceof SaxonFinally) {
                finallyExp = ((SaxonFinally)node).compile(exec);
                continue;
            }
            nonFinallyChildren.add(node);
        }
        Expression block = this.compileSequenceConstructor(exec, new ListIterator(nonFinallyChildren), true);
        if (block == null) {
            return Literal.makeEmptySequence();
        }
        try {
            return new IterateInstr(this.select, this.makeExpressionVisitor().simplify(block), finallyExp);
        }
        catch (XPathException err) {
            this.compileError(err);
            return null;
        }
    }
}

