/*
 * Decompiled with CFR 0.152.
 */
package macromedia.asc.util;

public final class ByteList {
    private byte[] a;
    private int size;

    public ByteList(ByteList list) {
        this(list.size());
        System.arraycopy(list.a, 0, this.a, 0, list.size());
    }

    public ByteList() {
        this(10);
    }

    public ByteList(int size) {
        this.a = new byte[size];
        this.size = 0;
    }

    public void add(byte value) {
        this.resize();
        this.a[this.size++] = value;
    }

    public void push_back(byte value) {
        this.resize();
        this.a[this.size++] = value;
    }

    public void addAll(byte[] bytes) {
        this.addAll(bytes, bytes.length);
    }

    public void addAll(ByteList list) {
        this.addAll(list.a, list.size);
    }

    private void addAll(byte[] array, int length) {
        this.resize(this.size + length);
        System.arraycopy(array, 0, this.a, this.size, length);
        this.size += length;
    }

    public void set(byte[] array, int length) {
        this.a = array;
        this.size = length;
    }

    public void set(int index, byte value) {
        this.resize();
        this.a[index] = value;
        if (index >= this.size) {
            this.size = index + 1;
        }
    }

    public void resize(int s) {
        if (s > this.a.length) {
            int newSize = this.a.length * 3 / 2 + 1;
            if (newSize < s) {
                newSize = s;
            }
            byte[] temp = new byte[newSize];
            System.arraycopy(this.a, 0, temp, 0, this.size);
            this.a = temp;
        }
    }

    private void resize() {
        if (this.size == this.a.length) {
            this.resize(this.size * 3 / 2 + 1);
        }
    }

    public byte at(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.a[index];
    }

    public byte get(int index) {
        if (index < 0 || index >= this.size) {
            throw new ArrayIndexOutOfBoundsException(index);
        }
        return this.a[index];
    }

    public byte first() {
        return this.size == 0 ? (byte)0 : this.a[0];
    }

    public byte last() {
        return this.size() == 0 ? (byte)0 : this.a[this.size - 1];
    }

    public byte remove(int index) {
        byte value = this.get(index);
        if (index != this.size - 1) {
            System.arraycopy(this.a, index + 1, this.a, index, this.size - 1 - index);
        }
        --this.size;
        return value;
    }

    public byte remove(int index, int count) {
        byte value = this.get(index);
        if (index != this.size - 1) {
            System.arraycopy(this.a, index + count, this.a, index, this.size - count - index);
        }
        this.size -= count;
        return value;
    }

    public byte removeLast() {
        return this.size() == 0 ? (byte)0 : this.remove(this.size - 1);
    }

    public void clear() {
        this.size = 0;
    }

    public int size() {
        return this.size;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public byte[] toByteArray() {
        return this.toByteArray(true);
    }

    public byte[] toByteArray(boolean copy) {
        if (copy || this.a.length != this.size) {
            byte[] b = new byte[this.size];
            System.arraycopy(this.a, 0, b, 0, this.size);
            return b;
        }
        return this.a;
    }

    public boolean equals(Object b) {
        if (this == b) {
            return true;
        }
        if (b instanceof ByteList) {
            return this.equals((ByteList)b);
        }
        return false;
    }

    public boolean equals(ByteList b) {
        if (b == null) {
            return false;
        }
        if (this.size != b.size) {
            return false;
        }
        for (int x = 0; x < this.size; ++x) {
            if (this.a[x] == b.a[x]) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hashCode = 1;
        for (int j = 0; j < this.size; ++j) {
            hashCode = 31 * hashCode + this.a[j];
        }
        return hashCode;
    }
}

