/*
 * Decompiled with CFR 0.152.
 */
package org.apache.empire.db;

import org.apache.empire.db.DBColumn;
import org.apache.empire.db.DBContext;
import org.apache.empire.db.DBDatabase;
import org.apache.empire.db.DBObject;
import org.apache.empire.db.DBSQLScript;
import org.apache.empire.db.DBTable;
import org.apache.empire.db.DBTableColumn;
import org.apache.empire.exceptions.InvalidArgumentException;
import org.apache.empire.exceptions.UnexpectedReturnValueException;

public class DBRelation
extends DBObject {
    private DBDatabase db;
    private String name;
    private DBReference[] references;
    private DBCascadeAction onDeleteAction;

    public DBRelation(DBDatabase db, String name, DBReference[] references, DBCascadeAction onDeleteAction) {
        this.db = db;
        this.name = name;
        this.references = references;
        this.onDeleteAction = onDeleteAction;
    }

    public DBRelation(DBDatabase db, String name, DBReference[] references) {
        this(db, name, references, DBCascadeAction.NONE);
    }

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        String schema = this.db.getSchema();
        return schema != null ? schema + "." + this.name : this.name;
    }

    public DBReference[] getReferences() {
        return this.references;
    }

    public boolean isOnColumns(DBColumn[] keyColumns) {
        if (keyColumns == null || this.references.length != keyColumns.length) {
            return false;
        }
        for (int i = 0; i < this.references.length; ++i) {
            if (this.references[i].getTargetColumn().equals(keyColumns[i])) continue;
            return false;
        }
        return true;
    }

    public DBTable getForeignKeyTable() {
        return (DBTable)this.references[0].getSourceColumn().getRowSet();
    }

    public DBTable getReferencedTable() {
        return (DBTable)this.references[0].getTargetColumn().getRowSet();
    }

    public final DBDatabase getDatabase() {
        return this.db;
    }

    public DBCascadeAction getOnDeleteAction() {
        return this.onDeleteAction;
    }

    public void setOnDeleteAction(DBCascadeAction onDeleteAction) {
        this.onDeleteAction = onDeleteAction;
    }

    public void onDeleteCascade() {
        this.setOnDeleteAction(DBCascadeAction.CASCADE);
    }

    public void onDeleteCascadeRecords() {
        this.setOnDeleteAction(DBCascadeAction.CASCADE_RECORDS);
    }

    public String getEnableDisableStmt(boolean enable, DBContext context) {
        if (context == null) {
            throw new InvalidArgumentException("context", context);
        }
        DBSQLScript script = new DBSQLScript(context);
        context.getDbms().appendEnableRelationStmt(this, enable, script);
        if (script.getCount() != 1) {
            throw new UnexpectedReturnValueException(script.getCount(), "dbms.addEnableRelationStatement");
        }
        return script.getStmt(0);
    }

    public String toString() {
        int i;
        StringBuilder b = new StringBuilder();
        b.append("\"");
        b.append(this.getForeignKeyTable().getName());
        b.append("\" CONSTRAINT \"");
        b.append(this.name);
        b.append("\" FOREIGN KEY (");
        for (i = 0; i < this.references.length; ++i) {
            b.append(i > 0 ? ", \"" : "\"");
            b.append(this.references[i].getSourceColumn().getName());
            b.append("\"");
        }
        b.append(") REFERENCES \"");
        b.append(this.getReferencedTable().getName());
        b.append("\" (");
        for (i = 0; i < this.references.length; ++i) {
            b.append(i > 0 ? ", \"" : "\"");
            b.append(this.references[i].getTargetColumn().getName());
            b.append("\"");
        }
        b.append(")");
        return b.toString();
    }

    public static class DBReference {
        private DBTableColumn sourceColumn;
        private DBTableColumn targetColumn;

        public DBReference(DBTableColumn sourceColumn, DBTableColumn targetColumn) {
            this.sourceColumn = sourceColumn;
            this.targetColumn = targetColumn;
        }

        public DBTableColumn getSourceColumn() {
            return this.sourceColumn;
        }

        public DBTableColumn getTargetColumn() {
            return this.targetColumn;
        }
    }

    public static enum DBCascadeAction {
        NONE,
        CASCADE,
        CASCADE_RECORDS;

    }
}

