---
{
    "title": "TASKS",
    "language": "en"
}
---

<!--
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

  http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing,
software distributed under the License is distributed on an
"AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, either express or implied.  See the License for the
specific language governing permissions and limitations
under the License.
-->

## `tasks`

### Name

<version since="dev">

tasks

</version>

### description

Table function, generates a temporary table of tasks, which allows you to view the information of tasks generated by jobs in the current Doris cluster.

This function is used in the FROM clause.

#### syntax

`tasks("type"="insert");`
**parameter description**

| parameter | description | type   | required |
|:----------|:------------|:-------|:---------|
| type      | job type    | string | yes      |

the **type** supported types
- insert: insert into type job
- mv: materilized view type job

##### Insert tasks

The table schema of `tasks("type"="insert");` tvf：

```
mysql> desc function tasks("type"="insert");
+---------------+------+------+-------+---------+-------+
| Field         | Type | Null | Key   | Default | Extra |
+---------------+------+------+-------+---------+-------+
| TaskId        | TEXT | No   | false | NULL    | NONE  |
| JobId         | TEXT | No   | false | NULL    | NONE  |
| Label         | TEXT | No   | false | NULL    | NONE  |
| Status        | TEXT | No   | false | NULL    | NONE  |
| EtlInfo       | TEXT | No   | false | NULL    | NONE  |
| TaskInfo      | TEXT | No   | false | NULL    | NONE  |
| ErrorMsg      | TEXT | No   | false | NULL    | NONE  |
| CreateTimeMs  | TEXT | No   | false | NULL    | NONE  |
| FinishTimeMs  | TEXT | No   | false | NULL    | NONE  |
| TrackingUrl   | TEXT | No   | false | NULL    | NONE  |
| LoadStatistic | TEXT | No   | false | NULL    | NONE  |
| User          | TEXT | No   | false | NULL    | NONE  |
+---------------+------+------+-------+---------+-------+
12 rows in set (0.01 sec)
```
##### MV Tasks
```sql
mysql> desc function tasks("type"="mv");
+-----------------------+------+------+-------+---------+-------+
| Field                 | Type | Null | Key   | Default | Extra |
+-----------------------+------+------+-------+---------+-------+
| TaskId                | TEXT | No   | false | NULL    | NONE  |
| JobId                 | TEXT | No   | false | NULL    | NONE  |
| JobName               | TEXT | No   | false | NULL    | NONE  |
| MvId                  | TEXT | No   | false | NULL    | NONE  |
| MvName                | TEXT | No   | false | NULL    | NONE  |
| MvDatabaseId          | TEXT | No   | false | NULL    | NONE  |
| MvDatabaseName        | TEXT | No   | false | NULL    | NONE  |
| Status                | TEXT | No   | false | NULL    | NONE  |
| ErrorMsg              | TEXT | No   | false | NULL    | NONE  |
| CreateTime            | TEXT | No   | false | NULL    | NONE  |
| StartTime             | TEXT | No   | false | NULL    | NONE  |
| FinishTime            | TEXT | No   | false | NULL    | NONE  |
| DurationMs            | TEXT | No   | false | NULL    | NONE  |
| TaskContext           | TEXT | No   | false | NULL    | NONE  |
| RefreshMode           | TEXT | No   | false | NULL    | NONE  |
| NeedRefreshPartitions | TEXT | No   | false | NULL    | NONE  |
| CompletedPartitions   | TEXT | No   | false | NULL    | NONE  |
| Progress              | TEXT | No   | false | NULL    | NONE  |
+-----------------------+------+------+-------+---------+-------+
18 rows in set (0.00 sec)
```

* TaskId: task id
* JobId: job id
* JobName: job Name
* MvId: Materialized View ID
* MvName: Materialized View Name
* MvDatabaseId: DB ID of the materialized view
* MvDatabaseName: Name of the database to which the materialized view belongs
* Status: task status
* ErrorMsg: Task failure information
* CreateTime: Task creation time
* StartTime: Task start running time
* FinishTime: Task End Run Time
* DurationMs: Task runtime
* TaskContext: Task running parameters
* RefreshMode: refresh mode
* NeedRefreshPartitions: The partition information that needs to be refreshed for this task
* CompletedPartitions: The partition information that has been refreshed for this task
* Progress: Task running progress
### example
#### Insert Tasls
```
mysql>  select * from tasks("type"="insert") limit 1 \G
*************************** 1. row ***************************
       TaskId: 667704038678903
        JobId: 10069
        Label: 10069_667704038678903
       Status: FINISHED
      EtlInfo: \N
     TaskInfo: cluster:N/A; timeout(s):14400; max_filter_ratio:0.0; priority:NORMAL
     ErrorMsg: \N
 CreateTimeMs: 2023-12-08 16:46:57
 FinishTimeMs: 2023-12-08 16:46:57
  TrackingUrl: 
LoadStatistic: {"Unfinished backends":{},"ScannedRows":0,"TaskNumber":0,"LoadBytes":0,"All backends":{},"FileNumber":0,"FileSize":0}
         User: root
1 row in set (0.05 sec)

```
#### MV Tasks

1. View tasks for all materialized views

```sql
mysql> select * from tasks("type"="mv");
```

2. View all tasks with jobName `inner_mtmv_75043`

```sql
mysql> select * from tasks("type"="mv") where JobName="inner_mtmv_75043";
```


### keywords

    tasks, job, insert, mv, materilized view