/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.gson;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.Date;

abstract class DateUnixtimeTypeAdapter
extends TypeAdapter<Date> {
    private final boolean allowNegativeTimestamp;

    public DateUnixtimeTypeAdapter(boolean allowNegativeTimestamp) {
        this.allowNegativeTimestamp = allowNegativeTimestamp;
    }

    public final void write(JsonWriter out, Date value) throws IOException {
        long time = value.getTime();
        if (time >= 0L || this.allowNegativeTimestamp) {
            out.value(this.toTimestamp(value));
        } else {
            out.nullValue();
        }
    }

    public final Date read(JsonReader in) throws IOException {
        long time = in.nextLong();
        if (time >= 0L || this.allowNegativeTimestamp) {
            return this.fromTimestamp(time);
        }
        return null;
    }

    protected abstract long toTimestamp(Date var1);

    protected abstract Date fromTimestamp(long var1);
}

