/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.resources.fluentcore.dag;

import com.azure.resourcemanager.resources.fluentcore.dag.FunctionalTaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskGroup;
import com.azure.resourcemanager.resources.fluentcore.dag.TaskItem;
import com.azure.resourcemanager.resources.fluentcore.dag.VoidIndexable;
import com.azure.resourcemanager.resources.fluentcore.model.Appliable;
import com.azure.resourcemanager.resources.fluentcore.model.Creatable;
import com.azure.resourcemanager.resources.fluentcore.model.Executable;
import com.azure.resourcemanager.resources.fluentcore.model.Indexable;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import java.util.Objects;
import java.util.UUID;
import reactor.core.publisher.Mono;

public abstract class IndexableTaskItem
implements Indexable,
TaskItem,
TaskGroup.HasTaskGroup {
    private final String key;
    private final TaskGroup taskGroup;
    private Indexable taskResult;

    public IndexableTaskItem(String key) {
        this.key = key;
        this.taskGroup = new TaskGroup(this);
        this.taskResult = null;
    }

    public IndexableTaskItem() {
        this(UUID.randomUUID().toString());
    }

    public IndexableTaskItem(ResourceManagerUtils.InternalRuntimeContext internalContext) {
        this(internalContext.randomUuid());
    }

    public static IndexableTaskItem create(final FunctionalTaskItem taskItem) {
        return new IndexableTaskItem(){

            @Override
            protected Mono<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                FunctionalTaskItem.Context fContext = new FunctionalTaskItem.Context(this);
                fContext.setInnerContext(context);
                return (Mono)taskItem.apply(fContext);
            }
        };
    }

    public static IndexableTaskItem create(final FunctionalTaskItem taskItem, ResourceManagerUtils.InternalRuntimeContext internalContext) {
        return new IndexableTaskItem(internalContext){

            @Override
            protected Mono<Indexable> invokeTaskAsync(TaskGroup.InvocationContext context) {
                FunctionalTaskItem.Context fContext = new FunctionalTaskItem.Context(this);
                fContext.setInnerContext(context);
                return (Mono)taskItem.apply(fContext);
            }
        };
    }

    @Override
    public TaskGroup taskGroup() {
        return this.taskGroup;
    }

    public void clear() {
        this.taskResult = this.voidIndexable();
    }

    @Override
    public String key() {
        return this.key;
    }

    protected String addDependency(FunctionalTaskItem dependency) {
        Objects.requireNonNull(dependency);
        return this.taskGroup.addDependency(dependency);
    }

    protected String addDependency(TaskGroup.HasTaskGroup dependency) {
        Objects.requireNonNull(dependency);
        this.taskGroup.addDependencyTaskGroup(dependency.taskGroup());
        return dependency.taskGroup().key();
    }

    protected String addDependency(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addDependency(dependency);
    }

    protected String addDependency(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addDependency(dependency);
    }

    public String addPostRunDependent(FunctionalTaskItem dependent) {
        Objects.requireNonNull(dependent);
        return this.taskGroup().addPostRunDependent(dependent);
    }

    public String addPostRunDependent(TaskGroup.HasTaskGroup dependent) {
        Objects.requireNonNull(dependent);
        this.taskGroup().addPostRunDependentTaskGroup(dependent.taskGroup());
        return dependent.taskGroup().key();
    }

    protected String addPostRunDependent(Creatable<? extends Indexable> creatable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)creatable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Appliable<? extends Indexable> appliable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)appliable);
        return this.addPostRunDependent(dependency);
    }

    protected String addPostRunDependent(Executable<? extends Indexable> executable) {
        TaskGroup.HasTaskGroup dependency = (TaskGroup.HasTaskGroup)((Object)executable);
        return this.addPostRunDependent(dependency);
    }

    protected <T extends Indexable> T taskResult(String key) {
        Indexable result = this.taskGroup.taskResult(key);
        if (result == null) {
            return null;
        }
        Indexable castedResult = result;
        return (T)castedResult;
    }

    @Override
    public Indexable result() {
        return this.taskResult;
    }

    @Override
    public void beforeGroupInvoke() {
    }

    @Override
    public boolean isHot() {
        return false;
    }

    @Override
    public Mono<Indexable> invokeAsync(TaskGroup.InvocationContext context) {
        return this.invokeTaskAsync(context).subscribeOn(ResourceManagerUtils.InternalRuntimeContext.getReactorScheduler()).map(result -> {
            this.taskResult = result;
            return result;
        });
    }

    @Override
    public Mono<Void> invokeAfterPostRunAsync(boolean isGroupFaulted) {
        return Mono.empty();
    }

    protected abstract Mono<Indexable> invokeTaskAsync(TaskGroup.InvocationContext var1);

    protected Indexable voidIndexable() {
        return new VoidIndexable(this.key);
    }

    protected Mono<Indexable> voidPublisher() {
        return Mono.just((Object)this.voidIndexable());
    }
}

