/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.server.master.cluster;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.dolphinscheduler.server.master.cluster.IMasterSlotReBalancer;
import org.apache.dolphinscheduler.server.master.cluster.MasterServerMetadata;
import org.apache.dolphinscheduler.server.master.config.MasterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MasterSlotManager
implements IMasterSlotReBalancer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MasterSlotManager.class);
    private final MasterConfig masterConfig;
    private volatile int currentSlot = -1;
    private volatile int totalSlots = 0;

    public MasterSlotManager(MasterConfig masterConfig) {
        this.masterConfig = masterConfig;
    }

    public int getCurrentMasterSlot() {
        return this.currentSlot;
    }

    public int getTotalMasterSlots() {
        return this.totalSlots;
    }

    public boolean checkSlotValid() {
        return this.totalSlots > 0 && this.currentSlot >= 0;
    }

    @Override
    public void doReBalance(List<MasterServerMetadata> normalMasterServers) {
        normalMasterServers = normalMasterServers.stream().sorted(MasterServerMetadata::compareTo).collect(Collectors.toList());
        int tmpCurrentSlot = -1;
        for (int i = 0; i < normalMasterServers.size(); ++i) {
            if (!normalMasterServers.get(i).getAddress().equals(this.masterConfig.getMasterAddress())) continue;
            tmpCurrentSlot = i;
            break;
        }
        if (tmpCurrentSlot == -1) {
            log.warn("Do rebalance failed, cannot found the current master: {} in the normal master clusters: {}. Please check the current master server status", (Object)this.masterConfig.getMasterAddress(), normalMasterServers);
            this.currentSlot = -1;
            return;
        }
        if (this.totalSlots == normalMasterServers.size() && this.currentSlot == tmpCurrentSlot) {
            log.debug("No need to rebalance, the currentSlot: {}, totalSlots: {} doesn't changed", (Object)this.currentSlot, (Object)this.totalSlots);
            return;
        }
        this.totalSlots = normalMasterServers.size();
        this.currentSlot = tmpCurrentSlot;
        log.info("Do rebalance success, current master slot: {}, total master slots: {}", (Object)this.currentSlot, (Object)this.totalSlots);
    }
}

