/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.eventhubs.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.eventhubs.fluent.models.PrivateEndpointConnectionInner;
import com.azure.resourcemanager.eventhubs.models.Encryption;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class EHNamespaceProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(EHNamespaceProperties.class);
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private String provisioningState;
    @JsonProperty(value="status", access=JsonProperty.Access.WRITE_ONLY)
    private String status;
    @JsonProperty(value="createdAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime createdAt;
    @JsonProperty(value="updatedAt", access=JsonProperty.Access.WRITE_ONLY)
    private OffsetDateTime updatedAt;
    @JsonProperty(value="serviceBusEndpoint", access=JsonProperty.Access.WRITE_ONLY)
    private String serviceBusEndpoint;
    @JsonProperty(value="clusterArmId")
    private String clusterArmId;
    @JsonProperty(value="metricId", access=JsonProperty.Access.WRITE_ONLY)
    private String metricId;
    @JsonProperty(value="isAutoInflateEnabled")
    private Boolean isAutoInflateEnabled;
    @JsonProperty(value="maximumThroughputUnits")
    private Integer maximumThroughputUnits;
    @JsonProperty(value="kafkaEnabled")
    private Boolean kafkaEnabled;
    @JsonProperty(value="zoneRedundant")
    private Boolean zoneRedundant;
    @JsonProperty(value="encryption")
    private Encryption encryption;
    @JsonProperty(value="privateEndpointConnections")
    private List<PrivateEndpointConnectionInner> privateEndpointConnections;
    @JsonProperty(value="disableLocalAuth")
    private Boolean disableLocalAuth;
    @JsonProperty(value="alternateName")
    private String alternateName;

    public String provisioningState() {
        return this.provisioningState;
    }

    public String status() {
        return this.status;
    }

    public OffsetDateTime createdAt() {
        return this.createdAt;
    }

    public OffsetDateTime updatedAt() {
        return this.updatedAt;
    }

    public String serviceBusEndpoint() {
        return this.serviceBusEndpoint;
    }

    public String clusterArmId() {
        return this.clusterArmId;
    }

    public EHNamespaceProperties withClusterArmId(String clusterArmId) {
        this.clusterArmId = clusterArmId;
        return this;
    }

    public String metricId() {
        return this.metricId;
    }

    public Boolean isAutoInflateEnabled() {
        return this.isAutoInflateEnabled;
    }

    public EHNamespaceProperties withIsAutoInflateEnabled(Boolean isAutoInflateEnabled) {
        this.isAutoInflateEnabled = isAutoInflateEnabled;
        return this;
    }

    public Integer maximumThroughputUnits() {
        return this.maximumThroughputUnits;
    }

    public EHNamespaceProperties withMaximumThroughputUnits(Integer maximumThroughputUnits) {
        this.maximumThroughputUnits = maximumThroughputUnits;
        return this;
    }

    public Boolean kafkaEnabled() {
        return this.kafkaEnabled;
    }

    public EHNamespaceProperties withKafkaEnabled(Boolean kafkaEnabled) {
        this.kafkaEnabled = kafkaEnabled;
        return this;
    }

    public Boolean zoneRedundant() {
        return this.zoneRedundant;
    }

    public EHNamespaceProperties withZoneRedundant(Boolean zoneRedundant) {
        this.zoneRedundant = zoneRedundant;
        return this;
    }

    public Encryption encryption() {
        return this.encryption;
    }

    public EHNamespaceProperties withEncryption(Encryption encryption) {
        this.encryption = encryption;
        return this;
    }

    public List<PrivateEndpointConnectionInner> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    public EHNamespaceProperties withPrivateEndpointConnections(List<PrivateEndpointConnectionInner> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    public Boolean disableLocalAuth() {
        return this.disableLocalAuth;
    }

    public EHNamespaceProperties withDisableLocalAuth(Boolean disableLocalAuth) {
        this.disableLocalAuth = disableLocalAuth;
        return this;
    }

    public String alternateName() {
        return this.alternateName;
    }

    public EHNamespaceProperties withAlternateName(String alternateName) {
        this.alternateName = alternateName;
        return this;
    }

    public void validate() {
        if (this.encryption() != null) {
            this.encryption().validate();
        }
        if (this.privateEndpointConnections() != null) {
            this.privateEndpointConnections().forEach(e -> e.validate());
        }
    }
}

