/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.monitor.implementation;

import com.azure.core.management.Resource;
import com.azure.resourcemanager.monitor.MonitorManager;
import com.azure.resourcemanager.monitor.fluent.MonitorClient;
import com.azure.resourcemanager.monitor.fluent.models.ActivityLogAlertResourceInner;
import com.azure.resourcemanager.monitor.models.ActionList;
import com.azure.resourcemanager.monitor.models.ActivityLogAlert;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertActionGroup;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertAllOfCondition;
import com.azure.resourcemanager.monitor.models.ActivityLogAlertLeafCondition;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.models.HasId;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import reactor.core.publisher.Mono;

class ActivityLogAlertImpl
extends GroupableResourceImpl<ActivityLogAlert, ActivityLogAlertResourceInner, ActivityLogAlertImpl, MonitorManager>
implements ActivityLogAlert,
ActivityLogAlert.Definition,
ActivityLogAlert.Update,
ActivityLogAlert.UpdateStages.WithActivityLogUpdate {
    private Map<String, String> conditions = new TreeMap<String, String>();

    ActivityLogAlertImpl(String name, ActivityLogAlertResourceInner innerModel, MonitorManager monitorManager) {
        super(name, (Resource)innerModel, (Manager)monitorManager);
        if (innerModel.condition() != null && innerModel.condition().allOf() != null) {
            for (ActivityLogAlertLeafCondition aac : innerModel.condition().allOf()) {
                if (aac.field() == null || aac.equals() == null) continue;
                this.conditions.put(aac.field(), aac.equals());
            }
        }
    }

    @Override
    public Collection<String> scopes() {
        return Collections.unmodifiableCollection(((ActivityLogAlertResourceInner)((Object)this.innerModel())).scopes());
    }

    @Override
    public Boolean enabled() {
        return ((ActivityLogAlertResourceInner)((Object)this.innerModel())).enabled();
    }

    @Override
    public Map<String, String> equalsConditions() {
        return this.conditions;
    }

    @Override
    public Collection<String> actionGroupIds() {
        if (((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions() != null && ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups() != null) {
            ArrayList<String> ids = new ArrayList<String>();
            for (ActivityLogAlertActionGroup alaag : ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups()) {
                ids.add(alaag.actionGroupId());
            }
            return Collections.unmodifiableCollection(ids);
        }
        return Collections.emptyList();
    }

    @Override
    public String description() {
        return ((ActivityLogAlertResourceInner)((Object)this.innerModel())).description();
    }

    public Mono<ActivityLogAlert> createResourceAsync() {
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withLocation("global");
        ActivityLogAlertAllOfCondition condition = new ActivityLogAlertAllOfCondition();
        condition.withAllOf(new ArrayList<ActivityLogAlertLeafCondition>());
        for (Map.Entry<String, String> cds : this.conditions.entrySet()) {
            ActivityLogAlertLeafCondition alalc = new ActivityLogAlertLeafCondition();
            alalc.withField(cds.getKey());
            alalc.withEquals(cds.getValue());
            condition.allOf().add(alalc);
        }
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withCondition(condition);
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getActivityLogAlerts().createOrUpdateAsync(this.resourceGroupName(), this.name(), (ActivityLogAlertResourceInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<ActivityLogAlertResourceInner> getInnerAsync() {
        return ((MonitorClient)((MonitorManager)this.manager()).serviceClient()).getActivityLogAlerts().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetResource(String resourceId) {
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withScopes(new ArrayList<String>());
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).scopes().add(resourceId);
        return this;
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetResource(HasId resource) {
        return this.withTargetResource(resource.id());
    }

    @Override
    public ActivityLogAlert.DefinitionStages.WithDescription withTargetSubscription(String targetSubscriptionId) {
        return this.withTargetResource("/subscriptions/" + targetSubscriptionId);
    }

    @Override
    public ActivityLogAlertImpl withDescription(String description) {
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withDescription(description);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withRuleEnabled() {
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withEnabled(true);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withRuleDisabled() {
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withEnabled(false);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withActionGroups(String ... actionGroupId) {
        if (((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions() == null) {
            ((ActivityLogAlertResourceInner)((Object)this.innerModel())).withActions(new ActionList());
            ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().withActionGroups(new ArrayList<ActivityLogAlertActionGroup>());
        }
        ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups().clear();
        for (String agid : actionGroupId) {
            ActivityLogAlertActionGroup aaa = new ActivityLogAlertActionGroup();
            aaa.withActionGroupId(agid);
            ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups().add(aaa);
        }
        return this;
    }

    @Override
    public ActivityLogAlertImpl withoutActionGroup(String actionGroupId) {
        if (((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions() != null && ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups() != null) {
            ArrayList<ActivityLogAlertActionGroup> toDelete = new ArrayList<ActivityLogAlertActionGroup>();
            for (ActivityLogAlertActionGroup aaa : ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups()) {
                if (!aaa.actionGroupId().equalsIgnoreCase(actionGroupId)) continue;
                toDelete.add(aaa);
            }
            ((ActivityLogAlertResourceInner)((Object)this.innerModel())).actions().actionGroups().removeAll(toDelete);
        }
        return this;
    }

    @Override
    public ActivityLogAlertImpl withEqualsCondition(String field, String equals) {
        this.withoutEqualsCondition(field);
        this.conditions.put(field, equals);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withEqualsConditions(Map<String, String> fieldEqualsMap) {
        this.conditions.clear();
        this.conditions.putAll(fieldEqualsMap);
        return this;
    }

    @Override
    public ActivityLogAlertImpl withoutEqualsCondition(String field) {
        if (this.conditions.containsKey(field)) {
            this.conditions.remove(field);
        }
        return this;
    }
}

