/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dolphinscheduler.api.controller;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.util.List;
import lombok.Generated;
import org.apache.dolphinscheduler.api.audit.OperatorLog;
import org.apache.dolphinscheduler.api.audit.enums.AuditType;
import org.apache.dolphinscheduler.api.controller.BaseController;
import org.apache.dolphinscheduler.api.enums.Status;
import org.apache.dolphinscheduler.api.exceptions.ApiException;
import org.apache.dolphinscheduler.api.service.AlertPluginInstanceService;
import org.apache.dolphinscheduler.api.utils.PageInfo;
import org.apache.dolphinscheduler.api.utils.Result;
import org.apache.dolphinscheduler.api.vo.AlertPluginInstanceVO;
import org.apache.dolphinscheduler.dao.entity.AlertPluginInstance;
import org.apache.dolphinscheduler.dao.entity.User;
import org.apache.dolphinscheduler.plugin.task.api.utils.ParameterUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;

@Tag(name="ALERT_PLUGIN_INSTANCE_TAG")
@RestController
@RequestMapping(value={"alert-plugin-instances"})
public class AlertPluginInstanceController
extends BaseController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AlertPluginInstanceController.class);
    @Autowired
    private AlertPluginInstanceService alertPluginInstanceService;

    @Operation(summary="createAlertPluginInstance", description="CREATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="pluginDefineId", description="ALERT_PLUGIN_DEFINE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="instanceName", description="ALERT_PLUGIN_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class, example="DING TALK")), @Parameter(name="pluginInstanceParams", description="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, schema=@Schema(implementation=String.class, example="ALERT_PLUGIN_INSTANCE_PARAMS"))})
    @PostMapping
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiException(value=Status.CREATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @OperatorLog(auditType=AuditType.ALARM_INSTANCE_CREATE)
    public Result<AlertPluginInstance> createAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="pluginDefineId") int pluginDefineId, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        AlertPluginInstance alertPluginInstance = this.alertPluginInstanceService.create(loginUser, pluginDefineId, instanceName, pluginInstanceParams);
        return Result.success(alertPluginInstance);
    }

    @Operation(summary="testSendAlertPluginInstance", description="TEST_SEND_ALERT_PLUGIN_INSTANCE")
    @Parameters(value={@Parameter(name="pluginDefineId", description="ALERT_PLUGIN_DEFINE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="pluginInstanceParams", description="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, schema=@Schema(implementation=String.class, example="ALERT_PLUGIN_INSTANCE_PARAMS"))})
    @PostMapping(value={"/test-send"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.SEND_TEST_ALERT_PLUGIN_INSTANCE_ERROR)
    public Result<Boolean> testSendAlertPluginInstance(@RequestParam(value="pluginDefineId") int pluginDefineId, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        this.alertPluginInstanceService.testSend(pluginDefineId, pluginInstanceParams);
        return Result.success(true);
    }

    @Operation(summary="updateAlertPluginInstance", description="UPDATE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="alertPluginInstanceId", description="ALERT_PLUGIN_INSTANCE_ID", required=true, schema=@Schema(implementation=int.class, example="100")), @Parameter(name="instanceName", description="ALERT_PLUGIN_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class, example="DING TALK")), @Parameter(name="pluginInstanceParams", description="ALERT_PLUGIN_INSTANCE_PARAMS", required=true, schema=@Schema(implementation=String.class, example="ALERT_PLUGIN_INSTANCE_PARAMS"))})
    @PutMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.UPDATE_ALERT_PLUGIN_INSTANCE_ERROR)
    @OperatorLog(auditType=AuditType.ALARM_INSTANCE_UPDATE)
    public Result<AlertPluginInstance> updateAlertPluginInstanceById(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id, @RequestParam(value="instanceName") String instanceName, @RequestParam(value="pluginInstanceParams") String pluginInstanceParams) {
        AlertPluginInstance alertPluginInstance = this.alertPluginInstanceService.updateById(loginUser, id, instanceName, pluginInstanceParams);
        return Result.success(alertPluginInstance);
    }

    @Operation(summary="deleteAlertPluginInstance", description="DELETE_ALERT_PLUGIN_INSTANCE_NOTES")
    @Parameters(value={@Parameter(name="id", description="ALERT_PLUGIN_ID", required=true, schema=@Schema(implementation=int.class, example="100"))})
    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.DELETE_ALERT_PLUGIN_INSTANCE_ERROR)
    @OperatorLog(auditType=AuditType.ALARM_INSTANCE_DELETE)
    public Result<Boolean> deleteAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        this.alertPluginInstanceService.deleteById(loginUser, id);
        return Result.success(true);
    }

    @Operation(summary="getAlertPluginInstance", description="GET_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.GET_ALERT_PLUGIN_INSTANCE_ERROR)
    public Result<AlertPluginInstance> getAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @PathVariable(value="id") int id) {
        AlertPluginInstance alertPluginInstance = this.alertPluginInstanceService.getById(loginUser, id);
        return Result.success(alertPluginInstance);
    }

    @Operation(summary="queryAlertPluginInstanceList", description="QUERY_ALL_ALERT_PLUGIN_INSTANCE_NOTES")
    @GetMapping(value={"/list"})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.QUERY_ALL_ALERT_PLUGIN_INSTANCE_ERROR)
    public Result<List<AlertPluginInstanceVO>> getAlertPluginInstance(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser) {
        List<AlertPluginInstanceVO> alertPluginInstanceVOS = this.alertPluginInstanceService.queryAll();
        return Result.success(alertPluginInstanceVOS);
    }

    @Operation(summary="verifyAlertInstanceName", description="VERIFY_ALERT_INSTANCE_NAME_NOTES")
    @Parameters(value={@Parameter(name="alertInstanceName", description="ALERT_INSTANCE_NAME", required=true, schema=@Schema(implementation=String.class))})
    @GetMapping(value={"/verify-name"})
    @ResponseStatus(value=HttpStatus.OK)
    public Result verifyGroupName(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="alertInstanceName") String alertInstanceName) {
        boolean exist = this.alertPluginInstanceService.checkExistPluginInstanceName(alertInstanceName);
        if (exist) {
            log.error("alert plugin instance {} has exist, can't create again.", (Object)alertInstanceName);
            return Result.error(Status.PLUGIN_INSTANCE_ALREADY_EXISTS);
        }
        return Result.success();
    }

    @Operation(summary="queryAlertPluginInstanceListPaging", description="QUERY_ALERT_PLUGIN_INSTANCE_LIST_PAGING_NOTES")
    @Parameters(value={@Parameter(name="searchVal", description="SEARCH_VAL", schema=@Schema(implementation=String.class)), @Parameter(name="pageNo", description="PAGE_NO", required=true, schema=@Schema(implementation=int.class, example="1")), @Parameter(name="pageSize", description="PAGE_SIZE", required=true, schema=@Schema(implementation=int.class, example="20"))})
    @GetMapping
    @ResponseStatus(value=HttpStatus.OK)
    @ApiException(value=Status.LIST_PAGING_ALERT_PLUGIN_INSTANCE_ERROR)
    public Result<PageInfo<AlertPluginInstanceVO>> listPaging(@Parameter(hidden=true) @RequestAttribute(value="session.user") User loginUser, @RequestParam(value="searchVal", required=false) String searchVal, @RequestParam(value="pageNo") Integer pageNo, @RequestParam(value="pageSize") Integer pageSize) {
        this.checkPageParams(pageNo, pageSize);
        searchVal = ParameterUtils.handleEscapes((String)searchVal);
        PageInfo<AlertPluginInstanceVO> alertPluginInstanceVOPageInfo = this.alertPluginInstanceService.listPaging(loginUser, searchVal, pageNo, pageSize);
        return Result.success(alertPluginInstanceVOPageInfo);
    }
}

