/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.util.cache;

import net.sf.ehcache.Element;
import net.sf.ehcache.constructs.blocking.BlockingCache;
import net.sf.ehcache.constructs.blocking.LockTimeoutException;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import org.apache.directory.fortress.core.CfgRuntimeException;
import org.apache.directory.fortress.core.util.cache.Cache;
import org.apache.directory.fortress.core.util.cache.CacheException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EhCacheImpl
implements Cache {
    private static final String CLS_NM = EhCacheImpl.class.getName();
    private static final Logger LOG = LoggerFactory.getLogger((String)CLS_NM);
    private BlockingCache cache;
    private final String name;

    EhCacheImpl(String name, BlockingCache blockingCache) {
        this.name = name;
        if (blockingCache == null) {
            String error = " constructor cache: " + name + " is null";
            throw new CfgRuntimeException(129, error);
        }
        this.cache = blockingCache;
    }

    @Override
    public Object get(Object key) throws CacheException {
        if (this.cache == null) {
            String error = "get detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        try {
            Element element = this.cache.get(key);
            if (element != null) {
                return element.getObjectValue();
            }
            return null;
        }
        catch (LockTimeoutException lte) {
            LOG.warn("Lock timout exception for key {}", key);
            return null;
        }
        catch (net.sf.ehcache.CacheException ce) {
            String error = "get cache name [" + this.name + "] key [" + key + "] caught CacheException=" + ce.getMessage();
            throw new CacheException(130, error, (Exception)((Object)ce));
        }
    }

    @Override
    public void put(Object key, Object value) throws CacheException {
        if (this.cache == null) {
            String error = "put detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        try {
            this.cache.put(new Element(key, value));
        }
        catch (net.sf.ehcache.CacheException ce) {
            String error = "put cache name [" + this.name + "] key [" + key + "] caught CacheException=" + ce.getMessage();
            throw new CacheException(131, error, (Exception)((Object)ce));
        }
    }

    @Override
    public boolean clear(Object key) throws CacheException {
        boolean result;
        if (this.cache == null) {
            String error = "clear detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        try {
            result = this.cache.remove(key);
        }
        catch (net.sf.ehcache.CacheException ce) {
            String error = "clear cache name [" + this.name + "] key [" + key + "] caught CacheException=" + ce.getMessage();
            throw new CacheException(132, error, (Exception)((Object)ce));
        }
        return result;
    }

    @Override
    public void flush() throws CacheException {
        if (this.cache == null) {
            String error = "flush detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        try {
            this.cache.removeAll();
        }
        catch (net.sf.ehcache.CacheException ce) {
            String error = "flush cache name [" + this.name + "] caught CacheException=" + ce.getMessage();
            throw new CacheException(133, error, (Exception)((Object)ce));
        }
    }

    @Override
    public <T> Attribute<T> getSearchAttribute(String attributeName) throws CacheException {
        if (this.cache == null) {
            String error = "getSearchAttribute detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        return this.cache.getSearchAttribute(attributeName);
    }

    @Override
    public Query createQuery() {
        if (this.cache == null) {
            String error = "createQuery detected null cache name [" + this.name + "]";
            throw new CacheException(134, error);
        }
        return this.cache.createQuery();
    }

    public void clear() {
        this.cache.flush();
    }
}

