/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.util.List;
import org.apache.directory.fortress.annotation.AdminPermissionOperation;
import org.apache.directory.fortress.core.PwPolicyMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.impl.PolicyP;
import org.apache.directory.fortress.core.impl.UserP;
import org.apache.directory.fortress.core.model.PwPolicy;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.util.VUtil;

public class PwPolicyMgrImpl
extends Manageable
implements PwPolicyMgr {
    private static final String CLS_NM = PwPolicyMgrImpl.class.getName();
    private PolicyP policyP = new PolicyP();
    private UserP userP = new UserP();

    @Override
    @AdminPermissionOperation
    public void add(PwPolicy policy) throws SecurityException {
        String methodName = "add";
        this.assertContext(CLS_NM, methodName, policy, 4023);
        this.setEntitySession(CLS_NM, methodName, policy);
        this.policyP.add(policy);
    }

    @Override
    @AdminPermissionOperation
    public void update(PwPolicy policy) throws SecurityException {
        String methodName = "update";
        this.assertContext(CLS_NM, methodName, policy, 4023);
        this.setEntitySession(CLS_NM, methodName, policy);
        this.policyP.update(policy);
    }

    @Override
    @AdminPermissionOperation
    public void delete(PwPolicy policy) throws SecurityException {
        String methodName = "delete";
        this.assertContext(CLS_NM, methodName, policy, 4023);
        policy.setAdminSession(this.adminSess);
        this.setEntitySession(CLS_NM, methodName, policy);
        this.policyP.delete(policy);
    }

    @Override
    @AdminPermissionOperation
    public PwPolicy read(String name) throws SecurityException {
        String methodName = "read";
        VUtil.assertNotNullOrEmpty(name, 4022, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        PwPolicy policy = new PwPolicy(name);
        policy.setContextId(this.contextId);
        return this.policyP.read(policy);
    }

    @Override
    @AdminPermissionOperation
    public List<PwPolicy> search(String searchVal) throws SecurityException {
        String methodName = "search";
        VUtil.assertNotNull(searchVal, 4022, CLS_NM + "." + methodName);
        this.checkAccess(CLS_NM, methodName);
        PwPolicy policy = new PwPolicy(searchVal);
        policy.setContextId(this.contextId);
        return this.policyP.search(policy);
    }

    @Override
    @AdminPermissionOperation
    public void updateUserPolicy(String userId, String policyName) throws SecurityException {
        String methodName = "updateUserPolicy";
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + "." + methodName);
        VUtil.assertNotNullOrEmpty(policyName, 4022, CLS_NM + "." + methodName);
        User user = new User(userId);
        user.setPwPolicy(policyName);
        user.setAdminSession(this.adminSess);
        this.setEntitySession(CLS_NM, methodName, user);
        this.userP.update(user);
    }

    @Override
    @AdminPermissionOperation
    public void deletePasswordPolicy(String userId) throws SecurityException {
        String methodName = "deletePasswordPolicy";
        VUtil.assertNotNullOrEmpty(userId, 1008, CLS_NM + "." + methodName);
        User user = new User(userId);
        user.setAdminSession(this.adminSess);
        this.setEntitySession(CLS_NM, methodName, user);
        this.userP.deletePwPolicy(user);
    }
}

