/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import org.apache.directory.fortress.core.AuthorizationException;
import org.apache.directory.fortress.core.DelAccessMgr;
import org.apache.directory.fortress.core.DelAccessMgrFactory;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.model.FortEntity;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Role;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;

final class AdminUtil {
    private AdminUtil() {
    }

    static void canAssign(Session session, User user, Role role, String contextId) throws SecurityException {
        DelAccessMgr dAccessMgr;
        boolean result;
        if (session != null && !(result = (dAccessMgr = DelAccessMgrFactory.createInstance(contextId)).canAssign(session, user, role))) {
            String warning = "canAssign Role [" + role.getName() + "] User [" + user.getUserId() + "] Admin [" + session.getUserId() + "] failed check.";
            throw new SecurityException(2023, warning);
        }
    }

    static void canDeassign(Session session, User user, Role role, String contextId) throws SecurityException {
        DelAccessMgr dAccessMgr;
        boolean result;
        if (session != null && !(result = (dAccessMgr = DelAccessMgrFactory.createInstance(contextId)).canDeassign(session, user, role))) {
            String warning = "canDeassign Role [" + role.getName() + "] User [" + user.getUserId() + "] Admin [" + session.getUserId() + "] failed check.";
            throw new SecurityException(2024, warning);
        }
    }

    static void canGrant(Session session, Role role, Permission perm, String contextId) throws SecurityException {
        DelAccessMgr dAccessMgr;
        boolean result;
        if (session != null && !(result = (dAccessMgr = DelAccessMgrFactory.createInstance(contextId)).canGrant(session, role, perm))) {
            String warning = "canGrant Role [" + role.getName() + "] Perm object [" + perm.getObjName() + "] Perm Operation [" + perm.getOpName() + "] Admin [" + session.getUserId() + "] failed check.";
            throw new SecurityException(2025, warning);
        }
    }

    static void canRevoke(Session session, Role role, Permission perm, String contextId) throws SecurityException {
        DelAccessMgr dAccessMgr;
        boolean result;
        if (session != null && !(result = (dAccessMgr = DelAccessMgrFactory.createInstance(contextId)).canRevoke(session, role, perm))) {
            String warning = "canRevoke Role [" + role.getName() + "] Perm object [" + perm.getObjName() + "] Perm Operation [" + perm.getOpName() + "] Admin [" + session.getUserId() + "] failed check.";
            throw new SecurityException(2026, warning);
        }
    }

    static void canDo(Session session, User user, String contextId, boolean isAdd) throws SecurityException {
        if (session != null) {
            DelAccessMgr dAccessMgr = DelAccessMgrFactory.createInstance(contextId);
            if (isAdd) {
                boolean result = dAccessMgr.canAdd(session, user);
                if (!result) {
                    String warning = "canDo User [" + user.getUserId() + "] Admin [" + session.getUserId() + "] failed check.";
                    throw new SecurityException(1039, warning);
                }
            } else {
                boolean result = dAccessMgr.canEdit(session, user);
                if (!result) {
                    String warning = "canDo User [" + user.getUserId() + "] Admin [" + session.getUserId() + "] failed check.";
                    throw new SecurityException(1040, warning);
                }
            }
        }
    }

    static void setEntitySession(Session session, Permission perm, FortEntity entity, String contextId) throws SecurityException {
        if (session != null) {
            entity.setAdminSession(session);
            entity.setModCode(AdminUtil.getObjName(perm.getObjName()) + "." + perm.getOpName());
            AdminUtil.checkAccess(session, perm, contextId);
        }
    }

    static void checkAccess(Session session, Permission perm, String contextId) throws SecurityException {
        DelAccessMgr dAccessMgr;
        boolean result;
        if (session != null && !(result = (dAccessMgr = DelAccessMgrFactory.createInstance(contextId)).checkAccess(session, perm))) {
            String info = "checkAccess failed for user [" + session.getUserId() + "] object [" + perm.getObjName() + "] operation [" + perm.getOpName() + "]";
            throw new AuthorizationException(1031, info);
        }
    }

    static String getObjName(String szObj) {
        return szObj.substring(szObj.lastIndexOf(46) + 1);
    }
}

