/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.fortress.core.impl;

import java.io.Serializable;
import java.util.List;
import org.apache.directory.fortress.core.AccelMgr;
import org.apache.directory.fortress.core.SecurityException;
import org.apache.directory.fortress.core.impl.AcceleratorDAO;
import org.apache.directory.fortress.core.impl.AccessMgrImpl;
import org.apache.directory.fortress.core.impl.Manageable;
import org.apache.directory.fortress.core.model.Permission;
import org.apache.directory.fortress.core.model.Session;
import org.apache.directory.fortress.core.model.User;
import org.apache.directory.fortress.core.model.UserRole;
import org.apache.directory.fortress.core.util.VUtil;

public class AccelMgrImpl
extends Manageable
implements AccelMgr,
Serializable {
    private static final String CLS_NM = AccessMgrImpl.class.getName();
    private AcceleratorDAO aDao = new AcceleratorDAO();

    @Override
    public Session createSession(User user, boolean isTrusted) throws SecurityException {
        String methodName = "createSession";
        this.assertContext(CLS_NM, methodName, user, 1008);
        return this.aDao.createSession(user);
    }

    @Override
    public void deleteSession(Session session) throws SecurityException {
        String methodName = "deleteSession";
        this.assertContext(CLS_NM, methodName, session, 1030);
        this.aDao.deleteSession(session);
    }

    @Override
    public List<UserRole> sessionRoles(Session session) throws SecurityException {
        String methodName = "sessionRoles";
        this.assertContext(CLS_NM, methodName, session, 1030);
        return this.aDao.sessionRoles(session);
    }

    @Override
    public boolean checkAccess(Session session, Permission perm) throws SecurityException {
        String methodName = "checkAccess";
        this.assertContext(CLS_NM, methodName, perm, 3008);
        this.assertContext(CLS_NM, methodName, session, 1030);
        VUtil.assertNotNullOrEmpty(perm.getOpName(), 3009, this.getFullMethodName(CLS_NM, methodName));
        VUtil.assertNotNullOrEmpty(perm.getObjName(), 3010, this.getFullMethodName(CLS_NM, methodName));
        return this.aDao.checkAccess(session, perm);
    }

    @Override
    public List<Permission> sessionPermissions(Session session) throws SecurityException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addActiveRole(Session session, UserRole role) throws SecurityException {
        String methodName = "addActiveRole";
        this.assertContext(CLS_NM, methodName, session, 1030);
        this.assertContext(CLS_NM, methodName, role, 5007);
        VUtil.assertNotNullOrEmpty(role.getUserId(), 1006, this.getFullMethodName(CLS_NM, methodName));
        VUtil.assertNotNullOrEmpty(role.getName(), 5005, this.getFullMethodName(CLS_NM, methodName));
        this.aDao.addActiveRole(session, role);
    }

    @Override
    public void dropActiveRole(Session session, UserRole role) throws SecurityException {
        String methodName = "dropActiveRole";
        this.assertContext(CLS_NM, methodName, session, 1030);
        this.assertContext(CLS_NM, methodName, role, 5007);
        VUtil.assertNotNullOrEmpty(role.getUserId(), 1006, this.getFullMethodName(CLS_NM, methodName));
        VUtil.assertNotNullOrEmpty(role.getName(), 5005, this.getFullMethodName(CLS_NM, methodName));
        this.aDao.dropActiveRole(session, role);
    }
}

