/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.generator.template.groovy;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.torque.generator.GeneratorException;
import org.apache.torque.generator.configuration.ConfigurationException;
import org.apache.torque.generator.configuration.ConfigurationProvider;
import org.apache.torque.generator.control.ControllerState;
import org.apache.torque.generator.option.Option;
import org.apache.torque.generator.option.Options;
import org.apache.torque.generator.outlet.OutletResult;
import org.apache.torque.generator.qname.Namespace;
import org.apache.torque.generator.qname.QualifiedName;
import org.apache.torque.generator.qname.QualifiedNameMap;
import org.apache.torque.generator.source.SourceElement;
import org.apache.torque.generator.template.TemplateOutletImpl;
import org.apache.torque.generator.template.groovy.TorqueGenGroovy;
import org.apache.torque.generator.variable.Variable;
import org.apache.torque.generator.variable.VariableStore;

public abstract class GroovyOutlet
extends TemplateOutletImpl {
    public static final String TORQUE_GEN_BINDING_NAME = "torqueGen";
    public static final String NULL_KEY_BINDING_NAME = "value";
    private static Log log = LogFactory.getLog(GroovyOutlet.class);
    private boolean optionsInBinding = true;
    private boolean variablesInBinding = true;
    private boolean sourceAttributesInBinding = true;

    public GroovyOutlet(QualifiedName name, ConfigurationProvider configurationProvider, String path, String encoding) throws ConfigurationException {
        super(name, configurationProvider, path, encoding, null);
    }

    @Override
    public OutletResult execute(ControllerState controllerState) throws GeneratorException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Start executing GroovyOutlet " + String.valueOf(this.getName())));
        }
        try {
            Map<String, Object> binding = this.createBinding(controllerState);
            String result = this.executeGroovy(binding, controllerState);
            OutletResult outletResult = new OutletResult(result);
            return outletResult;
        }
        catch (Exception e) {
            throw new GeneratorException("Error executing template " + String.valueOf(this.getName()), e);
        }
        finally {
            if (log.isDebugEnabled()) {
                log.debug((Object)("End executing GroovyOutlet " + String.valueOf(this.getName())));
            }
        }
    }

    protected abstract String executeGroovy(Map<String, Object> var1, ControllerState var2) throws GeneratorException;

    public Map<String, Object> createBinding(ControllerState controllerState) {
        HashMap<String, Object> binding = new HashMap<String, Object>();
        binding.put(TORQUE_GEN_BINDING_NAME, new TorqueGenGroovy(this, controllerState));
        if (this.optionsInBinding) {
            Options visibleOptions = controllerState.getVisibleOptions();
            for (Option option : visibleOptions.values()) {
                QualifiedName qualifiedName = option.getQualifiedName();
                binding.put(qualifiedName.getName(), option.getValue());
            }
            log.debug((Object)("Put options in context " + String.valueOf(visibleOptions.keySet())));
        } else {
            log.debug((Object)"options in binding are disabled");
        }
        Object model = controllerState.getModel();
        if (this.sourceAttributesInBinding && model instanceof SourceElement) {
            SourceElement sourceElement = (SourceElement)model;
            Set<String> attributes = sourceElement.getAttributeNames();
            for (String key : attributes) {
                Object value = sourceElement.getAttribute(key);
                if (key == null) {
                    if (sourceElement.getAttributeNames().contains(NULL_KEY_BINDING_NAME)) continue;
                    key = NULL_KEY_BINDING_NAME;
                }
                binding.put(key, value);
            }
            log.debug((Object)("Put attributes in binding " + String.valueOf(attributes)));
        } else {
            log.debug((Object)"source attributes in binding are disabled");
        }
        if (this.variablesInBinding) {
            Namespace namespace = this.getName().getNamespace();
            VariableStore variableStore = controllerState.getVariableStore();
            QualifiedNameMap<Variable> visibleVariables = variableStore.getContent().getInHierarchy(namespace);
            for (Variable variable : visibleVariables.values()) {
                QualifiedName qualifiedName = variable.getName();
                binding.put(qualifiedName.getName(), variable.getValue());
            }
            log.debug((Object)("Put variables in binding " + String.valueOf(visibleVariables.keySet())));
        } else {
            log.debug((Object)"variables in binding are disabled");
        }
        return binding;
    }

    public void setOptionsInBinding(boolean optionsInBinding) {
        this.optionsInBinding = optionsInBinding;
    }

    public boolean isOptionsInBinding() {
        return this.optionsInBinding;
    }

    public void setVariablesInContext(boolean variablesInBinding) {
        this.variablesInBinding = variablesInBinding;
    }

    public boolean isVariablesInBinding() {
        return this.variablesInBinding;
    }

    public void setSourceAttributesInBinding(boolean sourceAttributesInBinding) {
        this.sourceAttributesInBinding = sourceAttributesInBinding;
    }

    public boolean isSourceAttributesInBinding() {
        return this.sourceAttributesInBinding;
    }
}

