/*
 * Decompiled with CFR 0.152.
 */
package org.apache.torque.map;

import java.util.Map;
import org.apache.torque.Column;
import org.apache.torque.Torque;
import org.apache.torque.TorqueException;
import org.apache.torque.criteria.Criteria;
import org.apache.torque.map.ColumnMap;
import org.apache.torque.map.DatabaseMap;
import org.apache.torque.map.TableMap;

public final class MapHelper {
    private MapHelper() {
    }

    public static TableMap getTableMap(Object possibleColumn, Criteria criteria, TableMap defaultTableMap) throws TorqueException {
        Column asColumn;
        if (!(possibleColumn instanceof Column)) {
            return null;
        }
        Column column = (Column)possibleColumn;
        TableMap result = null;
        String tableName = column.getTableName();
        if (tableName == null && (asColumn = criteria.getAsColumns().get(column.getSqlExpression())) != null) {
            tableName = asColumn.getTableName();
        }
        if (tableName != null) {
            String databaseName = criteria.getDbName();
            DatabaseMap databaseMap = Torque.getDatabaseMap(databaseName);
            if (databaseMap != null) {
                result = databaseMap.getTable(tableName);
            }
            if (result != null) {
                return result;
            }
            Map<String, Object> aliases = criteria.getAliases();
            Object aliasMappedTo = aliases.get(tableName);
            if (aliasMappedTo != null && aliasMappedTo instanceof String) {
                tableName = (String)aliasMappedTo;
                result = databaseMap.getTable(tableName);
            }
        }
        if (result == null) {
            result = defaultTableMap;
        }
        return result;
    }

    public static ColumnMap getColumnMap(Column column, Criteria criteria) throws TorqueException {
        Map<String, Object> aliases;
        Object aliasMappedTo;
        String tableName = column.getTableName();
        Column asColumn = criteria.getAsColumns().get(column.getSqlExpression());
        if (asColumn != null) {
            column = asColumn;
            tableName = asColumn.getTableName();
        }
        if (tableName == null) {
            return null;
        }
        String databaseName = criteria.getDbName();
        DatabaseMap databaseMap = Torque.getDatabaseMap(databaseName);
        TableMap tableMap = null;
        if (databaseMap != null) {
            tableMap = databaseMap.getTable(tableName);
        }
        if (tableMap == null && (aliasMappedTo = (aliases = criteria.getAliases()).get(tableName)) != null && aliasMappedTo instanceof String) {
            tableName = (String)aliasMappedTo;
            tableMap = databaseMap.getTable(tableName);
        }
        if (tableMap == null) {
            return null;
        }
        return tableMap.getColumn(column.getColumnName());
    }
}

