/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.storage.dfs;

import java.io.IOException;
import java.security.MessageDigest;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.eclipse.jgit.storage.dfs.DfsPackKey;
import org.eclipse.jgit.storage.pack.PackOutputStream;

final class DfsBlock {
    private static final int INFLATE_STRIDE = 512;
    final DfsPackKey pack;
    final long start;
    final long end;
    private final byte[] block;

    DfsBlock(DfsPackKey p, long pos, byte[] buf) {
        this.pack = p;
        this.start = pos;
        this.end = pos + (long)buf.length;
        this.block = buf;
    }

    int size() {
        return this.block.length;
    }

    int remaining(long pos) {
        int ptr = (int)(pos - this.start);
        return this.block.length - ptr;
    }

    boolean contains(DfsPackKey want, long pos) {
        return this.pack == want && this.start <= pos && pos < this.end;
    }

    int copy(long pos, byte[] dstbuf, int dstoff, int cnt) {
        int ptr = (int)(pos - this.start);
        return this.copy(ptr, dstbuf, dstoff, cnt);
    }

    int copy(int p, byte[] b, int o, int n) {
        n = Math.min(this.block.length - p, n);
        System.arraycopy(this.block, p, b, o, n);
        return n;
    }

    int inflate(Inflater inf, long pos, byte[] dstbuf, int dstoff) throws DataFormatException {
        int ptr = (int)(pos - this.start);
        int in = Math.min(512, this.block.length - ptr);
        if (dstoff < dstbuf.length) {
            in = Math.min(in, dstbuf.length - dstoff);
        }
        inf.setInput(this.block, ptr, in);
        while (true) {
            int out;
            if ((out = inf.inflate(dstbuf, dstoff, dstbuf.length - dstoff)) == 0) {
                if (inf.needsInput()) {
                    if ((in = Math.min(512, this.block.length - (ptr += in))) == 0) {
                        return dstoff;
                    }
                    inf.setInput(this.block, ptr, in);
                    continue;
                }
                return dstoff;
            }
            dstoff += out;
        }
    }

    void crc32(CRC32 out, long pos, int cnt) {
        int ptr = (int)(pos - this.start);
        out.update(this.block, ptr, cnt);
    }

    void write(PackOutputStream out, long pos, int cnt, MessageDigest digest) throws IOException {
        int ptr = (int)(pos - this.start);
        out.write(this.block, ptr, cnt);
        if (digest != null) {
            digest.update(this.block, ptr, cnt);
        }
    }

    void check(Inflater inf, byte[] tmp, long pos, int cnt) throws DataFormatException {
        inf.setInput(this.block, (int)(pos - this.start), cnt);
        while (inf.inflate(tmp, 0, tmp.length) > 0) {
        }
    }
}

