/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.utils.ExceptionUtils;
import org.apache.cxf.jaxrs.utils.JAXRSUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.common.CryptoLoader;
import org.apache.cxf.rs.security.common.RSSecurityUtils;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProvider;
import org.apache.cxf.rs.security.saml.authorization.SecurityContextProviderImpl;
import org.apache.cxf.rt.security.saml.utils.SAMLUtils;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.security.SecurityContext;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.OpenSAMLUtil;
import org.apache.wss4j.common.saml.SAMLKeyInfo;
import org.apache.wss4j.common.saml.SAMLKeyInfoProcessor;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.dom.WSDocInfo;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.saml.WSSSAMLKeyInfoProcessor;
import org.apache.wss4j.dom.validate.Credential;
import org.apache.wss4j.dom.validate.SamlAssertionValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.signature.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@PreMatching
public abstract class AbstractSamlInHandler
implements ContainerRequestFilter {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractSamlInHandler.class);
    private Validator samlValidator = new SamlAssertionValidator();
    private boolean keyInfoMustBeAvailable = true;
    private SecurityContextProvider scProvider = new SecurityContextProviderImpl();

    public void setValidator(Validator validator) {
        this.samlValidator = validator;
    }

    public void setSecurityContextProvider(SecurityContextProvider p) {
        this.scProvider = p;
    }

    protected void validateToken(Message message, InputStream tokenStream) {
        Element token = this.readToken(message, tokenStream);
        this.validateToken(message, token);
    }

    protected Element readToken(Message message, InputStream tokenStream) {
        try {
            Document doc = StaxUtils.read((Reader)new InputStreamReader(tokenStream, StandardCharsets.UTF_8));
            return doc.getDocumentElement();
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be read as XML document", ex);
            return null;
        }
    }

    protected void validateToken(Message message, Element tokenElement) {
        this.validateToken(message, this.toWrapper(tokenElement));
    }

    protected SamlAssertionWrapper toWrapper(Element tokenElement) {
        try {
            return new SamlAssertionWrapper(tokenElement);
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be validated", ex);
            return null;
        }
    }

    protected void validateToken(Message message, SamlAssertionWrapper assertion) {
        try {
            RequestData data = new RequestData();
            data.setMsgContext((Object)message);
            this.configureAudienceRestriction(message, data);
            if (assertion.isSigned()) {
                WSSConfig cfg = WSSConfig.getNewInstance();
                data.setWssConfig(cfg);
                data.setCallbackHandler(RSSecurityUtils.getCallbackHandler(message, this.getClass()));
                try {
                    data.setSigVerCrypto(new CryptoLoader().getCrypto(message, "security.signature.crypto", "security.signature.properties"));
                }
                catch (IOException ex) {
                    this.throwFault("Crypto can not be loaded", ex);
                }
                boolean enableRevocation = false;
                String enableRevocationStr = (String)SecurityUtils.getSecurityPropertyValue((String)"security.enableRevocation", (Message)message);
                if (enableRevocationStr != null) {
                    enableRevocation = Boolean.parseBoolean(enableRevocationStr);
                }
                data.setEnableRevocation(enableRevocation);
                Signature sig = assertion.getSignature();
                WSDocInfo docInfo = new WSDocInfo(sig.getDOM().getOwnerDocument());
                data.setWsDocInfo(docInfo);
                SAMLKeyInfo samlKeyInfo = null;
                KeyInfo keyInfo = sig.getKeyInfo();
                if (keyInfo != null) {
                    samlKeyInfo = SAMLUtil.getCredentialFromKeyInfo((Element)keyInfo.getDOM(), (SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data), (Crypto)data.getSigVerCrypto());
                } else if (!this.keyInfoMustBeAvailable) {
                    samlKeyInfo = this.createKeyInfoFromDefaultAlias(data.getSigVerCrypto());
                }
                assertion.verifySignature(samlKeyInfo);
                assertion.parseSubject((SAMLKeyInfoProcessor)new WSSSAMLKeyInfoProcessor(data), data.getSigVerCrypto(), data.getCallbackHandler());
            } else if (this.getTLSCertificates(message) == null) {
                this.throwFault("Assertion must be signed", null);
            }
            if (this.samlValidator != null) {
                Credential credential = new Credential();
                credential.setSamlAssertion(assertion);
                this.samlValidator.validate(credential, data);
            }
            this.checkSubjectConfirmationData(message, assertion);
            this.setSecurityContext(message, assertion);
        }
        catch (Exception ex) {
            this.throwFault("Assertion can not be validated", ex);
        }
    }

    protected void configureAudienceRestriction(Message msg, RequestData reqData) {
        reqData.setAudienceRestrictions(SAMLUtils.getAudienceRestrictions((Message)msg, (boolean)false));
    }

    protected SAMLKeyInfo createKeyInfoFromDefaultAlias(Crypto sigCrypto) throws WSSecurityException {
        try {
            X509Certificate[] certs = RSSecurityUtils.getCertificates(sigCrypto, sigCrypto.getDefaultX509Identifier());
            SAMLKeyInfo samlKeyInfo = new SAMLKeyInfo(new X509Certificate[]{certs[0]});
            samlKeyInfo.setPublicKey(certs[0].getPublicKey());
            return samlKeyInfo;
        }
        catch (Exception ex) {
            LOG.log(Level.FINE, "Error in loading the certificates: " + ex.getMessage(), ex);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_SIGNATURE, ex);
        }
    }

    protected void checkSubjectConfirmationData(Message message, SamlAssertionWrapper assertion) {
        String valSAMLSubjectConf = (String)SecurityUtils.getSecurityPropertyValue((String)"security.validate.saml.subject.conf", (Message)message);
        boolean validateSAMLSubjectConf = true;
        if (valSAMLSubjectConf != null) {
            validateSAMLSubjectConf = Boolean.parseBoolean(valSAMLSubjectConf);
        }
        if (validateSAMLSubjectConf) {
            Certificate[] tlsCerts = this.getTLSCertificates(message);
            if (!this.checkHolderOfKey(message, assertion, tlsCerts)) {
                this.throwFault("Holder Of Key claim fails", null);
            }
            if (!this.checkSenderVouches(message, assertion, tlsCerts)) {
                this.throwFault("Sender vouchers claim fails", null);
            }
            if (!this.checkBearer(assertion, tlsCerts)) {
                this.throwFault("Bearer claim fails", null);
            }
        }
    }

    protected void setSecurityContext(Message message, SamlAssertionWrapper wrapper) {
        if (this.scProvider != null) {
            SecurityContext sc = this.scProvider.getSecurityContext(message, wrapper);
            message.put(SecurityContext.class, (Object)sc);
        }
    }

    private Certificate[] getTLSCertificates(Message message) {
        TLSSessionInfo tlsInfo = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        return tlsInfo != null ? tlsInfo.getPeerCertificates() : null;
    }

    protected void throwFault(String error, Exception ex) {
        String errorMsg = error;
        if (ex != null) {
            errorMsg = errorMsg + ": " + ExceptionUtils.getStackTrace((Throwable)ex);
        }
        LOG.warning(errorMsg);
        Response response = JAXRSUtils.toResponseBuilder((int)401).entity((Object)error).build();
        throw ExceptionUtils.toNotAuthorizedException(null, (Response)response);
    }

    protected boolean checkSenderVouches(Message message, SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        if (tlsCerts != null && tlsCerts.length > 0) {
            return true;
        }
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            SAMLKeyInfo subjectKeyInfo;
            if (!OpenSAMLUtil.isMethodSenderVouches((String)confirmationMethod)) continue;
            Element signedElement = (Element)message.getContent(Element.class);
            Node assertionParent = assertionWrapper.getElement().getParentNode();
            if (assertionParent == signedElement || this.compareCredentials(subjectKeyInfo = assertionWrapper.getSignatureKeyInfo(), message, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    protected boolean checkHolderOfKey(Message message, SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            SAMLKeyInfo subjectKeyInfo;
            if (!OpenSAMLUtil.isMethodHolderOfKey((String)confirmationMethod) || this.compareCredentials(subjectKeyInfo = assertionWrapper.getSubjectKeyInfo(), message, tlsCerts)) continue;
            return false;
        }
        return true;
    }

    private boolean compareCredentials(SAMLKeyInfo subjectKeyInfo, Message message, Certificate[] tlsCerts) {
        X509Certificate[] subjectCerts = subjectKeyInfo.getCerts();
        PublicKey subjectPublicKey = subjectKeyInfo.getPublicKey();
        if (tlsCerts != null && tlsCerts.length > 0 && subjectCerts != null && subjectCerts.length > 0 && tlsCerts[0].equals(subjectCerts[0])) {
            return true;
        }
        if (tlsCerts != null && tlsCerts.length > 0 && subjectPublicKey != null && tlsCerts[0].getPublicKey().equals(subjectPublicKey)) {
            return true;
        }
        try {
            X509Certificate signingCert = (X509Certificate)message.getExchange().getInMessage().get((Object)"xml.security.signing.cert");
            if (subjectCerts != null && subjectCerts.length > 0 && signingCert != null && signingCert.equals(subjectCerts[0])) {
                return true;
            }
            PublicKey signingKey = (PublicKey)message.getExchange().getInMessage().get((Object)"xml.security.signing.public.key");
            if (signingKey != null && signingKey.equals(subjectPublicKey)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    protected boolean checkBearer(SamlAssertionWrapper assertionWrapper, Certificate[] tlsCerts) {
        List confirmationMethods = assertionWrapper.getConfirmationMethods();
        for (String confirmationMethod : confirmationMethods) {
            boolean isBearer = this.isMethodBearer(confirmationMethod);
            if (!isBearer || assertionWrapper.isSigned() || tlsCerts != null && tlsCerts.length != 0) continue;
            return false;
        }
        return true;
    }

    private boolean isMethodBearer(String confirmMethod) {
        return confirmMethod != null && confirmMethod.startsWith("urn:oasis:names:tc:SAML:") && confirmMethod.endsWith(":cm:bearer");
    }

    public void setKeyInfoMustBeAvailable(boolean keyInfoMustBeAvailable) {
        this.keyInfoMustBeAvailable = keyInfoMustBeAvailable;
    }

    static {
        WSProviderConfig.init();
    }
}

