/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.util.ListenerList;

public class ProtocolCommandSupport
implements Serializable {
    private static final long serialVersionUID = -8017692739988399978L;
    private final Object source;
    private final ListenerList<ProtocolCommandListener> listeners = new ListenerList();

    public ProtocolCommandSupport(Object source) {
        this.source = source;
    }

    public void addProtocolCommandListener(ProtocolCommandListener listener) {
        this.listeners.addListener(listener);
    }

    public void fireCommandSent(String command, String message) {
        if (!this.listeners.isEmpty()) {
            ProtocolCommandEvent event = new ProtocolCommandEvent(this.source, command, message);
            this.listeners.forEach(listener -> listener.protocolCommandSent(event));
        }
    }

    public void fireReplyReceived(int replyCode, String message) {
        if (!this.listeners.isEmpty()) {
            ProtocolCommandEvent event = new ProtocolCommandEvent(this.source, replyCode, message);
            this.listeners.forEach(listener -> listener.protocolReplyReceived(event));
        }
    }

    public int getListenerCount() {
        return this.listeners.getListenerCount();
    }

    private void readObject(ObjectInputStream ignored) {
        throw new UnsupportedOperationException("Serialization is not supported");
    }

    public void removeProtocolCommandListener(ProtocolCommandListener listener) {
        this.listeners.removeListener(listener);
    }

    private void writeObject(ObjectOutputStream ignored) {
        throw new UnsupportedOperationException("Serialization is not supported");
    }
}

