/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.net.examples.unix;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.net.finger.FingerClient;

public final class finger {
    public static void main(String[] args) {
        int arg;
        boolean longOutput = false;
        InetAddress address = null;
        for (arg = 0; arg < args.length && args[arg].startsWith("-"); ++arg) {
            if (args[arg].equals("-l")) {
                longOutput = true;
                continue;
            }
            System.err.println("usage: finger [-l] [[[handle][@<server>]] ...]");
            System.exit(1);
        }
        FingerClient finger2 = new FingerClient();
        finger2.setDefaultTimeout(60000);
        if (arg >= args.length) {
            try {
                address = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                System.err.println("Error unknown host: " + e.getMessage());
                System.exit(1);
            }
            try {
                finger2.connect(address);
                System.out.print(finger2.query(longOutput));
                finger2.disconnect();
            }
            catch (IOException e) {
                System.err.println("Error I/O exception: " + e.getMessage());
                System.exit(1);
            }
            return;
        }
        while (arg < args.length) {
            String handle;
            int index = args[arg].lastIndexOf(64);
            if (index == -1) {
                handle = args[arg];
                try {
                    address = InetAddress.getLocalHost();
                }
                catch (UnknownHostException e) {
                    System.err.println("Error unknown host: " + e.getMessage());
                    System.exit(1);
                }
            } else {
                handle = args[arg].substring(0, index);
                String host = args[arg].substring(index + 1);
                try {
                    address = InetAddress.getByName(host);
                    System.out.println("[" + address.getHostName() + "]");
                }
                catch (UnknownHostException e) {
                    System.err.println("Error unknown host: " + e.getMessage());
                    System.exit(1);
                }
            }
            try {
                finger2.connect(address);
                System.out.print(finger2.query(longOutput, handle));
                finger2.disconnect();
            }
            catch (IOException e) {
                System.err.println("Error I/O exception: " + e.getMessage());
                System.exit(1);
            }
            if (++arg == args.length) continue;
            System.out.print("\n");
        }
    }
}

