/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3.concurrent;

import java.util.function.Function;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.concurrent.Memoizer;
import org.easymock.EasyMock;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class MemoizerFunctionTest
extends AbstractLangTest {
    private Function<Integer, Integer> function;

    MemoizerFunctionTest() {
    }

    @BeforeEach
    public void setUpComputableMock() {
        this.function = (Function)EasyMock.mock(Function.class);
    }

    @Test
    void testDefaultBehaviourNotToRecalculateExecutionExceptions() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.function);
        IllegalArgumentException interruptedException = new IllegalArgumentException();
        EasyMock.expect((Object)this.function.apply(input)).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        LangAssertions.assertIllegalArgumentException(() -> memoizer.compute((Object)input));
    }

    @Test
    void testDoesNotRecalculateWhenSetToFalse() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.function, false);
        IllegalArgumentException interruptedException = new IllegalArgumentException();
        EasyMock.expect((Object)this.function.apply(input)).andThrow((Throwable)interruptedException);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        LangAssertions.assertIllegalArgumentException(() -> memoizer.compute((Object)input));
    }

    @Test
    void testDoesRecalculateWhenSetToTrue() throws Exception {
        Integer input = 1;
        Integer answer = 3;
        Memoizer memoizer = new Memoizer(this.function, true);
        IllegalArgumentException interruptedException = new IllegalArgumentException();
        EasyMock.expect((Object)this.function.apply(input)).andThrow((Throwable)interruptedException).andReturn((Object)answer);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertThrows(Throwable.class, () -> memoizer.compute((Object)input));
        Assertions.assertEquals((Integer)answer, (Integer)((Integer)memoizer.compute((Object)input)));
    }

    @Test
    void testOnlyCallComputableOnceIfDoesNotThrowException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.function);
        EasyMock.expect((Object)this.function.apply(input)).andReturn((Object)input);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertEquals((Integer)input, (Integer)((Integer)memoizer.compute((Object)input)), (String)"Should call computable first time");
        Assertions.assertEquals((Integer)input, (Integer)((Integer)memoizer.compute((Object)input)), (String)"Should not call the computable the second time");
    }

    @Test
    void testWhenComputableThrowsError() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.function);
        Error error = new Error();
        EasyMock.expect((Object)this.function.apply(input)).andThrow((Throwable)error);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertThrows(Error.class, () -> memoizer.compute((Object)input));
    }

    @Test
    void testWhenComputableThrowsRuntimeException() throws Exception {
        Integer input = 1;
        Memoizer memoizer = new Memoizer(this.function);
        RuntimeException runtimeException = new RuntimeException("Some runtime exception");
        EasyMock.expect((Object)this.function.apply(input)).andThrow((Throwable)runtimeException);
        EasyMock.replay((Object[])new Object[]{this.function});
        Assertions.assertThrows(RuntimeException.class, () -> memoizer.compute((Object)input));
    }
}

