/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.protobuf.GeneratedMessageV3;
import java.util.concurrent.ExecutionException;
import org.apache.celeborn.common.client.MasterClient;
import org.apache.celeborn.common.network.sasl.SecretRegistry;
import org.apache.celeborn.common.protocol.PbApplicationMeta;
import org.apache.celeborn.common.protocol.PbApplicationMetaRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerSecretRegistryImpl
implements SecretRegistry {
    private static final Logger LOG = LoggerFactory.getLogger(WorkerSecretRegistryImpl.class);
    private final int maxCacheSize;
    private MasterClient masterClient;
    private LoadingCache<String, String> secretCache;

    public WorkerSecretRegistryImpl(int maxCacheSize) {
        this.maxCacheSize = maxCacheSize;
    }

    public void initialize(final MasterClient masterClient) {
        this.masterClient = (MasterClient)Preconditions.checkNotNull((Object)masterClient);
        CacheLoader<String, String> cacheLoader = new CacheLoader<String, String>(){

            public String load(String appId) throws Exception {
                LOG.debug("Missing the secret for {}; fetching it from the master", (Object)appId);
                PbApplicationMetaRequest pbApplicationMetaRequest = PbApplicationMetaRequest.newBuilder().setAppId(appId).build();
                try {
                    PbApplicationMeta pbApplicationMeta = (PbApplicationMeta)masterClient.askSync((GeneratedMessageV3)pbApplicationMetaRequest, PbApplicationMeta.class);
                    LOG.debug("Successfully fetched the application meta info for " + appId + " from the master");
                    return pbApplicationMeta.getSecret();
                }
                catch (Throwable e) {
                    LOG.error("Failed to fetch the application meta info for {} from the master", (Object)appId, (Object)e);
                    throw new Exception(e);
                }
            }
        };
        this.secretCache = CacheBuilder.newBuilder().maximumSize((long)this.maxCacheSize).build((CacheLoader)cacheLoader);
    }

    public String getSecretKey(String appId) {
        try {
            return (String)this.secretCache.get((Object)appId);
        }
        catch (ExecutionException ee) {
            LOG.error("Failed to retrieve the the application meta info for {} ", (Object)appId, (Object)ee);
            return null;
        }
    }

    public boolean isRegistered(String appId) {
        return this.secretCache.getIfPresent((Object)appId) != null;
    }

    public void register(String appId, String secret) {
        String existingSecret = (String)this.secretCache.getIfPresent((Object)appId);
        if (existingSecret != null && !existingSecret.equals(secret)) {
            throw new IllegalArgumentException("AppId " + appId + " is already registered. Cannot re-register.");
        }
        if (existingSecret == null) {
            this.secretCache.put((Object)appId, (Object)secret);
        }
    }

    public void unregister(String appId) {
        this.secretCache.invalidate((Object)appId);
    }
}

