/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.util;

import com.codahale.metrics.MetricRegistry;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.celeborn.common.metrics.source.AbstractSource;
import org.apache.celeborn.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.buffer.ByteBufAllocatorMetric;
import org.apache.celeborn.shaded.io.netty.buffer.PoolArenaMetric;
import org.apache.celeborn.shaded.io.netty.buffer.PooledByteBufAllocator;
import org.apache.celeborn.shaded.io.netty.buffer.PooledByteBufAllocatorMetric;
import org.apache.celeborn.shaded.io.netty.buffer.UnpooledByteBufAllocator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyMemoryMetrics {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ByteBufAllocator allocator;
    private final boolean verboseMetricsEnabled;
    private final String metricPrefix;
    private final AbstractSource source;
    private final Map<String, String> labels;
    @VisibleForTesting
    static final Set<String> VERBOSE_METRICS = new HashSet<String>();

    public NettyMemoryMetrics(ByteBufAllocator allocator, String metricPrefix, boolean verboseMetricsEnabled, AbstractSource source, Map<String, String> labels) {
        this.allocator = allocator;
        this.metricPrefix = metricPrefix;
        this.verboseMetricsEnabled = verboseMetricsEnabled;
        this.source = source;
        this.labels = labels;
        this.registerMetrics();
    }

    private void registerMetrics() {
        if (this.source != null) {
            if (this.allocator instanceof UnpooledByteBufAllocator) {
                this.logger.debug("Setup netty metrics for UnpooledByteBufAllocator");
                ByteBufAllocatorMetric unpooledMetric = ((UnpooledByteBufAllocator)this.allocator).metric();
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedHeapMemory"}), this.labels, unpooledMetric::usedHeapMemory);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedDirectMemory"}), this.labels, unpooledMetric::usedDirectMemory);
            } else if (this.allocator instanceof PooledByteBufAllocator) {
                this.logger.debug("Setup netty metrics for PooledByteBufAllocator");
                PooledByteBufAllocatorMetric pooledAllocatorMetric = ((PooledByteBufAllocator)this.allocator).metric();
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedHeapMemory"}), this.labels, pooledAllocatorMetric::usedHeapMemory);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"usedDirectMemory"}), this.labels, pooledAllocatorMetric::usedDirectMemory);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"numHeapArenas"}), this.labels, pooledAllocatorMetric::numHeapArenas);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"numDirectArenas"}), this.labels, pooledAllocatorMetric::numDirectArenas);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"tinyCacheSize"}), this.labels, pooledAllocatorMetric::tinyCacheSize);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"smallCacheSize"}), this.labels, pooledAllocatorMetric::smallCacheSize);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"normalCacheSize"}), this.labels, pooledAllocatorMetric::normalCacheSize);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"numThreadLocalCaches"}), this.labels, pooledAllocatorMetric::numThreadLocalCaches);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"chunkSize"}), this.labels, pooledAllocatorMetric::chunkSize);
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"pinnedHeapMemory"}), this.labels, () -> ((PooledByteBufAllocator)this.allocator).pinnedHeapMemory());
                this.source.addGauge(MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{"pinnedDirectMemory"}), this.labels, () -> ((PooledByteBufAllocator)this.allocator).pinnedDirectMemory());
                if (this.verboseMetricsEnabled) {
                    int directArenaIndex = 0;
                    for (PoolArenaMetric metric : pooledAllocatorMetric.directArenas()) {
                        this.registerArenaMetric(metric, "directArena" + directArenaIndex);
                        ++directArenaIndex;
                    }
                    int heapArenaIndex = 0;
                    for (PoolArenaMetric metric : pooledAllocatorMetric.heapArenas()) {
                        this.registerArenaMetric(metric, "heapArena" + heapArenaIndex);
                        ++heapArenaIndex;
                    }
                }
            }
        }
    }

    private void registerArenaMetric(PoolArenaMetric arenaMetric, String arenaName) {
        for (String methodName : VERBOSE_METRICS) {
            Method m;
            try {
                m = PoolArenaMetric.class.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                continue;
            }
            if (!Modifier.isPublic(m.getModifiers())) continue;
            Class<?> returnType = m.getReturnType();
            String metricName = MetricRegistry.name((String)this.metricPrefix, (String[])new String[]{arenaName, m.getName()});
            if (returnType.equals(Integer.TYPE)) {
                this.source.addGauge(metricName, this.labels, () -> {
                    try {
                        return (Integer)m.invoke((Object)arenaMetric, new Object[0]);
                    }
                    catch (Exception e) {
                        return -1;
                    }
                });
                continue;
            }
            if (!returnType.equals(Long.TYPE)) continue;
            this.source.addGauge(metricName, this.labels, () -> {
                try {
                    return (Long)m.invoke((Object)arenaMetric, new Object[0]);
                }
                catch (Exception e) {
                    return -1L;
                }
            });
        }
    }

    static {
        VERBOSE_METRICS.addAll(Arrays.asList("numAllocations", "numTinyAllocations", "numSmallAllocations", "numNormalAllocations", "numHugeAllocations", "numDeallocations", "numTinyDeallocations", "numSmallDeallocations", "numNormalDeallocations", "numHugeDeallocations", "numActiveAllocations", "numActiveTinyAllocations", "numActiveSmallAllocations", "numActiveNormalAllocations", "numActiveHugeAllocations", "numActiveBytes"));
    }
}

