/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.client.compress;

import com.github.luben.zstd.Zstd;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.Checksum;
import org.apache.celeborn.client.compress.Decompressor;
import org.apache.celeborn.client.compress.ZstdTrait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZstdDecompressor
extends ZstdTrait
implements Decompressor {
    private static final Logger logger = LoggerFactory.getLogger(ZstdDecompressor.class);
    private final Checksum checksum = new CRC32();

    @Override
    public int getOriginalLen(byte[] src) {
        return this.readIntLE(src, MAGIC_LENGTH + 5);
    }

    @Override
    public int decompress(byte[] src, byte[] dst, int dstOff) throws IOException {
        int compressionMethod = src[MAGIC_LENGTH] & 0xFF;
        int compressedLen = this.readIntLE(src, MAGIC_LENGTH + 1);
        int originalLen = this.readIntLE(src, MAGIC_LENGTH + 5);
        int check = this.readIntLE(src, MAGIC_LENGTH + 9);
        switch (compressionMethod) {
            case 16: {
                System.arraycopy(src, HEADER_LENGTH, dst, dstOff, originalLen);
                break;
            }
            case 48: {
                int originalLen2 = (int)Zstd.decompressByteArray(dst, dstOff, originalLen, src, HEADER_LENGTH, compressedLen);
                if (originalLen == originalLen2) break;
                throw new IOException("Original length corrupted! expected: " + originalLen + ", actual: " + originalLen2 + ".");
            }
            default: {
                throw new IOException("Unknown compression method whose decimal number is {" + compressionMethod + "} .");
            }
        }
        this.checksum.reset();
        this.checksum.update(dst, dstOff, originalLen);
        if ((int)this.checksum.getValue() != check) {
            throw new IOException("Checksum not equal! expected: " + check + ", actual: " + this.checksum.getValue() + ".");
        }
        return originalLen;
    }
}

