/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.meta;

import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.meta.DiskInfo;
import org.apache.celeborn.common.meta.WorkerInfo$;
import org.apache.celeborn.common.meta.WorkerStatus;
import org.apache.celeborn.common.protocol.StorageInfo;
import org.apache.celeborn.common.quota.ResourceConsumption;
import org.apache.celeborn.common.quota.ResourceConsumption$;
import org.apache.celeborn.common.rpc.RpcEndpointRef;
import org.apache.celeborn.common.rpc.netty.NettyRpcEndpointRef;
import org.apache.celeborn.common.util.JavaUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\t-g\u0001\u0002#F\u0001AC\u0001\"\u001b\u0001\u0003\u0006\u0004%\tA\u001b\u0005\tg\u0002\u0011\t\u0011)A\u0005W\"AA\u000f\u0001BC\u0002\u0013\u0005Q\u000f\u0003\u0005z\u0001\t\u0005\t\u0015!\u0003w\u0011!Q\bA!b\u0001\n\u0003)\b\u0002C>\u0001\u0005\u0003\u0005\u000b\u0011\u0002<\t\u0011q\u0004!Q1A\u0005\u0002UD\u0001\" \u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\t}\u0002\u0011)\u0019!C\u0001k\"Aq\u0010\u0001B\u0001B\u0003%a\u000fC\u0005\u0002\u0002\u0001\u0011)\u0019!C\u0001k\"I\u00111\u0001\u0001\u0003\u0002\u0003\u0006IA\u001e\u0005\u000b\u0003\u000b\u0001!\u0011!Q\u0001\n\u0005\u001d\u0001BCA\u0010\u0001\t\u0005\t\u0015!\u0003\u0002\"!9\u00111\b\u0001\u0005\u0002\u0005u\u0002\"CA)\u0001\u0001\u0007I\u0011AA*\u0011%\ty\u0006\u0001a\u0001\n\u0003\t\t\u0007\u0003\u0005\u0002n\u0001\u0001\u000b\u0015BA+\u0011%\ty\u0007\u0001a\u0001\n\u0003\t\t\bC\u0005\u0002z\u0001\u0001\r\u0011\"\u0001\u0002|!A\u0011q\u0010\u0001!B\u0013\t\u0019\bC\u0005\u0002\u0002\u0002\u0001\r\u0011\"\u0001\u0002\u0004\"I\u00111\u0012\u0001A\u0002\u0013\u0005\u0011Q\u0012\u0005\t\u0003#\u0003\u0001\u0015)\u0003\u0002\u0006\"I\u00111\u0013\u0001C\u0002\u0013\u0005\u0011Q\u0013\u0005\t\u0003G\u0003\u0001\u0015!\u0003\u0002\u0018\"I\u0011Q\u0015\u0001C\u0002\u0013\u0005\u0011q\u0015\u0005\t\u0003k\u0003\u0001\u0015!\u0003\u0002*\"I\u0011q\u0017\u0001C\u0002\u0013\u0005\u0011\u0011\u0018\u0005\t\u0003{\u0003\u0001\u0015!\u0003\u0002<\"I\u0011q\u0018\u0001A\u0002\u0013\u0005\u0011\u0011\u0019\u0005\n\u0003\u001f\u0004\u0001\u0019!C\u0001\u0003#D\u0001\"!6\u0001A\u0003&\u00111\u0019\u0005\b\u0003w\u0001A\u0011AAl\u0011\u001d\tY\u0004\u0001C\u0001\u0003GDq!!=\u0001\t\u0003\t\u0019\u0010C\u0004\u0002|\u0002!\t!!@\t\u000f\u0005}\b\u0001\"\u0001\u0003\u0002!9!1\u0003\u0001\u0005\u0002\tU\u0001b\u0002B\n\u0001\u0011\u0005!Q\u0004\u0005\b\u0005C\u0001A\u0011\u0001B\u0012\u0011\u001d\u0011Y\u0003\u0001C\u0001\u0005GAqA!\f\u0001\t\u0003\u0011y\u0003C\u0004\u00036\u0001!\tAa\u000e\t\u000f\tu\u0002\u0001\"\u0001\u0003@!Q!\u0011\t\u0001\t\u0006\u0004%\t!a\u0015\t\u000f\t\r\u0003\u0001\"\u0001\u0003F!9!q\t\u0001\u0005\u0002\u0005u\bb\u0002B%\u0001\u0011\u0005!1\n\u0005\b\u0005\u001b\u0002A\u0011\u0001B(\u0011\u001d\u0011\u0019\u0006\u0001C\u0001\u0005+BqAa\u0017\u0001\t\u0003\ti\u0010C\u0004\u0003^\u0001!\t!!@\t\u000f\t}\u0003\u0001\"\u0001\u0002~\"9!\u0011\r\u0001\u0005\u0002\t\r\u0004\"\u0003B9\u0001E\u0005I\u0011\u0001B:\u0011\u001d\u0011I\t\u0001C\u0001\u0005\u0017CqA!%\u0001\t\u0003\u0012y\u0004C\u0004\u0003\u0014\u0002!\tE!&\t\u000f\t}\u0005\u0001\"\u0011\u0003\"\"9!1\u0015\u0001\u0005\n\u0005M\bb\u0002BS\u0001\u0011\u0005!QI\u0004\b\u0005O+\u0005\u0012\u0001BU\r\u0019!U\t#\u0001\u0003,\"9\u00111\b!\u0005\u0002\t]\u0006b\u0002B]\u0001\u0012\u0005!1\u0018\u0005\n\u0005\u0003\u0004\u0015\u0011!C\u0005\u0005\u0007\u0014!bV8sW\u0016\u0014\u0018J\u001c4p\u0015\t1u)\u0001\u0003nKR\f'B\u0001%J\u0003\u0019\u0019w.\\7p]*\u0011!jS\u0001\tG\u0016dWMY8s]*\u0011A*T\u0001\u0007CB\f7\r[3\u000b\u00039\u000b1a\u001c:h\u0007\u0001\u0019B\u0001A)XGB\u0011!+V\u0007\u0002'*\tA+A\u0003tG\u0006d\u0017-\u0003\u0002W'\n1\u0011I\\=SK\u001a\u0004\"\u0001\u00171\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/P\u0003\u0019a$o\\8u}%\tA+\u0003\u0002`'\u00069\u0001/Y2lC\u001e,\u0017BA1c\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\ty6\u000b\u0005\u0002eO6\tQM\u0003\u0002g\u000f\u0006A\u0011N\u001c;fe:\fG.\u0003\u0002iK\n9Aj\\4hS:<\u0017\u0001\u00025pgR,\u0012a\u001b\t\u0003YBt!!\u001c8\u0011\u0005i\u001b\u0016BA8T\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011O\u001d\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005=\u001c\u0016!\u00025pgR\u0004\u0013a\u0002:qGB{'\u000f^\u000b\u0002mB\u0011!k^\u0005\u0003qN\u00131!\u00138u\u0003!\u0011\bo\u0019)peR\u0004\u0013\u0001\u00039vg\"\u0004vN\u001d;\u0002\u0013A,8\u000f\u001b)peR\u0004\u0013!\u00034fi\u000eD\u0007k\u001c:u\u0003)1W\r^2i!>\u0014H\u000fI\u0001\u000ee\u0016\u0004H.[2bi\u0016\u0004vN\u001d;\u0002\u001dI,\u0007\u000f\\5dCR,\u0007k\u001c:uA\u0005a\u0011N\u001c;fe:\fG\u000eU8si\u0006i\u0011N\u001c;fe:\fG\u000eU8si\u0002\n!b\u00183jg.LeNZ8t!\u001d\tI!a\u0005l\u0003/i!!a\u0003\u000b\t\u00055\u0011qB\u0001\u0005kRLGN\u0003\u0002\u0002\u0012\u0005!!.\u0019<b\u0013\u0011\t)\"a\u0003\u0003\u00075\u000b\u0007\u000f\u0005\u0003\u0002\u001a\u0005mQ\"A#\n\u0007\u0005uQI\u0001\u0005ESN\\\u0017J\u001c4p\u0003ayVo]3s%\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\u001c\t\t\u0003\u0013\t\u0019\"a\t\u00020A!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*\u001d\u000b\u0001\"\u001b3f]RLG/_\u0005\u0005\u0003[\t9C\u0001\bVg\u0016\u0014\u0018\nZ3oi&4\u0017.\u001a:\u0011\t\u0005E\u0012qG\u0007\u0003\u0003gQ1!!\u000eH\u0003\u0015\tXo\u001c;b\u0013\u0011\tI$a\r\u0003'I+7o\\;sG\u0016\u001cuN\\:v[B$\u0018n\u001c8\u0002\rqJg.\u001b;?)I\ty$!\u0011\u0002D\u0005\u0015\u0013qIA%\u0003\u0017\ni%a\u0014\u0011\u0007\u0005e\u0001\u0001C\u0003j\u001f\u0001\u00071\u000eC\u0003u\u001f\u0001\u0007a\u000fC\u0003{\u001f\u0001\u0007a\u000fC\u0003}\u001f\u0001\u0007a\u000fC\u0003\u007f\u001f\u0001\u0007a\u000f\u0003\u0004\u0002\u0002=\u0001\rA\u001e\u0005\b\u0003\u000by\u0001\u0019AA\u0004\u0011\u001d\tyb\u0004a\u0001\u0003C\tqB\\3uo>\u00148\u000eT8dCRLwN\\\u000b\u0003\u0003+\u0002B!a\u0016\u0002^5\u0011\u0011\u0011\f\u0006\u0005\u00037\ny!\u0001\u0003mC:<\u0017bA9\u0002Z\u0005\u0019b.\u001a;x_J\\Gj\\2bi&|gn\u0018\u0013fcR!\u00111MA5!\r\u0011\u0016QM\u0005\u0004\u0003O\u001a&\u0001B+oSRD\u0011\"a\u001b\u0012\u0003\u0003\u0005\r!!\u0016\u0002\u0007a$\u0013'\u0001\toKR<xN]6M_\u000e\fG/[8oA\u0005iA.Y:u\u0011\u0016\f'\u000f\u001e2fCR,\"!a\u001d\u0011\u0007I\u000b)(C\u0002\u0002xM\u0013A\u0001T8oO\u0006\tB.Y:u\u0011\u0016\f'\u000f\u001e2fCR|F%Z9\u0015\t\u0005\r\u0014Q\u0010\u0005\n\u0003W\"\u0012\u0011!a\u0001\u0003g\na\u0002\\1ti\"+\u0017M\u001d;cK\u0006$\b%\u0001\u0007x_J\\WM]*uCR,8/\u0006\u0002\u0002\u0006B!\u0011\u0011DAD\u0013\r\tI)\u0012\u0002\r/>\u00148.\u001a:Ti\u0006$Xo]\u0001\u0011o>\u00148.\u001a:Ti\u0006$Xo]0%KF$B!a\u0019\u0002\u0010\"I\u00111N\f\u0002\u0002\u0003\u0007\u0011QQ\u0001\u000eo>\u00148.\u001a:Ti\u0006$Xo\u001d\u0011\u0002\u0013\u0011L7o[%oM>\u001cXCAAL!\u001d\tI*a(l\u0003/i!!a'\u000b\t\u0005u\u00151B\u0001\u000bG>t7-\u001e:sK:$\u0018\u0002BAQ\u00037\u0013\u0011cQ8oGV\u0014(/\u001a8u\u0011\u0006\u001c\b.T1q\u0003)!\u0017n]6J]\u001a|7\u000fI\u0001\u000eo>\u00148.\u001a:ICN$\u0015n]6\u0016\u0005\u0005%\u0006\u0003BAV\u0003ck!!!,\u000b\t\u0005=\u00161T\u0001\u0007CR|W.[2\n\t\u0005M\u0016Q\u0016\u0002\u000e\u0003R|W.[2C_>dW-\u00198\u0002\u001d]|'o[3s\u0011\u0006\u001cH)[:lA\u00059Ro]3s%\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\\\u000b\u0003\u0003w\u0003\u0002\"!'\u0002 \u0006\r\u0012qF\u0001\u0019kN,'OU3t_V\u00148-Z\"p]N,X\u000e\u001d;j_:\u0004\u0013\u0001C3oIB|\u0017N\u001c;\u0016\u0005\u0005\r\u0007\u0003BAc\u0003\u0017l!!a2\u000b\u0007\u0005%w)A\u0002sa\u000eLA!!4\u0002H\nq!\u000b]2F]\u0012\u0004x.\u001b8u%\u00164\u0017\u0001D3oIB|\u0017N\u001c;`I\u0015\fH\u0003BA2\u0003'D\u0011\"a\u001b!\u0003\u0003\u0005\r!a1\u0002\u0013\u0015tG\r]8j]R\u0004C\u0003DA \u00033\fY.!8\u0002`\u0006\u0005\b\"B5#\u0001\u0004Y\u0007\"\u0002;#\u0001\u00041\b\"\u0002>#\u0001\u00041\b\"\u0002?#\u0001\u00041\b\"\u0002@#\u0001\u00041HCDA \u0003K\f9/!;\u0002l\u00065\u0018q\u001e\u0005\u0006S\u000e\u0002\ra\u001b\u0005\u0006i\u000e\u0002\rA\u001e\u0005\u0006u\u000e\u0002\rA\u001e\u0005\u0006y\u000e\u0002\rA\u001e\u0005\u0006}\u000e\u0002\rA\u001e\u0005\u0007\u0003\u0003\u0019\u0003\u0019\u0001<\u0002\u0011%\u001c\u0018i\u0019;jm\u0016,\"!!>\u0011\u0007I\u000b90C\u0002\u0002zN\u0013qAQ8pY\u0016\fg.A\u0005vg\u0016$7\u000b\\8ugR\u0011\u00111O\u0001\u000eC2dwnY1uKNcw\u000e^:\u0015\r\u0005\r$1\u0001B\u0004\u0011\u0019\u0011)A\na\u0001W\u0006Q1\u000f[;gM2,7*Z=\t\u000f\t%a\u00051\u0001\u0003\f\u0005a1\u000f\\8ugB+'\u000fR5tWB9\u0011\u0011BA\nW\n5\u0001\u0003BA,\u0005\u001fIAA!\u0005\u0002Z\t9\u0011J\u001c;fO\u0016\u0014\u0018\u0001\u0004:fY\u0016\f7/Z*m_R\u001cHCBA2\u0005/\u0011I\u0002\u0003\u0004\u0003\u0006\u001d\u0002\ra\u001b\u0005\b\u000579\u0003\u0019\u0001B\u0006\u0003\u0015\u0019Hn\u001c;t)\u0011\t\u0019Ga\b\t\r\t\u0015\u0001\u00061\u0001l\u0003A9W\r^*ik\u001a4G.Z&fsN+G/\u0006\u0002\u0003&A)\u0011\u0011\u0002B\u0014W&!!\u0011FA\u0006\u0005\u001dA\u0015m\u001d5TKR\f1cZ3u\u0003B\u0004H.[2bi&|g.\u00133TKR\fq\u0002[1t'\u0006lW-\u00138g_^KG\u000f\u001b\u000b\u0005\u0003k\u0014\t\u0004C\u0004\u00034-\u0002\r!a\u0010\u0002\u000b=$\b.\u001a:\u0002\u001bM,G/\u001e9F]\u0012\u0004x.\u001b8u)\u0011\t\u0019G!\u000f\t\u000f\tmB\u00061\u0001\u0002D\u0006YQM\u001c3q_&tGOU3g\u0003=\u0011X-\u00193bE2,\u0017\t\u001a3sKN\u001cH#A6\u0002\u0015Q|WK\\5rk\u0016LE-A\u0007tY>$\u0018I^1jY\u0006\u0014G.\u001a\u000b\u0003\u0003k\fQbZ3u)>$\u0018\r\\*m_R\u001c\u0018aD4fi^{'o[3s'R\fG/^:\u0015\u0005\u0005\u0015\u0015aD:fi^{'o[3s'R\fG/^:\u0015\t\u0005\r$\u0011\u000b\u0005\b\u0003\u0003\u0013\u0004\u0019AAC\u0003=)\b\u000fZ1uK\u0012K7o[*m_R\u001cH\u0003BA2\u0005/BqA!\u00174\u0001\u0004\t\u0019(\u0001\ffgRLW.\u0019;fIB\u000b'\u000f^5uS>t7+\u001b>f\u0003M!x\u000e^1m\u0003Z\f\u0017\u000e\\1cY\u0016\u001cFn\u001c;t\u0003)!x\u000e^1m'B\f7-Z\u0001\u0017i>$\u0018\r\\!diV\fG.V:bE2,7\u000b]1dK\u00061R\u000f\u001d3bi\u0016$\u0006.\u001a8HKR$\u0015n]6J]\u001a|7\u000f\u0006\u0004\u0002\b\t\u0015$\u0011\u000e\u0005\b\u0005O:\u0004\u0019AA\u0004\u00031qWm\u001e#jg.LeNZ8t\u0011%\u0011If\u000eI\u0001\u0002\u0004\u0011Y\u0007E\u0003S\u0005[\n\u0019(C\u0002\u0003pM\u0013aa\u00149uS>t\u0017\u0001I;qI\u0006$X\r\u00165f]\u001e+G\u000fR5tW&sgm\\:%I\u00164\u0017-\u001e7uII*\"A!\u001e+\t\t-$qO\u0016\u0003\u0005s\u0002BAa\u001f\u0003\u00066\u0011!Q\u0010\u0006\u0005\u0005\u007f\u0012\t)A\u0005v]\u000eDWmY6fI*\u0019!1Q*\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\b\nu$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!S\u000f\u001d3bi\u0016$\u0006.\u001a8HKR,6/\u001a:SKN|WO]2f\u0007>t7/^7qi&|g\u000e\u0006\u0003\u0002\"\t5\u0005b\u0002BHs\u0001\u0007\u0011\u0011E\u0001\u0015e\u0016\u001cx.\u001e:dK\u000e{gn];naRLwN\\:\u0002\u0011Q|7\u000b\u001e:j]\u001e\fa!Z9vC2\u001cH\u0003BA{\u0005/CqAa\r<\u0001\u0004\u0011I\nE\u0002S\u00057K1A!(T\u0005\r\te._\u0001\tQ\u0006\u001c\bnQ8eKR\ta/A\u000bd_6\u0004X\u000f^3X_J\\WM\u001d%bm\u0016$\u0015n]6\u0002\u0011!\fg/\u001a#jg.\f!bV8sW\u0016\u0014\u0018J\u001c4p!\r\tI\u0002Q\n\u0005\u0001F\u0013i\u000b\u0005\u0003\u00030\nUVB\u0001BY\u0015\u0011\u0011\u0019,a\u0004\u0002\u0005%|\u0017bA1\u00032R\u0011!\u0011V\u0001\rMJ|W.\u00168jcV,\u0017\n\u001a\u000b\u0005\u0003\u007f\u0011i\f\u0003\u0004\u0003@\n\u0003\ra[\u0001\u0003S\u0012\fAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"A!2\u0011\t\u0005]#qY\u0005\u0005\u0005\u0013\fIF\u0001\u0004PE*,7\r\u001e")
public class WorkerInfo
implements Serializable,
Logging {
    private String toUniqueId;
    private final String host;
    private final int rpcPort;
    private final int pushPort;
    private final int fetchPort;
    private final int replicatePort;
    private final int internalPort;
    private String networkLocation;
    private long lastHeartbeat;
    private WorkerStatus workerStatus;
    private final ConcurrentHashMap<String, DiskInfo> diskInfos;
    private final AtomicBoolean workerHasDisk;
    private final ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption;
    private RpcEndpointRef endpoint;
    private transient Logger log;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    public static WorkerInfo fromUniqueId(String id) {
        return WorkerInfo$.MODULE$.fromUniqueId(id);
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    private Logger log$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$trans$0) {
                this.log = Logging.log$(this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.log;
    }

    @Override
    public Logger log() {
        if (!this.bitmap$trans$0) {
            return this.log$lzycompute();
        }
        return this.log;
    }

    public String host() {
        return this.host;
    }

    public int rpcPort() {
        return this.rpcPort;
    }

    public int pushPort() {
        return this.pushPort;
    }

    public int fetchPort() {
        return this.fetchPort;
    }

    public int replicatePort() {
        return this.replicatePort;
    }

    public int internalPort() {
        return this.internalPort;
    }

    public String networkLocation() {
        return this.networkLocation;
    }

    public void networkLocation_$eq(String x$1) {
        this.networkLocation = x$1;
    }

    public long lastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void lastHeartbeat_$eq(long x$1) {
        this.lastHeartbeat = x$1;
    }

    public WorkerStatus workerStatus() {
        return this.workerStatus;
    }

    public void workerStatus_$eq(WorkerStatus x$1) {
        this.workerStatus = x$1;
    }

    public ConcurrentHashMap<String, DiskInfo> diskInfos() {
        return this.diskInfos;
    }

    public AtomicBoolean workerHasDisk() {
        return this.workerHasDisk;
    }

    public ConcurrentHashMap<UserIdentifier, ResourceConsumption> userResourceConsumption() {
        return this.userResourceConsumption;
    }

    public RpcEndpointRef endpoint() {
        return this.endpoint;
    }

    public void endpoint_$eq(RpcEndpointRef x$1) {
        this.endpoint = x$1;
    }

    public boolean isActive() {
        return ((NettyRpcEndpointRef)this.endpoint()).client().isActive();
    }

    public synchronized long usedSlots() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$usedSlots$1(x$1)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public void allocateSlots(String shuffleKey, Map<String, Integer> slotsPerDisk) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(22).append("Shuffle ").append(shuffleKey).append(", allocations ").append(slotsPerDisk).toString());
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(slotsPerDisk).asScala()).foreach((Function1 & Serializable)x0$1 -> {
                WorkerInfo.$anonfun$allocateSlots$2(this, shuffleKey, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public synchronized void releaseSlots(String shuffleKey, Map<String, Integer> slots) {
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaMapConverter(slots).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            WorkerInfo.$anonfun$releaseSlots$1(this, shuffleKey, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized void releaseSlots(String shuffleKey) {
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable)x$2 -> {
            WorkerInfo.$anonfun$releaseSlots$2(shuffleKey, x$2);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized HashSet<String> getShuffleKeySet() {
        HashSet<String> shuffleKeySet = new HashSet<String>();
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)shuffleKeySet.addAll(diskInfo.getShuffleKeySet())));
        return shuffleKeySet;
    }

    public synchronized HashSet<String> getApplicationIdSet() {
        HashSet<String> applicationIdSet = new HashSet<String>();
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).foreach((Function1 & Serializable)diskInfo -> BoxesRunTime.boxToBoolean((boolean)applicationIdSet.addAll(diskInfo.getApplicationIdSet())));
        return applicationIdSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasSameInfoWith(WorkerInfo other) {
        if (this.rpcPort() != other.rpcPort()) return false;
        if (this.pushPort() != other.pushPort()) return false;
        String string = this.host();
        String string2 = other.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.fetchPort() != other.fetchPort()) return false;
        if (this.replicatePort() != other.replicatePort()) return false;
        return true;
    }

    public void setupEndpoint(RpcEndpointRef endpointRef) {
        if (this.endpoint() == null) {
            this.endpoint_$eq(endpointRef);
            return;
        }
    }

    public String readableAddress() {
        return new StringBuilder(50).append("Host:").append(this.host()).append(":RpcPort:").append(this.rpcPort()).append(":PushPort:").append(this.pushPort()).append(":").append("FetchPort:").append(this.fetchPort()).append(":ReplicatePort:").append(this.replicatePort()).append((Object)(this.internalPort() > 0 ? new StringBuilder(14).append(":InternalPort:").append(this.internalPort()).toString() : "")).toString();
    }

    private String toUniqueId$lzycompute() {
        WorkerInfo workerInfo = this;
        synchronized (workerInfo) {
            if (!this.bitmap$0) {
                this.toUniqueId = new StringBuilder(4).append(this.host()).append(":").append(this.rpcPort()).append(":").append(this.pushPort()).append(":").append(this.fetchPort()).append(":").append(this.replicatePort()).toString();
                this.bitmap$0 = true;
            }
        }
        return this.toUniqueId;
    }

    public String toUniqueId() {
        if (!this.bitmap$0) {
            return this.toUniqueId$lzycompute();
        }
        return this.toUniqueId;
    }

    public synchronized boolean slotAvailable() {
        return ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$slotAvailable$1(x0$1)));
    }

    public synchronized long getTotalSlots() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$getTotalSlots$1(x$3)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public WorkerStatus getWorkerStatus() {
        return this.workerStatus();
    }

    public void setWorkerStatus(WorkerStatus workerStatus) {
        this.workerStatus_$eq(workerStatus);
    }

    public synchronized void updateDiskSlots(long estimatedPartitionSize) {
        ((IterableOnceOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).foreach((Function1 & Serializable)x0$1 -> {
            WorkerInfo.$anonfun$updateDiskSlots$1(estimatedPartitionSize, x0$1);
            return BoxedUnit.UNIT;
        });
    }

    public synchronized long totalAvailableSlots() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalAvailableSlots$1(x$4)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalSpace() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable)x$5 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalSpace$1(x$5)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized long totalActualUsableSpace() {
        return BoxesRunTime.unboxToLong((Object)((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.diskInfos()).asScala()).map((Function1 & Serializable)x$6 -> BoxesRunTime.boxToLong((long)WorkerInfo.$anonfun$totalActualUsableSpace$1(x$6)))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public synchronized Map<String, DiskInfo> updateThenGetDiskInfos(Map<String, DiskInfo> newDiskInfos, Option<Object> estimatedPartitionSize) {
        ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(newDiskInfos.values()).asScala()).foreach((Function1 & Serializable)newDisk -> {
            String mountPoint;
            block8: {
                mountPoint = newDisk.mountPoint();
                DiskInfo curDisk = this.diskInfos().get(mountPoint);
                if (curDisk != null) {
                    curDisk.actualUsableSpace_$eq(newDisk.actualUsableSpace());
                    curDisk.totalSpace_$eq(newDisk.totalSpace());
                    curDisk.activeSlots_$eq(newDisk.activeSlots());
                    curDisk.avgFlushTime_$eq(newDisk.avgFlushTime());
                    curDisk.avgFetchTime_$eq(newDisk.avgFetchTime());
                    if (estimatedPartitionSize.nonEmpty()) {
                        StorageInfo.Type type = curDisk.storageType();
                        StorageInfo.Type type2 = StorageInfo.Type.HDFS;
                        if (type == null ? type2 != null : !((Object)((Object)type)).equals((Object)type2)) {
                            StorageInfo.Type type3 = curDisk.storageType();
                            StorageInfo.Type type4 = StorageInfo.Type.S3;
                            if (type3 == null ? type4 != null : !((Object)((Object)type3)).equals((Object)type4)) {
                                StorageInfo.Type type5 = curDisk.storageType();
                                StorageInfo.Type type6 = StorageInfo.Type.OSS;
                                if (type5 == null ? type6 != null : !((Object)((Object)type5)).equals((Object)type6)) {
                                    curDisk.maxSlots_$eq(curDisk.totalSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                                    curDisk.availableSlots_$eq(curDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                                }
                            }
                        }
                    }
                    return curDisk.setStatus(newDisk.status());
                }
                if (!estimatedPartitionSize.nonEmpty()) break block8;
                StorageInfo.Type type = newDisk.storageType();
                StorageInfo.Type type7 = StorageInfo.Type.HDFS;
                if (type == null ? type7 != null : !((Object)((Object)type)).equals((Object)type7)) {
                    StorageInfo.Type type8 = newDisk.storageType();
                    StorageInfo.Type type9 = StorageInfo.Type.S3;
                    if (type8 == null ? type9 != null : !((Object)((Object)type8)).equals((Object)type9)) {
                        StorageInfo.Type type10 = newDisk.storageType();
                        StorageInfo.Type type11 = StorageInfo.Type.OSS;
                        if (type10 == null ? type11 != null : !((Object)((Object)type10)).equals((Object)type11)) {
                            newDisk.maxSlots_$eq(newDisk.totalSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                            newDisk.availableSlots_$eq(newDisk.actualUsableSpace() / BoxesRunTime.unboxToLong((Object)estimatedPartitionSize.get()));
                        }
                    }
                }
            }
            return this.diskInfos().put(mountPoint, (DiskInfo)newDisk);
        });
        HashSet nonExistsMountPoints = new HashSet();
        nonExistsMountPoints.addAll(this.diskInfos().keySet());
        nonExistsMountPoints.removeAll(newDiskInfos.keySet());
        if (!nonExistsMountPoints.isEmpty()) {
            ((IterableOnceOps)JavaConverters$.MODULE$.asScalaSetConverter(nonExistsMountPoints).asScala()).foreach((Function1 & Serializable)nonExistsMountPoint -> this.diskInfos().remove(nonExistsMountPoint));
        }
        this.workerHasDisk().set(this.computeWorkerHaveDisk());
        return JavaUtils.newConcurrentHashMap(this.diskInfos());
    }

    public Option<Object> updateThenGetDiskInfos$default$2() {
        return None$.MODULE$;
    }

    public Map<UserIdentifier, ResourceConsumption> updateThenGetUserResourceConsumption(Map<UserIdentifier, ResourceConsumption> resourceConsumptions) {
        ((Iterator)JavaConverters$.MODULE$.enumerationAsScalaIteratorConverter(this.userResourceConsumption().keys()).asScala()).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)resourceConsumptions.containsKey(x$1))).foreach((Function1 & Serializable)identifier -> this.userResourceConsumption().put((UserIdentifier)identifier, new ResourceConsumption(0L, 0L, 0L, 0L, ResourceConsumption$.MODULE$.apply$default$5())));
        this.userResourceConsumption().putAll(resourceConsumptions);
        return this.userResourceConsumption();
    }

    public String toString() {
        Tuple2 tuple2;
        Tuple2 tuple22;
        if (this.diskInfos() == null || this.diskInfos().isEmpty()) {
            tuple22 = new Tuple2((Object)"empty", (Object)BoxesRunTime.boxToInteger((int)0));
        } else if (this.diskInfos() != null) {
            String str = ((IterableOnceOps)((IterableOps)((IterableOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 != null) {
                    DiskInfo diskInfo = (DiskInfo)tuple2._1();
                    int index = tuple2._2$mcI$sp();
                    return new StringBuilder(13).append("\n  DiskInfo").append(index).append(": ").append(diskInfo).toString();
                }
                throw new MatchError((Object)tuple2);
            })).mkString("");
            tuple22 = new Tuple2((Object)str, (Object)BoxesRunTime.boxToLong((long)this.usedSlots()));
        } else {
            tuple22 = tuple2 = BoxedUnit.UNIT;
        }
        if (!(tuple2 instanceof Tuple2)) {
            throw new MatchError((Object)tuple2);
        }
        Tuple2 tuple23 = tuple2;
        Object diskInfosString = tuple23._1();
        Object slots = tuple23._2();
        Tuple2 tuple24 = new Tuple2(diskInfosString, slots);
        Object diskInfosString2 = tuple24._1();
        Object slots2 = tuple24._2();
        String userResourceConsumptionString = this.userResourceConsumption() == null || this.userResourceConsumption().isEmpty() ? "empty" : (this.userResourceConsumption() != null ? ((IterableOnceOps)((IterableOps)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.userResourceConsumption()).asScala()).map((Function1 & Serializable)x0$2 -> {
            Tuple2 tuple2 = x0$2;
            if (tuple2 != null) {
                UserIdentifier userIdentifier = (UserIdentifier)tuple2._1();
                ResourceConsumption resourceConsumption = (ResourceConsumption)tuple2._2();
                return new StringBuilder(42).append("\n  UserIdentifier: ").append(userIdentifier).append(", ResourceConsumption: ").append(resourceConsumption).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("") : BoxedUnit.UNIT);
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(325).append("\n       |Host: ").append(this.host()).append("\n       |RpcPort: ").append(this.rpcPort()).append("\n       |PushPort: ").append(this.pushPort()).append("\n       |FetchPort: ").append(this.fetchPort()).append("\n       |ReplicatePort: ").append(this.replicatePort()).append("\n       |InternalPort: ").append(this.internalPort()).append("\n       |SlotsUsed: ").append(slots2).append("\n       |LastHeartbeat: ").append(this.lastHeartbeat()).append("\n       |HeartbeatElapsedSeconds: ").append(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.lastHeartbeat())).append("\n       |Disks: ").append(diskInfosString2).append("\n       |UserResourceConsumption: ").append((Object)userResourceConsumptionString).append("\n       |WorkerRef: ").append(this.endpoint()).append("\n       |WorkerStatus: ").append(this.workerStatus()).append("\n       |NetworkLocation: ").append(this.networkLocation()).append("\n       |").toString()));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        Object object = other;
        if (!(object instanceof WorkerInfo)) return false;
        WorkerInfo workerInfo = (WorkerInfo)object;
        String string = this.host();
        String string2 = workerInfo.host();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (this.rpcPort() != workerInfo.rpcPort()) return false;
        if (this.pushPort() != workerInfo.pushPort()) return false;
        if (this.fetchPort() != workerInfo.fetchPort()) return false;
        if (this.replicatePort() != workerInfo.replicatePort()) return false;
        return true;
    }

    public int hashCode() {
        int result = this.host().hashCode();
        result = 31 * result + Integer.hashCode(this.rpcPort());
        result = 31 * result + Integer.hashCode(this.pushPort());
        result = 31 * result + Integer.hashCode(this.fetchPort());
        result = 31 * result + Integer.hashCode(this.replicatePort());
        return result;
    }

    private boolean computeWorkerHaveDisk() {
        if (this.diskInfos() != null) {
            return ((IterableOnceOps)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.diskInfos().values()).asScala()).exists((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)WorkerInfo.$anonfun$computeWorkerHaveDisk$1(p)));
        }
        return false;
    }

    public boolean haveDisk() {
        return this.workerHasDisk().get();
    }

    public static final /* synthetic */ long $anonfun$usedSlots$1(Tuple2 x$1) {
        return ((DiskInfo)x$1._2()).activeSlots();
    }

    public static final /* synthetic */ void $anonfun$allocateSlots$2(WorkerInfo $this, String shuffleKey$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slots = (Integer)tuple2._2();
            DiskInfo diskInfo = $this.diskInfos().get(disk);
            if (diskInfo == null) {
                $this.logDebug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Unknown disk ").append(disk).append(" when allocateSlots").toString());
                return;
            }
            diskInfo.allocateSlots(shuffleKey$1, Predef$.MODULE$.Integer2int(slots));
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$1(WorkerInfo $this, String shuffleKey$2, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            String disk = (String)tuple2._1();
            Integer slot = (Integer)tuple2._2();
            if ($this.diskInfos().containsKey(disk)) {
                $this.diskInfos().get(disk).releaseSlots(shuffleKey$2, Predef$.MODULE$.Integer2int(slot));
                return;
            }
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ void $anonfun$releaseSlots$2(String shuffleKey$3, Tuple2 x$2) {
        ((DiskInfo)x$2._2()).releaseSlots(shuffleKey$3);
    }

    public static final /* synthetic */ boolean $anonfun$slotAvailable$1(Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            return disk.availableSlots() > 0L;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$getTotalSlots$1(Tuple2 x$3) {
        return ((DiskInfo)x$3._2()).maxSlots();
    }

    public static final /* synthetic */ void $anonfun$updateDiskSlots$1(long estimatedPartitionSize$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 != null) {
            DiskInfo disk = (DiskInfo)tuple2._2();
            disk.maxSlots_$eq(disk.totalSpace() / estimatedPartitionSize$1);
            disk.availableSlots_$eq(disk.actualUsableSpace() / estimatedPartitionSize$1);
            return;
        }
        throw new MatchError((Object)tuple2);
    }

    public static final /* synthetic */ long $anonfun$totalAvailableSlots$1(Tuple2 x$4) {
        return ((DiskInfo)x$4._2()).getAvailableSlots();
    }

    public static final /* synthetic */ long $anonfun$totalSpace$1(Tuple2 x$5) {
        return ((DiskInfo)x$5._2()).totalSpace();
    }

    public static final /* synthetic */ long $anonfun$totalActualUsableSpace$1(Tuple2 x$6) {
        return ((DiskInfo)x$6._2()).actualUsableSpace();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$computeWorkerHaveDisk$1(DiskInfo p) {
        StorageInfo.Type type = p.storageType();
        StorageInfo.Type type2 = StorageInfo.Type.SSD;
        if (type == null) {
            if (type2 == null) return true;
        } else if (((Object)((Object)type)).equals((Object)type2)) return true;
        StorageInfo.Type type3 = p.storageType();
        StorageInfo.Type type4 = StorageInfo.Type.HDD;
        if (type3 != null) {
            if (!((Object)((Object)type3)).equals((Object)type4)) return false;
            return true;
        }
        if (type4 == null) return true;
        return false;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort, Map<String, DiskInfo> _diskInfos, Map<UserIdentifier, ResourceConsumption> _userResourceConsumption) {
        this.host = host;
        this.rpcPort = rpcPort;
        this.pushPort = pushPort;
        this.fetchPort = fetchPort;
        this.replicatePort = replicatePort;
        this.internalPort = internalPort;
        Logging.$init$(this);
        this.networkLocation = "/default-rack";
        this.lastHeartbeat = 0L;
        this.workerStatus = WorkerStatus.normalWorkerStatus();
        this.diskInfos = _diskInfos != null ? JavaUtils.newConcurrentHashMap(_diskInfos) : null;
        this.workerHasDisk = new AtomicBoolean(this.computeWorkerHaveDisk());
        this.userResourceConsumption = _userResourceConsumption != null ? JavaUtils.newConcurrentHashMap(_userResourceConsumption) : null;
        this.endpoint = null;
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, -1, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }

    public WorkerInfo(String host, int rpcPort, int pushPort, int fetchPort, int replicatePort, int internalPort) {
        this(host, rpcPort, pushPort, fetchPort, replicatePort, internalPort, new HashMap<String, DiskInfo>(), new HashMap<UserIdentifier, ResourceConsumption>());
    }
}

