/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.master.http.api.v1;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import java.io.Serializable;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.celeborn.rest.v1.model.MasterCommitData;
import org.apache.celeborn.rest.v1.model.MasterInfoResponse;
import org.apache.celeborn.rest.v1.model.MasterLeader;
import org.apache.celeborn.rest.v1.model.RatisLogInfo;
import org.apache.celeborn.rest.v1.model.RatisLogTermIndex;
import org.apache.celeborn.server.common.HttpService;
import org.apache.celeborn.server.common.http.api.ApiRequestContext;
import org.apache.celeborn.service.deploy.master.Master;
import org.apache.celeborn.service.deploy.master.clustermeta.ha.HAMasterMetaManager;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.GroupInfoReply;
import scala.Function1;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.reflect.ScalaSignature;

@Tag(name="Master")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@ScalaSignature(bytes="\u0006\u0001\u0005ea\u0001\u0002\u0003\u0006\u0001aAQ!\u000b\u0001\u0005\u0002)BQ\u0001\u0004\u0001\u0005\n5BQA\r\u0001\u0005\u0002M\u0012a\"T1ti\u0016\u0014(+Z:pkJ\u001cWM\u0003\u0002\u0007\u000f\u0005\u0011a/\r\u0006\u0003\u0011%\t1!\u00199j\u0015\tQ1\"\u0001\u0003iiR\u0004(B\u0001\u0007\u000e\u0003\u0019i\u0017m\u001d;fe*\u0011abD\u0001\u0007I\u0016\u0004Hn\\=\u000b\u0005A\t\u0012aB:feZL7-\u001a\u0006\u0003%M\t\u0001bY3mK\n|'O\u001c\u0006\u0003)U\ta!\u00199bG\",'\"\u0001\f\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001Ir\u0004\u0005\u0002\u001b;5\t1DC\u0001\u001d\u0003\u0015\u00198-\u00197b\u0013\tq2D\u0001\u0004B]f\u0014VM\u001a\t\u0003A\u001dj\u0011!\t\u0006\u0003\u0011\tR!AC\u0012\u000b\u0005\u0011*\u0013AB2p[6|gN\u0003\u0002'#\u000511/\u001a:wKJL!\u0001K\u0011\u0003#\u0005\u0003\u0018NU3rk\u0016\u001cHoQ8oi\u0016DH/\u0001\u0004=S:LGO\u0010\u000b\u0002WA\u0011A\u0006A\u0007\u0002\u000bU\ta\u0006\u0005\u00020a5\t1\"\u0003\u00022\u0017\t1Q*Y:uKJ\fq\"\\1ti\u0016\u0014xI]8va&sgm\\\u000b\u0002iA\u0011QgO\u0007\u0002m)\u0011q\u0007O\u0001\u0006[>$W\r\u001c\u0006\u0003\reR!AO\t\u0002\tI,7\u000f^\u0005\u0003yY\u0012!#T1ti\u0016\u0014\u0018J\u001c4p%\u0016\u001c\bo\u001c8tK\"\u00121A\u0010\t\u0003\u007f\u0019k\u0011\u0001\u0011\u0006\u0003\u0003\n\u000b!A]:\u000b\u0005\r#\u0015AA<t\u0015\u0005)\u0015!\u00026bm\u0006D\u0018BA$A\u0005\r9U\t\u0016\u0015\u0007\u0007%K&\fX/\u0011\u0005);V\"A&\u000b\u00051k\u0015!\u0003:fgB|gn]3t\u0015\tqu*A\u0006b]:|G/\u0019;j_:\u001c(B\u0001)R\u0003\ry\u0017m\u001d\u0006\u0003%N\u000b!A^\u001a\u000b\u0005Q+\u0016aB:xC\u001e<WM\u001d\u0006\u0002-\u0006\u0011\u0011n\\\u0005\u00031.\u00131\"\u00119j%\u0016\u001c\bo\u001c8tK\u0006a!/Z:q_:\u001cXmQ8eK\u0006\n1,A\u00023aA\nqaY8oi\u0016tG\u000fL\u0001_W\u0015yVM\u001a5j!\t\u00017-D\u0001b\u0015\t\u0011W*A\u0003nK\u0012L\u0017-\u0003\u0002eC\n91i\u001c8uK:$\u0018!C7fI&\fG+\u001f9fC\u00059\u0017\u0001E1qa2L7-\u0019;j_:|#n]8o\u0003\u0019\u00198\r[3nC.\u001a!.\u001c8\u0011\u0005\u0001\\\u0017B\u00017b\u0005\u0019\u00196\r[3nC\u0006q\u0011.\u001c9mK6,g\u000e^1uS>t7%\u0001\u001b)\t\r\u0001H/\u001e\t\u0003cJl\u0011!T\u0005\u0003g6\u0013\u0011b\u00149fe\u0006$\u0018n\u001c8\u0002\u0017\u0011,7o\u0019:jaRLwN\\\u0011\u0002m\u0006)G*[:uA5\f7\u000f^3sA\u001d\u0014x.\u001e9!S:4wN]7bi&|g\u000eI8gAQDW\rI:feZL7-\u001a\u0018!\u0013R\u0004s/\u001b7mA1L7\u000f\u001e\u0011bY2\u0004S.Y:uKJ<3\u000f\t'F\u0003\u0012+%\u000b\f\u0011G\u001f2cujV#SA%tgm\u001c:nCRLwN\u001c\u0018)\t\u0001A8\u0010 \t\u0003\u007feL!A\u001f!\u0003\u0011\r{gn];nKN\fQA^1mk\u0016d\u0013A\u001a\u0015\u0006\u0001y\\\u00181\u0001\t\u0003\u007f}L1!!\u0001A\u0005!\u0001&o\u001c3vG\u0016\u001cH&\u00014)\u000f\u0001\t9!a\u0005\u0002\u0016A!\u0011\u0011BA\b\u001b\t\tYAC\u0002\u0002\u000e5\u000bA\u0001^1hg&!\u0011\u0011CA\u0006\u0005\r!\u0016mZ\u0001\u0005]\u0006lW-\t\u0002\u0002\u0018\u00051Q*Y:uKJ\u0004")
public class MasterResource
implements ApiRequestContext {
    @Context
    private ServletContext servletContext;
    @Context
    private HttpServletRequest httpRequest;

    public final HttpService httpService() {
        return ApiRequestContext.httpService$((ApiRequestContext)this);
    }

    public String normalizeParam(String param) {
        return ApiRequestContext.normalizeParam$((ApiRequestContext)this, (String)param);
    }

    public ServletContext servletContext() {
        return this.servletContext;
    }

    public void servletContext_$eq(ServletContext x$1) {
        this.servletContext = x$1;
    }

    public HttpServletRequest httpRequest() {
        return this.httpRequest;
    }

    public void httpRequest_$eq(HttpServletRequest x$1) {
        this.httpRequest = x$1;
    }

    private Master master() {
        return (Master)this.httpService();
    }

    @Operation(description="List master group information of the service. It will list all master's LEADER, FOLLOWER information.")
    @ApiResponse(responseCode="200", content={@Content(mediaType="application/json", schema=@Schema(implementation=MasterInfoResponse.class))})
    @GET
    public MasterInfoResponse masterGroupInfo() {
        if (this.master().conf().haEnabled()) {
            GroupInfoReply groupInfo = ((HAMasterMetaManager)this.master().statusSystem()).getRatisServer().getGroupInfo();
            RaftProtos.RaftPeerProto leader = (RaftProtos.RaftPeerProto)Option$.MODULE$.apply((Object)groupInfo.getRoleInfoProto()).map((Function1 & Serializable & scala.Serializable)roleInfo -> {
                RaftProtos.RaftPeerRole raftPeerRole = roleInfo.getRole();
                RaftProtos.RaftPeerRole raftPeerRole2 = RaftProtos.RaftPeerRole.LEADER;
                if (!(raftPeerRole != null ? !raftPeerRole.equals(raftPeerRole2) : raftPeerRole2 != null)) {
                    return roleInfo.getSelf();
                }
                return (RaftProtos.RaftPeerProto)Option$.MODULE$.apply((Object)roleInfo.getFollowerInfo()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getLeaderInfo().getId()).orNull(Predef$.MODULE$.$conforms());
            }).orNull(Predef$.MODULE$.$conforms());
            MasterLeader masterLeader = (MasterLeader)Option$.MODULE$.apply((Object)leader).map((Function1 & Serializable & scala.Serializable)x$2 -> new MasterLeader().id(leader.getId().toStringUtf8()).address(leader.getAddress())).orNull(Predef$.MODULE$.$conforms());
            Iterable masterCommitDataList = (Iterable)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(groupInfo.getCommitInfos()).asScala()).map((Function1 & Serializable & scala.Serializable)commitInfo -> new MasterCommitData().commitIndex(Predef$.MODULE$.long2Long(commitInfo.getCommitIndex())).id(commitInfo.getServer().getId().toStringUtf8()).address(commitInfo.getServer().getAddress()).clientAddress(commitInfo.getServer().getClientAddress()).startUpRole(commitInfo.getServer().getStartupRole().toString()).priority(Predef$.MODULE$.int2Integer(commitInfo.getServer().getPriority())), Iterable$.MODULE$.canBuildFrom());
            RatisLogInfo logInfo = new RatisLogInfo().lastSnapshot(new RatisLogTermIndex().term(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getLastSnapshot().getTerm())).index(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getLastSnapshot().getIndex()))).applied(new RatisLogTermIndex().term(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getApplied().getTerm())).index(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getApplied().getIndex()))).committed(new RatisLogTermIndex().term(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getCommitted().getTerm())).index(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getCommitted().getIndex()))).lastEntry(new RatisLogTermIndex().term(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getLastEntry().getTerm())).index(Predef$.MODULE$.long2Long(groupInfo.getLogInfoProto().getLastEntry().getIndex())));
            return new MasterInfoResponse().groupId(groupInfo.getGroup().getGroupId().getUuid().toString()).leader(masterLeader).masterCommitInfo((List)JavaConverters$.MODULE$.seqAsJavaListConverter(masterCommitDataList.toSeq()).asJava()).logInfo(logInfo);
        }
        throw new BadRequestException("HA is not enabled");
    }

    public MasterResource() {
        ApiRequestContext.$init$((ApiRequestContext)this);
    }
}

