/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.common.server.utils;

import org.apache.cassandra.sidecar.common.utils.Preconditions;

public final class ByteUtils {
    public static final long ONE_KIB = 1024L;
    public static final long ONE_MIB = 0x100000L;
    public static final long ONE_GIB = 0x40000000L;
    public static final long ONE_TIB = 0x10000000000L;
    public static final long ONE_PIB = 0x4000000000000L;
    public static final long ONE_EIB = 0x1000000000000000L;

    public static String bytesToHumanReadableBinaryPrefix(long bytes) {
        Preconditions.checkArgument((bytes >= 0L ? 1 : 0) != 0, (String)"bytes cannot be negative");
        if (bytes >= 0x1000000000000000L) {
            return ByteUtils.formatHelper(bytes, 0x1000000000000000L, "EiB");
        }
        if (bytes >= 0x4000000000000L) {
            return ByteUtils.formatHelper(bytes, 0x4000000000000L, "PiB");
        }
        if (bytes >= 0x10000000000L) {
            return ByteUtils.formatHelper(bytes, 0x10000000000L, "TiB");
        }
        if (bytes >= 0x40000000L) {
            return ByteUtils.formatHelper(bytes, 0x40000000L, "GiB");
        }
        if (bytes >= 0x100000L) {
            return ByteUtils.formatHelper(bytes, 0x100000L, "MiB");
        }
        if (bytes >= 1024L) {
            return ByteUtils.formatHelper(bytes, 1024L, "KiB");
        }
        return bytes + " B";
    }

    static String formatHelper(double bytes, long baseUnit, String unitName) {
        return String.format("%.2f %s", bytes / (double)baseUnit, unitName);
    }
}

