/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.metrics.instance;

import com.codahale.metrics.DefaultSettableGauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import java.util.Objects;
import org.apache.cassandra.sidecar.metrics.DeltaGauge;
import org.apache.cassandra.sidecar.metrics.NamedMetric;

public class InstanceRestoreMetrics {
    public static final String DOMAIN = "Sidecar.CassInstance.Restore";
    protected final MetricRegistry metricRegistry;
    public final NamedMetric<Timer> sliceCompletionTime;
    public final NamedMetric<Timer> sliceImportTime;
    public final NamedMetric<Timer> sliceStageTime;
    public final NamedMetric<Timer> sliceUnzipTime;
    public final NamedMetric<Timer> sliceValidationTime;
    public final NamedMetric<DeltaGauge> sliceDownloadTimeouts;
    public final NamedMetric<DeltaGauge> sliceDownloadRetries;
    public final NamedMetric<DeltaGauge> sliceChecksumMismatches;
    public final NamedMetric<DefaultSettableGauge<Integer>> sliceImportQueueLength;
    public final NamedMetric<DefaultSettableGauge<Integer>> pendingSliceCount;
    public final NamedMetric<Histogram> dataSSTableComponentSize;
    public final NamedMetric<Timer> sliceDownloadTime;
    public final NamedMetric<Histogram> sliceCompressedSizeInBytes;
    public final NamedMetric<Histogram> sliceUncompressedSizeInBytes;
    public final NamedMetric<Timer> slowRestoreTaskTime;

    public InstanceRestoreMetrics(MetricRegistry metricRegistry) {
        this.metricRegistry = Objects.requireNonNull(metricRegistry, "Metric registry can not be null");
        this.sliceCompletionTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceCompletionTime").build();
        this.sliceImportTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceImportTime").build();
        this.sliceStageTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceStageTime").build();
        this.sliceUnzipTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceUnzipTime").build();
        this.sliceValidationTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceValidationTime").build();
        this.sliceDownloadTimeouts = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("SliceDownloadTimeouts").build();
        this.sliceDownloadRetries = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("SliceDownloadRetries").build();
        this.sliceChecksumMismatches = NamedMetric.builder(name -> (DeltaGauge)metricRegistry.gauge(name, DeltaGauge::new)).withDomain(DOMAIN).withName("SliceChecksumMismatches").build();
        this.sliceImportQueueLength = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("SliceImportQueueLength").build();
        this.pendingSliceCount = NamedMetric.builder(name -> (DefaultSettableGauge)metricRegistry.gauge(name, () -> new DefaultSettableGauge((Object)0))).withDomain(DOMAIN).withName("PendingSliceCount").build();
        this.dataSSTableComponentSize = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).histogram(arg_0)).withDomain(DOMAIN).withName("RestoreDataSizeBytes").addTag("Component", "Data.db").build();
        this.sliceDownloadTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SliceDownloadTime").build();
        this.sliceCompressedSizeInBytes = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).histogram(arg_0)).withDomain(DOMAIN).withName("SliceCompressedSizeBytes").build();
        this.sliceUncompressedSizeInBytes = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).histogram(arg_0)).withDomain(DOMAIN).withName("SliceUncompressedSizeBytes").build();
        this.slowRestoreTaskTime = NamedMetric.builder(arg_0 -> ((MetricRegistry)metricRegistry).timer(arg_0)).withDomain(DOMAIN).withName("SlowRestoreTaskTime").build();
    }
}

