/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.handlers.livemigration;

import com.google.inject.Inject;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.auth.authorization.Authorization;
import io.vertx.ext.web.RoutingContext;
import java.io.IOException;
import java.util.Set;
import org.apache.cassandra.sidecar.acl.authorization.BasicPermissions;
import org.apache.cassandra.sidecar.cluster.instance.InstanceMetadata;
import org.apache.cassandra.sidecar.common.response.InstanceFilesListResponse;
import org.apache.cassandra.sidecar.concurrent.ExecutorPools;
import org.apache.cassandra.sidecar.config.SidecarConfiguration;
import org.apache.cassandra.sidecar.handlers.AbstractHandler;
import org.apache.cassandra.sidecar.handlers.AccessProtected;
import org.apache.cassandra.sidecar.livemigration.CassandraInstanceFilesImpl;
import org.apache.cassandra.sidecar.utils.CassandraInputValidator;
import org.apache.cassandra.sidecar.utils.HttpExceptions;
import org.apache.cassandra.sidecar.utils.InstanceMetadataFetcher;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LiveMigrationListInstanceFilesHandler
extends AbstractHandler<Void>
implements AccessProtected {
    private static final Logger LOGGER = LoggerFactory.getLogger(LiveMigrationListInstanceFilesHandler.class);
    private final SidecarConfiguration sidecarConfiguration;

    @Inject
    public LiveMigrationListInstanceFilesHandler(InstanceMetadataFetcher metadataFetcher, ExecutorPools executorPools, CassandraInputValidator validator, SidecarConfiguration sidecarConfiguration) {
        super(metadataFetcher, executorPools, validator);
        this.sidecarConfiguration = sidecarConfiguration;
    }

    @Override
    protected Void extractParamsOrThrow(RoutingContext context) {
        return null;
    }

    @Override
    protected void handleInternal(RoutingContext context, HttpServerRequest httpRequest, @NotNull String host, SocketAddress remoteAddress, Void request) {
        InstanceMetadata instanceMetadata = this.metadataFetcher.instance(host);
        CassandraInstanceFilesImpl filesList = new CassandraInstanceFilesImpl(instanceMetadata, this.sidecarConfiguration.liveMigrationConfiguration());
        this.executorPools.service().runBlocking(() -> {
            try {
                context.json((Object)new InstanceFilesListResponse(filesList.files()));
            }
            catch (IOException e) {
                LOGGER.error("Could not fetch instance files information.", (Throwable)e);
                context.fail((Throwable)HttpExceptions.wrapHttpException(HttpResponseStatus.INTERNAL_SERVER_ERROR, e.getMessage(), e));
            }
        });
    }

    @Override
    public Set<Authorization> requiredAuthorizations() {
        return Set.of(BasicPermissions.LIST_FILES.toAuthorization());
    }
}

