/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.sidecar.config.yaml;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.concurrent.TimeUnit;
import org.apache.cassandra.sidecar.common.server.utils.MillisecondBoundConfiguration;
import org.apache.cassandra.sidecar.common.server.utils.SecondBoundConfiguration;
import org.apache.cassandra.sidecar.config.CdcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdcConfigurationImpl
implements CdcConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(CdcConfigurationImpl.class);
    public static final String IS_ENABLED_PROPERTY = "enabled";
    public static final String CONFIGURATION_REFRESH_TIME_PROPERTY = "config_refresh_time";
    public static final String SEGMENT_HARD_LINK_CACHE_EXPIRY_PROPERTY = "segment_hardlink_cache_expiry";
    public static final boolean DEFAULT_IS_ENABLED = false;
    public static final MillisecondBoundConfiguration DEFAULT_CDC_CONFIG_REFRESH_TIME = MillisecondBoundConfiguration.parse((String)"30s");
    public static final SecondBoundConfiguration DEFAULT_SEGMENT_HARD_LINK_CACHE_EXPIRY = SecondBoundConfiguration.parse((String)"5m");
    public static final String CDC_RAW_CLEANER_FREQUENCY_PROPERTY = "cdc_raw_cleaner_frequency";
    public static final SecondBoundConfiguration DEFAULT_CDC_RAW_CLEANER_FREQUENCY = SecondBoundConfiguration.parse((String)"1m");
    public static final String ENABLE_CDC_RAW_CLEANER_PROPERTY = "enable_cdc_raw_cleaner";
    public static final boolean DEFAULT_ENABLE_CDC_RAW_CLEANER_PROPERTY = true;
    public static final String FALLBACK_CDC_RAW_MAX_DIRECTORY_SIZE_BYTES = "fallback_cdc_raw_max_directory_size_bytes";
    public static final long DEFAULT_FALLBACK_CDC_RAW_MAX_DIRECTORY_SIZE_BYTES = 0x80000000L;
    public static final String CDC_RAW_MAX_DIRECTORY_MAX_PERCENT = "cdc_raw_max_directory_max_percent";
    public static final float DEFAULT_CDC_RAW_MAX_DIRECTORY_MAX_PERCENT = 1.0f;
    public static final String CDC_RAW_MAX_CRITICAL_BUFFER_WINDOW = "cdc_raw_critical_buffer_window";
    public static final SecondBoundConfiguration DEFAULT_CDC_RAW_MAX_CRITICAL_BUFFER_WINDOW = SecondBoundConfiguration.parse((String)"15m");
    public static final String CDC_RAW_MAX_LOW_BUFFER_WINDOW = "cdc_raw_low_buffer_window";
    public static final SecondBoundConfiguration DEFAULT_CDC_RAW_MAX_LOW_BUFFER_WINDOW = SecondBoundConfiguration.parse((String)"60m");
    public static final String CDC_CACHE_MAX_USAGE_DURATION = "cdc_raw_cache_max_usage_duration";
    public static final SecondBoundConfiguration DEFAULT_CDC_CACHE_MAX_USAGE_DURATION = SecondBoundConfiguration.parse((String)"15m");
    @JsonProperty(value="enabled")
    private final boolean isEnabled;
    @JsonProperty(value="config_refresh_time")
    private final MillisecondBoundConfiguration cdcConfigRefreshTime;
    @JsonProperty(value="segment_hardlink_cache_expiry")
    private SecondBoundConfiguration segmentHardLinkCacheExpiry;
    @JsonProperty(value="cdc_raw_cleaner_frequency")
    private SecondBoundConfiguration cdcRawCleanerFrequency;
    @JsonProperty(value="enable_cdc_raw_cleaner")
    private boolean enableCdcRawCleaner;
    @JsonProperty(value="fallback_cdc_raw_max_directory_size_bytes")
    private long fallbackCdcRawMaxDirectorySize;
    @JsonProperty(value="cdc_raw_max_directory_max_percent")
    private float cdcRawMaxPercent;
    @JsonProperty(value="cdc_raw_critical_buffer_window")
    private SecondBoundConfiguration cdcRawCriticalBufferWindow;
    @JsonProperty(value="cdc_raw_low_buffer_window")
    private SecondBoundConfiguration cdcRawLowBufferWindow;
    @JsonProperty(value="cdc_raw_cache_max_usage_duration")
    private SecondBoundConfiguration cacheMaxUsage;

    public CdcConfigurationImpl() {
        this.segmentHardLinkCacheExpiry = DEFAULT_SEGMENT_HARD_LINK_CACHE_EXPIRY;
        this.cdcConfigRefreshTime = DEFAULT_CDC_CONFIG_REFRESH_TIME;
        this.isEnabled = false;
        this.cdcRawCleanerFrequency = DEFAULT_CDC_RAW_CLEANER_FREQUENCY;
        this.enableCdcRawCleaner = true;
        this.fallbackCdcRawMaxDirectorySize = 0x80000000L;
        this.cdcRawMaxPercent = 1.0f;
        this.cdcRawCriticalBufferWindow = DEFAULT_CDC_RAW_MAX_CRITICAL_BUFFER_WINDOW;
        this.cdcRawLowBufferWindow = DEFAULT_CDC_RAW_MAX_LOW_BUFFER_WINDOW;
        this.cacheMaxUsage = DEFAULT_CDC_CACHE_MAX_USAGE_DURATION;
    }

    public CdcConfigurationImpl(boolean isEnabled, MillisecondBoundConfiguration cdcConfigRefreshTime, SecondBoundConfiguration segmentHardLinkCacheExpiry) {
        this(isEnabled, cdcConfigRefreshTime, segmentHardLinkCacheExpiry, DEFAULT_CDC_RAW_CLEANER_FREQUENCY, true, 0x80000000L, 1.0f, DEFAULT_CDC_RAW_MAX_CRITICAL_BUFFER_WINDOW, DEFAULT_CDC_RAW_MAX_LOW_BUFFER_WINDOW, DEFAULT_CDC_CACHE_MAX_USAGE_DURATION);
    }

    public CdcConfigurationImpl(boolean isEnabled, MillisecondBoundConfiguration cdcConfigRefreshTime, SecondBoundConfiguration segmentHardLinkCacheExpiry, SecondBoundConfiguration cdcRawCleanerFrequency, boolean enableCdcRawCleaner, long cdcRawMaxDirectorySize, float cdcRawMaxPercent, SecondBoundConfiguration cdcRawCriticalBufferWindow, SecondBoundConfiguration cdcRawLowBufferWindow, SecondBoundConfiguration cacheMaxUsage) {
        this.isEnabled = isEnabled;
        this.cdcConfigRefreshTime = cdcConfigRefreshTime;
        this.segmentHardLinkCacheExpiry = segmentHardLinkCacheExpiry;
        this.cdcRawCleanerFrequency = cdcRawCleanerFrequency;
        this.enableCdcRawCleaner = enableCdcRawCleaner;
        this.fallbackCdcRawMaxDirectorySize = cdcRawMaxDirectorySize;
        this.cdcRawMaxPercent = cdcRawMaxPercent;
        this.cdcRawCriticalBufferWindow = cdcRawCriticalBufferWindow;
        this.cdcRawLowBufferWindow = cdcRawLowBufferWindow;
        this.cacheMaxUsage = cacheMaxUsage;
    }

    @Override
    @JsonProperty(value="enabled")
    public boolean isEnabled() {
        return this.isEnabled;
    }

    @Override
    @JsonProperty(value="config_refresh_time")
    public MillisecondBoundConfiguration cdcConfigRefreshTime() {
        return this.cdcConfigRefreshTime;
    }

    @Override
    @JsonProperty(value="segment_hardlink_cache_expiry")
    public SecondBoundConfiguration segmentHardLinkCacheExpiry() {
        return this.segmentHardLinkCacheExpiry;
    }

    @JsonProperty(value="segment_hardlink_cache_expiry_in_secs")
    @Deprecated
    public void setSegmentHardLinkCacheExpiryInSecs(long segmentHardlinkCacheExpiryInSecs) {
        LOGGER.warn("'segment_hardlink_cache_expiry_in_secs' is deprecated, use 'segment_hardlink_cache_expiry' instead");
        this.segmentHardLinkCacheExpiry = new SecondBoundConfiguration(segmentHardlinkCacheExpiryInSecs, TimeUnit.SECONDS);
    }

    @Override
    @JsonProperty(value="cdc_raw_cleaner_frequency")
    public SecondBoundConfiguration cdcRawDirectorySpaceCleanerFrequency() {
        return this.cdcRawCleanerFrequency;
    }

    @JsonProperty(value="cdc_raw_cleaner_frequency")
    public void setCdcRawDirectorySpaceCleanerFrequency(SecondBoundConfiguration cdcRawCleanerFrequency) {
        this.cdcRawCleanerFrequency = cdcRawCleanerFrequency;
    }

    @Override
    @JsonProperty(value="enable_cdc_raw_cleaner")
    public boolean enableCdcRawDirectoryRoutineCleanUp() {
        return this.enableCdcRawCleaner;
    }

    @JsonProperty(value="enable_cdc_raw_cleaner")
    public void setEnableCdcRawCleaner(boolean enableCdcRawCleaner) {
        this.enableCdcRawCleaner = enableCdcRawCleaner;
    }

    @Override
    @JsonProperty(value="fallback_cdc_raw_max_directory_size_bytes")
    public long fallbackCdcRawDirectoryMaxSizeBytes() {
        return this.fallbackCdcRawMaxDirectorySize;
    }

    @JsonProperty(value="fallback_cdc_raw_max_directory_size_bytes")
    public void setFallbackCdcRawDirectoryMaxSizeBytes(long fallbackCdcRawMaxDirectorySize) {
        this.fallbackCdcRawMaxDirectorySize = fallbackCdcRawMaxDirectorySize;
    }

    @Override
    @JsonProperty(value="cdc_raw_max_directory_max_percent")
    public float cdcRawDirectoryMaxPercentUsage() {
        return this.cdcRawMaxPercent;
    }

    @JsonProperty(value="cdc_raw_max_directory_max_percent")
    public void setCdcRawDirectoryMaxPercentUsage(long cdcRawMaxPercent) {
        this.cdcRawMaxPercent = cdcRawMaxPercent;
    }

    @Override
    @JsonProperty(value="cdc_raw_critical_buffer_window")
    public SecondBoundConfiguration cdcRawDirectoryCriticalBufferWindow() {
        return this.cdcRawCriticalBufferWindow;
    }

    @JsonProperty(value="cdc_raw_critical_buffer_window")
    public void setCdcRawDirectoryCriticalBufferWindow(SecondBoundConfiguration cdcRawCriticalBufferWindow) {
        this.cdcRawCriticalBufferWindow = cdcRawCriticalBufferWindow;
    }

    @Override
    @JsonProperty(value="cdc_raw_low_buffer_window")
    public SecondBoundConfiguration cdcRawDirectoryLowBufferWindow() {
        return this.cdcRawLowBufferWindow;
    }

    @JsonProperty(value="cdc_raw_low_buffer_window")
    public void setCdcRawDirectoryLowBufferWindow(SecondBoundConfiguration cdcRawLowBufferWindow) {
        this.cdcRawLowBufferWindow = cdcRawLowBufferWindow;
    }

    @Override
    @JsonProperty(value="cdc_raw_cache_max_usage_duration")
    public SecondBoundConfiguration cacheMaxUsage() {
        return this.cacheMaxUsage;
    }

    @JsonProperty(value="cdc_raw_cache_max_usage_duration")
    public void setCacheMaxUsage(SecondBoundConfiguration cacheMaxUsage) {
        this.cacheMaxUsage = cacheMaxUsage;
    }
}

