/*
 * Camel ApiMethod Enumeration generated by camel-api-component-maven-plugin
 */
package org.apache.camel.component.box.internal;

import java.lang.reflect.Method;
import java.util.List;

import org.apache.camel.component.box.api.BoxUsersManager;

import org.apache.camel.support.component.ApiMethod;
import org.apache.camel.support.component.ApiMethodArg;
import org.apache.camel.support.component.ApiMethodImpl;

import static org.apache.camel.support.component.ApiMethodArg.arg;

/**
 * Camel {@link ApiMethod} Enumeration for org.apache.camel.component.box.api.BoxUsersManager
 */
public enum BoxUsersManagerApiMethod implements ApiMethod {

    ADD_USER_EMAIL_ALIAS(
        com.box.sdk.EmailAlias.class,
        "addUserEmailAlias",
        arg("userId", String.class),
        arg("email", String.class)),

    CREATE_APP_USER(
        com.box.sdk.BoxUser.class,
        "createAppUser",
        arg("name", String.class),
        arg("params", com.box.sdk.CreateUserParams.class)),

    CREATE_ENTERPRISE_USER(
        com.box.sdk.BoxUser.class,
        "createEnterpriseUser",
        arg("login", String.class),
        arg("name", String.class),
        arg("params", com.box.sdk.CreateUserParams.class)),

    DELETE_USER(
        void.class,
        "deleteUser",
        arg("userId", String.class),
        arg("notifyUser", boolean.class),
        arg("force", boolean.class)),

    DELETE_USER_EMAIL_ALIAS(
        void.class,
        "deleteUserEmailAlias",
        arg("userId", String.class),
        arg("emailAliasId", String.class)),

    GET_ALL_ENTERPRISE_OR_EXTERNAL_USERS(
        java.util.List.class,
        "getAllEnterpriseOrExternalUsers",
        arg("filterTerm", String.class),
        arg("fields", new String[0].getClass())),

    GET_CURRENT_USER(
        com.box.sdk.BoxUser.class,
        "getCurrentUser"),

    GET_USER_EMAIL_ALIAS(
        java.util.Collection.class,
        "getUserEmailAlias",
        arg("userId", String.class)),

    GET_USER_INFO(
        com.box.sdk.BoxUser.Info.class,
        "getUserInfo",
        arg("userId", String.class)),

    MOVE_FOLDER_TO_USER(
        com.box.sdk.BoxFolder.Info.class,
        "moveFolderToUser",
        arg("userId", String.class),
        arg("sourceUserId", String.class)),

    UPDATE_USER_INFO(
        com.box.sdk.BoxUser.class,
        "updateUserInfo",
        arg("userId", String.class),
        arg("info", com.box.sdk.BoxUser.Info.class));

    private final ApiMethod apiMethod;

    private BoxUsersManagerApiMethod(Class<?> resultType, String name, ApiMethodArg... args) {
        this.apiMethod = new ApiMethodImpl(BoxUsersManager.class, resultType, name, args);
    }

    @Override
    public String getName() { return apiMethod.getName(); }

    @Override
    public Class<?> getResultType() { return apiMethod.getResultType(); }

    @Override
    public List<String> getArgNames() { return apiMethod.getArgNames(); }

    @Override
    public List<Class<?>> getArgTypes() { return apiMethod.getArgTypes(); }

    @Override
    public Method getMethod() { return apiMethod.getMethod(); }
}
