/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.audit;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.TestableZooKeeper;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.audit.Slf4jAuditLogger;
import org.apache.zookeeper.test.ClientBase;
import org.apache.zookeeper.test.LoggerTestTool;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.Test;

public class StandaloneServerAuditTest
extends ClientBase {
    private static ByteArrayOutputStream os;

    @BeforeAll
    public static void setup() {
        System.setProperty("zookeeper.audit.enable", "true");
        LoggerTestTool loggerTestTool = new LoggerTestTool(Slf4jAuditLogger.class);
        os = loggerTestTool.getOutputStream();
    }

    @AfterAll
    public static void teardown() {
        System.clearProperty("zookeeper.audit.enable");
    }

    @Test
    public void testCreateAuditLog() throws KeeperException, InterruptedException, IOException {
        TestableZooKeeper zk = this.createClient();
        String path = "/createPath";
        zk.create(path, "".getBytes(), ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
        List<String> logs = StandaloneServerAuditTest.readAuditLog(os);
        Assertions.assertEquals((int)1, (int)logs.size());
        Assertions.assertTrue((boolean)logs.get(0).endsWith("operation=create\tznode=/createPath\tznode_type=persistent\tresult=success"));
    }

    private static List<String> readAuditLog(ByteArrayOutputStream os) throws IOException {
        String line;
        ArrayList<String> logs = new ArrayList<String>();
        LineNumberReader r = new LineNumberReader(new StringReader(os.toString()));
        while ((line = r.readLine()) != null) {
            logs.add(line);
        }
        os.reset();
        return logs;
    }
}

