/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.server;

import java.util.Set;
import org.apache.zookeeper.server.DataNode;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class DataNodeTest {
    @Test
    public void testGetChildrenShouldReturnEmptySetWhenThereAreNoChidren() {
        DataNode dataNode = new DataNode();
        Set children = dataNode.getChildren();
        Assertions.assertNotNull((Object)children);
        Assertions.assertEquals((int)0, (int)children.size());
        String child = "child";
        dataNode.addChild(child);
        dataNode.removeChild(child);
        children = dataNode.getChildren();
        Assertions.assertNotNull((Object)children);
        Assertions.assertEquals((int)0, (int)children.size());
        children = dataNode.getChildren();
        try {
            children.add("new child");
            Assertions.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @Test
    public void testGetChildrenReturnsImmutableEmptySet() {
        DataNode dataNode = new DataNode();
        Set children = dataNode.getChildren();
        try {
            children.add("new child");
            Assertions.fail((String)"UnsupportedOperationException is expected");
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }
}

