/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.api.LedgerMetadata;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EnsembleUtils {
    private static final Logger LOG = LoggerFactory.getLogger(EnsembleUtils.class);

    EnsembleUtils() {
    }

    static List<BookieSocketAddress> replaceBookiesInEnsemble(BookieWatcher bookieWatcher, LedgerMetadata metadata, List<BookieSocketAddress> oldEnsemble, Map<Integer, BookieSocketAddress> failedBookies, String logContext) throws BKException.BKNotEnoughBookiesException {
        ArrayList<BookieSocketAddress> newEnsemble = new ArrayList<BookieSocketAddress>(oldEnsemble);
        int ensembleSize = metadata.getEnsembleSize();
        int writeQ = metadata.getWriteQuorumSize();
        int ackQ = metadata.getAckQuorumSize();
        Map<String, byte[]> customMetadata = metadata.getCustomMetadata();
        HashSet<BookieSocketAddress> exclude = new HashSet<BookieSocketAddress>(failedBookies.values());
        int replaced = 0;
        for (Map.Entry<Integer, BookieSocketAddress> entry : failedBookies.entrySet()) {
            int idx = entry.getKey();
            BookieSocketAddress addr = entry.getValue();
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} replacing bookie: {} index: {}", new Object[]{logContext, addr, idx});
            }
            if (!((BookieSocketAddress)newEnsemble.get(idx)).equals(addr)) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("{} Not changing failed bookie {} at index {}, already changed to {}", new Object[]{logContext, addr, idx, newEnsemble.get(idx)});
                continue;
            }
            try {
                BookieSocketAddress newBookie = bookieWatcher.replaceBookie(ensembleSize, writeQ, ackQ, customMetadata, newEnsemble, idx, exclude);
                newEnsemble.set(idx, newBookie);
                ++replaced;
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                if (replaced > 0) break;
                throw e;
            }
        }
        return newEnsemble;
    }

    static Set<Integer> diffEnsemble(List<BookieSocketAddress> e1, List<BookieSocketAddress> e2) {
        Preconditions.checkArgument((e1.size() == e2.size() ? 1 : 0) != 0, (Object)"Ensembles must be of same size");
        HashSet<Integer> diff = new HashSet<Integer>();
        for (int i = 0; i < e1.size(); ++i) {
            if (e1.get(i).equals(e2.get(i))) continue;
            diff.add(i);
        }
        return diff;
    }
}

