/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.common.statement;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.lang.common.base.AbstractStatement;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.base.Statement;
import org.apache.asterix.lang.common.expression.TypeExpression;
import org.apache.asterix.lang.common.struct.Identifier;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;

public final class CreateViewStatement
extends AbstractStatement {
    private final DataverseName dataverseName;
    private final String viewName;
    private final TypeExpression itemType;
    private final String viewBody;
    private final Expression viewBodyExpression;
    private final Map<String, String> viewConfig;
    private final KeyDecl primaryKeyDecl;
    private final List<ForeignKeyDecl> foreignKeyDecls;
    private final Boolean defaultNull;
    private final boolean replaceIfExists;
    private final boolean ifNotExists;

    public CreateViewStatement(DataverseName dataverseName, String viewName, TypeExpression itemType, String viewBody, Expression viewBodyExpression, Boolean defaultNull, Map<String, String> viewConfig, KeyDecl primaryKeyDecl, List<ForeignKeyDecl> foreignKeyDecls, boolean replaceIfExists, boolean ifNotExists) {
        this.dataverseName = dataverseName;
        this.viewName = Objects.requireNonNull(viewName);
        this.itemType = itemType;
        this.viewBody = Objects.requireNonNull(viewBody);
        this.viewBodyExpression = Objects.requireNonNull(viewBodyExpression);
        this.defaultNull = defaultNull;
        this.viewConfig = viewConfig;
        this.primaryKeyDecl = primaryKeyDecl;
        this.foreignKeyDecls = foreignKeyDecls;
        this.replaceIfExists = replaceIfExists;
        this.ifNotExists = ifNotExists;
    }

    @Override
    public Statement.Kind getKind() {
        return Statement.Kind.CREATE_VIEW;
    }

    @Override
    public byte getCategory() {
        return 4;
    }

    public DataverseName getDataverseName() {
        return this.dataverseName;
    }

    public String getViewName() {
        return this.viewName;
    }

    public boolean hasItemType() {
        return this.itemType != null;
    }

    public TypeExpression getItemType() {
        return this.itemType;
    }

    public String getViewBody() {
        return this.viewBody;
    }

    public Expression getViewBodyExpression() {
        return this.viewBodyExpression;
    }

    public boolean getReplaceIfExists() {
        return this.replaceIfExists;
    }

    public boolean getIfNotExists() {
        return this.ifNotExists;
    }

    public Boolean getDefaultNull() {
        return this.defaultNull;
    }

    public KeyDecl getPrimaryKeyDecl() {
        return this.primaryKeyDecl;
    }

    public List<ForeignKeyDecl> getForeignKeyDecls() {
        return this.foreignKeyDecls;
    }

    public Map<String, String> getViewConfiguration() {
        return this.viewConfig;
    }

    @Override
    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return visitor.visit(this, arg);
    }

    public static class KeyDecl {
        protected final List<List<String>> fields;
        protected final List<Integer> sourceIndicators;

        public KeyDecl(List<List<String>> fields, List<Integer> sourceIndicators) {
            this.fields = fields;
            this.sourceIndicators = sourceIndicators;
        }

        public List<List<String>> getFields() {
            return this.fields;
        }

        public List<Integer> getSourceIndicators() {
            return this.sourceIndicators;
        }
    }

    public static class ForeignKeyDecl
    extends KeyDecl {
        private final DataverseName referencedDataverseName;
        private final Identifier referencedDatasetName;

        public ForeignKeyDecl(List<List<String>> fields, List<Integer> sourceIndicators, DataverseName referencedDataverseName, Identifier referencedDatasetName) {
            super(fields, sourceIndicators);
            this.referencedDataverseName = referencedDataverseName;
            this.referencedDatasetName = referencedDatasetName;
        }

        public DataverseName getReferencedDataverseName() {
            return this.referencedDataverseName;
        }

        public Identifier getReferencedDatasetName() {
            return this.referencedDatasetName;
        }
    }
}

