/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.hadoop.tools.rumen.Histogram;
import org.apache.hadoop.tools.rumen.HistoryEvent;
import org.apache.hadoop.tools.rumen.JhCounters;
import org.apache.hadoop.tools.rumen.JobConfPropertyNames;
import org.apache.hadoop.tools.rumen.JobFinishedEvent;
import org.apache.hadoop.tools.rumen.JobHistoryUtils;
import org.apache.hadoop.tools.rumen.JobInfoChangeEvent;
import org.apache.hadoop.tools.rumen.JobInitedEvent;
import org.apache.hadoop.tools.rumen.JobPriorityChangeEvent;
import org.apache.hadoop.tools.rumen.JobStatusChangedEvent;
import org.apache.hadoop.tools.rumen.JobSubmittedEvent;
import org.apache.hadoop.tools.rumen.JobUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.LoggedDiscreteCDF;
import org.apache.hadoop.tools.rumen.LoggedJob;
import org.apache.hadoop.tools.rumen.LoggedLocation;
import org.apache.hadoop.tools.rumen.LoggedTask;
import org.apache.hadoop.tools.rumen.LoggedTaskAttempt;
import org.apache.hadoop.tools.rumen.MapAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.ParsedHost;
import org.apache.hadoop.tools.rumen.ParsedJob;
import org.apache.hadoop.tools.rumen.ParsedTask;
import org.apache.hadoop.tools.rumen.ParsedTaskAttempt;
import org.apache.hadoop.tools.rumen.Pre21JobHistoryConstants;
import org.apache.hadoop.tools.rumen.ReduceAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptStartedEvent;
import org.apache.hadoop.tools.rumen.TaskAttemptUnsuccessfulCompletionEvent;
import org.apache.hadoop.tools.rumen.TaskFailedEvent;
import org.apache.hadoop.tools.rumen.TaskFinishedEvent;
import org.apache.hadoop.tools.rumen.TaskStartedEvent;
import org.apache.hadoop.tools.rumen.TaskUpdatedEvent;
import org.apache.hadoop.util.StringUtils;

public class JobBuilder {
    private static final long BYTES_IN_MEG = StringUtils.TraditionalBinaryPrefix.string2long("1m");
    private String jobID;
    private boolean finalized = false;
    private ParsedJob result = new ParsedJob();
    private Map<String, ParsedTask> mapTasks = new HashMap<String, ParsedTask>();
    private Map<String, ParsedTask> reduceTasks = new HashMap<String, ParsedTask>();
    private Map<String, ParsedTask> otherTasks = new HashMap<String, ParsedTask>();
    private Map<String, ParsedTaskAttempt> attempts = new HashMap<String, ParsedTaskAttempt>();
    private Map<ParsedHost, ParsedHost> allHosts = new HashMap<ParsedHost, ParsedHost>();
    private static final int MAXIMUM_PREFERRED_LOCATIONS = 25;
    private static final Pattern taskAttemptIDPattern = Pattern.compile(".*_([0-9]+)");
    private int[] attemptTimesPercentiles = null;
    private static final Pattern heapPattern = Pattern.compile("-Xmx([0-9]+[kKmMgGtT])");
    private Properties jobConfigurationParameters = null;

    public JobBuilder(String jobID) {
        if (this.attemptTimesPercentiles == null) {
            this.attemptTimesPercentiles = new int[19];
            for (int i = 0; i < 19; ++i) {
                this.attemptTimesPercentiles[i] = (i + 1) * 5;
            }
        }
        this.jobID = jobID;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void process(HistoryEvent event) {
        if (this.finalized) {
            throw new IllegalStateException("JobBuilder.process(HistoryEvent event) called after ParsedJob built");
        }
        if (event instanceof JobFinishedEvent) {
            this.processJobFinishedEvent((JobFinishedEvent)event);
        } else if (event instanceof JobInfoChangeEvent) {
            this.processJobInfoChangeEvent((JobInfoChangeEvent)event);
        } else if (event instanceof JobInitedEvent) {
            this.processJobInitedEvent((JobInitedEvent)event);
        } else if (event instanceof JobPriorityChangeEvent) {
            this.processJobPriorityChangeEvent((JobPriorityChangeEvent)event);
        } else if (event instanceof JobStatusChangedEvent) {
            this.processJobStatusChangedEvent((JobStatusChangedEvent)event);
        } else if (event instanceof JobSubmittedEvent) {
            this.processJobSubmittedEvent((JobSubmittedEvent)event);
        } else if (event instanceof JobUnsuccessfulCompletionEvent) {
            this.processJobUnsuccessfulCompletionEvent((JobUnsuccessfulCompletionEvent)event);
        } else if (event instanceof MapAttemptFinishedEvent) {
            this.processMapAttemptFinishedEvent((MapAttemptFinishedEvent)event);
        } else if (event instanceof ReduceAttemptFinishedEvent) {
            this.processReduceAttemptFinishedEvent((ReduceAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptFinishedEvent) {
            this.processTaskAttemptFinishedEvent((TaskAttemptFinishedEvent)event);
        } else if (event instanceof TaskAttemptStartedEvent) {
            this.processTaskAttemptStartedEvent((TaskAttemptStartedEvent)event);
        } else if (event instanceof TaskAttemptUnsuccessfulCompletionEvent) {
            this.processTaskAttemptUnsuccessfulCompletionEvent((TaskAttemptUnsuccessfulCompletionEvent)event);
        } else if (event instanceof TaskFailedEvent) {
            this.processTaskFailedEvent((TaskFailedEvent)event);
        } else if (event instanceof TaskFinishedEvent) {
            this.processTaskFinishedEvent((TaskFinishedEvent)event);
        } else if (event instanceof TaskStartedEvent) {
            this.processTaskStartedEvent((TaskStartedEvent)event);
        } else if (event instanceof TaskUpdatedEvent) {
            this.processTaskUpdatedEvent((TaskUpdatedEvent)event);
        } else {
            throw new IllegalArgumentException("JobBuilder.process(HistoryEvent): unknown event type");
        }
    }

    static String extract(Properties conf, String[] names, String defaultValue) {
        for (String name : names) {
            String result = conf.getProperty(name);
            if (result == null) continue;
            return result;
        }
        return defaultValue;
    }

    private Integer extractMegabytes(Properties conf, String[] names) {
        String javaOptions = JobBuilder.extract(conf, names, null);
        if (javaOptions == null) {
            return null;
        }
        Matcher matcher = heapPattern.matcher(javaOptions);
        Integer heapMegabytes = null;
        while (matcher.find()) {
            String heapSize = matcher.group(1);
            heapMegabytes = (int)(StringUtils.TraditionalBinaryPrefix.string2long(heapSize) / BYTES_IN_MEG);
        }
        return heapMegabytes;
    }

    private void maybeSetHeapMegabytes(Integer megabytes) {
        if (megabytes != null) {
            this.result.setHeapMegabytes(megabytes);
        }
    }

    private void maybeSetJobMapMB(Integer megabytes) {
        if (megabytes != null) {
            this.result.setJobMapMB(megabytes);
        }
    }

    private void maybeSetJobReduceMB(Integer megabytes) {
        if (megabytes != null) {
            this.result.setJobReduceMB(megabytes);
        }
    }

    public void process(Properties conf) {
        if (this.finalized) {
            throw new IllegalStateException("JobBuilder.process(Properties conf) called after ParsedJob built");
        }
        String queue = JobBuilder.extract(conf, JobConfPropertyNames.QUEUE_NAMES.getCandidates(), null);
        if (queue != null) {
            this.result.setQueue(queue);
        }
        this.result.setJobName(JobBuilder.extract(conf, JobConfPropertyNames.JOB_NAMES.getCandidates(), null));
        this.maybeSetHeapMegabytes(this.extractMegabytes(conf, JobConfPropertyNames.TASK_JAVA_OPTS_S.getCandidates()));
        this.maybeSetJobMapMB(this.extractMegabytes(conf, JobConfPropertyNames.MAP_JAVA_OPTS_S.getCandidates()));
        this.maybeSetJobReduceMB(this.extractMegabytes(conf, JobConfPropertyNames.REDUCE_JAVA_OPTS_S.getCandidates()));
        this.jobConfigurationParameters = conf;
    }

    public ParsedJob build() {
        this.finalized = true;
        this.result.setJobProperties(this.jobConfigurationParameters);
        Histogram[] successfulMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
        for (int i = 0; i < successfulMapAttemptTimes.length; ++i) {
            successfulMapAttemptTimes[i] = new Histogram();
        }
        Histogram successfulReduceAttemptTimes = new Histogram();
        Histogram[] failedMapAttemptTimes = new Histogram[ParsedHost.numberOfDistances() + 1];
        for (int i = 0; i < failedMapAttemptTimes.length; ++i) {
            failedMapAttemptTimes[i] = new Histogram();
        }
        Histogram failedReduceAttemptTimes = new Histogram();
        Histogram successfulNthMapperAttempts = new Histogram();
        for (LoggedTask task : this.result.getMapTasks()) {
            for (LoggedTaskAttempt attempt : task.getAttempts()) {
                int distance = successfulMapAttemptTimes.length - 1;
                Long runtime = null;
                if (attempt.getFinishTime() <= 0L || attempt.getStartTime() <= 0L) continue;
                runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (attempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
                    String attemptNumberString;
                    Matcher matcher;
                    String attemptID;
                    LoggedLocation host = attempt.getLocation();
                    List<LoggedLocation> locs = task.getPreferredLocations();
                    if (host != null && locs != null) {
                        for (LoggedLocation loc : locs) {
                            ParsedHost preferedLoc = new ParsedHost(loc);
                            distance = Math.min(distance, preferedLoc.distance(new ParsedHost(host)));
                        }
                    }
                    if (attempt.getStartTime() > 0L && attempt.getFinishTime() > 0L && runtime != null) {
                        successfulMapAttemptTimes[distance].enter(runtime);
                    }
                    if ((attemptID = attempt.getAttemptID()) == null || !(matcher = taskAttemptIDPattern.matcher(attemptID)).matches() || (attemptNumberString = matcher.group(1)) == null) continue;
                    int attemptNumber = Integer.parseInt(attemptNumberString);
                    successfulNthMapperAttempts.enter(attemptNumber);
                    continue;
                }
                if (attempt.getResult() != Pre21JobHistoryConstants.Values.FAILED || runtime == null) continue;
                failedMapAttemptTimes[distance].enter(runtime);
            }
        }
        for (LoggedTask task : this.result.getReduceTasks()) {
            for (LoggedTaskAttempt attempt : task.getAttempts()) {
                Long runtime = attempt.getFinishTime() - attempt.getStartTime();
                if (attempt.getFinishTime() > 0L && attempt.getStartTime() > 0L) {
                    runtime = attempt.getFinishTime() - attempt.getStartTime();
                }
                if (attempt.getResult() == Pre21JobHistoryConstants.Values.SUCCESS) {
                    if (runtime == null) continue;
                    successfulReduceAttemptTimes.enter(runtime);
                    continue;
                }
                if (attempt.getResult() != Pre21JobHistoryConstants.Values.FAILED) continue;
                failedReduceAttemptTimes.enter(runtime);
            }
        }
        this.result.setFailedMapAttemptCDFs(this.mapCDFArrayList(failedMapAttemptTimes));
        LoggedDiscreteCDF failedReduce = new LoggedDiscreteCDF();
        failedReduce.setCDF(failedReduceAttemptTimes, this.attemptTimesPercentiles, 100);
        this.result.setFailedReduceAttemptCDF(failedReduce);
        this.result.setSuccessfulMapAttemptCDFs(this.mapCDFArrayList(successfulMapAttemptTimes));
        LoggedDiscreteCDF succReduce = new LoggedDiscreteCDF();
        succReduce.setCDF(successfulReduceAttemptTimes, this.attemptTimesPercentiles, 100);
        this.result.setSuccessfulReduceAttemptCDF(succReduce);
        long totalSuccessfulAttempts = 0L;
        long maxTriesToSucceed = 0L;
        for (Map.Entry<Long, Long> ent : successfulNthMapperAttempts) {
            totalSuccessfulAttempts += ent.getValue().longValue();
            maxTriesToSucceed = Math.max(maxTriesToSucceed, ent.getKey());
        }
        if (totalSuccessfulAttempts > 0L) {
            double[] successAfterI = new double[(int)maxTriesToSucceed + 1];
            for (int i = 0; i < successAfterI.length; ++i) {
                successAfterI[i] = 0.0;
            }
            for (Map.Entry<Long, Long> ent : successfulNthMapperAttempts) {
                successAfterI[ent.getKey().intValue()] = (double)ent.getValue().longValue() / (double)totalSuccessfulAttempts;
            }
            this.result.setMapperTriesToSucceed(successAfterI);
        } else {
            this.result.setMapperTriesToSucceed(null);
        }
        return this.result;
    }

    private ArrayList<LoggedDiscreteCDF> mapCDFArrayList(Histogram[] data) {
        ArrayList<LoggedDiscreteCDF> result = new ArrayList<LoggedDiscreteCDF>();
        for (Histogram hist : data) {
            LoggedDiscreteCDF discCDF = new LoggedDiscreteCDF();
            discCDF.setCDF(hist, this.attemptTimesPercentiles, 100);
            result.add(discCDF);
        }
        return result;
    }

    private static Pre21JobHistoryConstants.Values getPre21Value(String name) {
        if (name.equalsIgnoreCase("JOB_CLEANUP")) {
            return Pre21JobHistoryConstants.Values.CLEANUP;
        }
        if (name.equalsIgnoreCase("JOB_SETUP")) {
            return Pre21JobHistoryConstants.Values.SETUP;
        }
        return Pre21JobHistoryConstants.Values.valueOf(name.toUpperCase());
    }

    private void processTaskUpdatedEvent(TaskUpdatedEvent event) {
        ParsedTask task = this.getTask(event.getTaskId().toString());
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
    }

    private void processTaskStartedEvent(TaskStartedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), true);
        task.setStartTime(event.getStartTime());
        task.setPreferredLocations(this.preferredLocationForSplits(event.getSplitLocations()));
    }

    private void processTaskFinishedEvent(TaskFinishedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), false);
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
        task.setTaskStatus(JobBuilder.getPre21Value(event.getTaskStatus()));
        task.incorporateCounters(event.getCounters());
    }

    private void processTaskFailedEvent(TaskFailedEvent event) {
        ParsedTask task = this.getOrMakeTask(event.getTaskType(), event.getTaskId().toString(), false);
        if (task == null) {
            return;
        }
        task.setFinishTime(event.getFinishTime());
        task.setTaskStatus(JobBuilder.getPre21Value(event.getTaskStatus()));
        task.putDiagnosticInfo(event.getError());
        task.putFailedDueToAttemptId(event.getFailedAttemptID().toString());
    }

    private void processTaskAttemptUnsuccessfulCompletionEvent(TaskAttemptUnsuccessfulCompletionEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getTaskAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value(event.getTaskStatus()));
        ParsedHost parsedHost = this.getAndRecordParsedHost(event.getHostname());
        if (parsedHost != null) {
            attempt.setLocation(parsedHost.makeLoggedLocation());
        }
        attempt.setFinishTime(event.getFinishTime());
        attempt.putDiagnosticInfo(event.getError());
    }

    private void processTaskAttemptStartedEvent(TaskAttemptStartedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getTaskAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setStartTime(event.getStartTime());
        attempt.putTrackerName(event.getTrackerName());
        attempt.putHttpPort(event.getHttpPort());
    }

    private void processTaskAttemptFinishedEvent(TaskAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value(event.getTaskStatus()));
        attempt.setLocation(this.getAndRecordParsedHost(event.getHostname()).makeLoggedLocation());
        attempt.setFinishTime(event.getFinishTime());
        attempt.incorporateCounters(event.getCounters());
    }

    private void processReduceAttemptFinishedEvent(ReduceAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value(event.getTaskStatus()));
        attempt.setHostName(event.getHostname());
        attempt.setFinishTime(event.getFinishTime());
        attempt.setShuffleFinished(event.getShuffleFinishTime());
        attempt.setSortFinished(event.getSortFinishTime());
        attempt.incorporateCounters(event.getCounters());
    }

    private void processMapAttemptFinishedEvent(MapAttemptFinishedEvent event) {
        ParsedTaskAttempt attempt = this.getOrMakeTaskAttempt(event.getTaskType(), event.getTaskId().toString(), event.getAttemptId().toString());
        if (attempt == null) {
            return;
        }
        attempt.setResult(JobBuilder.getPre21Value(event.getTaskStatus()));
        attempt.setHostName(event.getHostname());
        attempt.setFinishTime(event.getFinishTime());
        attempt.incorporateCounters(event.getCounters());
    }

    private void processJobUnsuccessfulCompletionEvent(JobUnsuccessfulCompletionEvent event) {
        this.result.setOutcome(Pre21JobHistoryConstants.Values.valueOf(event.getStatus()));
        this.result.setFinishTime(event.getFinishTime());
    }

    private void processJobSubmittedEvent(JobSubmittedEvent event) {
        this.result.setJobID(event.getJobId().toString());
        this.result.setJobName(event.getJobName());
        this.result.setUser(event.getUserName());
        this.result.setSubmitTime(event.getSubmitTime());
        this.result.putJobConfPath(event.getJobConfPath());
        String queue = event.getJobQueueName();
        if (queue != null) {
            this.result.setQueue(queue);
        }
        this.result.putJobAcls(event.getJobAcls());
    }

    private void processJobStatusChangedEvent(JobStatusChangedEvent event) {
        this.result.setOutcome(Pre21JobHistoryConstants.Values.valueOf(event.getStatus()));
    }

    private void processJobPriorityChangeEvent(JobPriorityChangeEvent event) {
        this.result.setPriority(LoggedJob.JobPriority.valueOf(event.getPriority().toString()));
    }

    private void processJobInitedEvent(JobInitedEvent event) {
        this.result.setLaunchTime(event.getLaunchTime());
        this.result.setTotalMaps(event.getTotalMaps());
        this.result.setTotalReduces(event.getTotalReduces());
    }

    private void processJobInfoChangeEvent(JobInfoChangeEvent event) {
        this.result.setLaunchTime(event.getLaunchTime());
    }

    private void processJobFinishedEvent(JobFinishedEvent event) {
        this.result.setFinishTime(event.getFinishTime());
        this.result.setJobID(this.jobID);
        this.result.setOutcome(Pre21JobHistoryConstants.Values.SUCCESS);
        Map<String, Long> countersMap = JobHistoryUtils.extractCounters(new JhCounters(event.getTotalCounters(), "COUNTERS"));
        this.result.putTotalCounters(countersMap);
        countersMap = JobHistoryUtils.extractCounters(new JhCounters(event.getMapCounters(), "MAP_COUNTERS"));
        this.result.putMapCounters(countersMap);
        countersMap = JobHistoryUtils.extractCounters(new JhCounters(event.getReduceCounters(), "REDUCE_COUNTERS"));
        this.result.putReduceCounters(countersMap);
    }

    private ParsedTask getTask(String taskIDname) {
        ParsedTask result = this.mapTasks.get(taskIDname);
        if (result != null) {
            return result;
        }
        result = this.reduceTasks.get(taskIDname);
        if (result != null) {
            return result;
        }
        return this.otherTasks.get(taskIDname);
    }

    private ParsedTask getOrMakeTask(TaskType type, String taskIDname, boolean allowCreate) {
        Map<String, ParsedTask> taskMap = this.otherTasks;
        List<LoggedTask> tasks = this.result.getOtherTasks();
        switch (type) {
            case MAP: {
                taskMap = this.mapTasks;
                tasks = this.result.getMapTasks();
                break;
            }
            case REDUCE: {
                taskMap = this.reduceTasks;
                tasks = this.result.getReduceTasks();
                break;
            }
        }
        ParsedTask result = taskMap.get(taskIDname);
        if (result == null && allowCreate) {
            result = new ParsedTask();
            result.setTaskType(JobBuilder.getPre21Value(type.toString()));
            result.setTaskID(taskIDname);
            taskMap.put(taskIDname, result);
            tasks.add(result);
        }
        return result;
    }

    private ParsedTaskAttempt getOrMakeTaskAttempt(TaskType type, String taskIDName, String taskAttemptName) {
        ParsedTask task = this.getOrMakeTask(type, taskIDName, false);
        ParsedTaskAttempt result = this.attempts.get(taskAttemptName);
        if (result == null && task != null) {
            result = new ParsedTaskAttempt();
            result.setAttemptID(taskAttemptName);
            this.attempts.put(taskAttemptName, result);
            task.getAttempts().add(result);
        }
        return result;
    }

    private ParsedHost getAndRecordParsedHost(String hostName) {
        ParsedHost result = ParsedHost.parse(hostName);
        if (result != null) {
            ParsedHost canonicalResult = this.allHosts.get(result);
            if (canonicalResult != null) {
                return canonicalResult;
            }
            this.allHosts.put(result, result);
            return result;
        }
        return null;
    }

    private ArrayList<LoggedLocation> preferredLocationForSplits(String splits) {
        if (splits != null) {
            ArrayList<LoggedLocation> locations = null;
            StringTokenizer tok = new StringTokenizer(splits, ",", false);
            if (tok.countTokens() <= 25) {
                locations = new ArrayList<LoggedLocation>();
                while (tok.hasMoreTokens()) {
                    String nextSplit = tok.nextToken();
                    ParsedHost node = this.getAndRecordParsedHost(nextSplit);
                    if (locations == null || node == null) continue;
                    locations.add(node.makeLoggedLocation());
                }
                return locations;
            }
        }
        return null;
    }
}

