﻿/*
Licensed to the Apache Software Foundation (ASF) under one
or more contributor license agreements.  See the NOTICE file
distributed with this work for additional information
regarding copyright ownership.  The ASF licenses this file
to you under the Apache License, Version 2.0 (the
"License"); you may not use this file except in compliance
with the License.  You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/*
Deployment script for $(AMBARIDBNAME)

Use this script in sqlcmd mode, with a series of environment variables like this:
set AMBARIDBNAME=ambari
set AMBARIDBLOGNAME=ambari_log

set AMBARIDBPATH=C:\Program Files\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQL\DATA\ambari.mdf
set AMBARIDBLOGPATH=C:\Program Files\Microsoft SQL Server\MSSQL12.SQLEXPRESS\MSSQL\DATA\ambari_log.ldf

set AMBARIDBOWNER=hadoop

sqlcmd -S localhost\SQLEXPRESS -i C:\app\ambari-server-1.3.0-SNAPSHOT\resources\Ambari-DDL-SQLServer-CREATELOCAL.sql
*/

USE [master]
GO

IF db_id('$(AMBARIDBNAME)') IS NOT NULL
BEGIN
    Print N'Dropping [dbo].[$(AMBARIDBNAME)] database...'
    ALTER DATABASE [$(AMBARIDBNAME)] SET  SINGLE_USER WITH ROLLBACK IMMEDIATE
    DROP DATABASE [$(AMBARIDBNAME)]
END
GO

Print N'Creating [dbo].[$(AMBARIDBNAME)] database at $(AMBARIDBPATH)...'

/****** Object:  Database [$(AMBARIDBNAME)]    Script Date: 6/11/2014 9:21:53 PM ******/

CREATE DATABASE [$(AMBARIDBNAME)]
 CONTAINMENT = NONE
 ON  PRIMARY
( NAME = N'$(AMBARIDBNAME)', FILENAME = N'$(AMBARIDBPATH)' , SIZE = 3072KB , FILEGROWTH = 1024KB )
 LOG ON
( NAME = N'$(AMBARIDBLOGNAME)', FILENAME = N'$(AMBARIDBLOGPATH)' , SIZE = 1024KB , FILEGROWTH = 10%)
GO

ALTER DATABASE [$(AMBARIDBNAME)] SET COMPATIBILITY_LEVEL = 120
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET ANSI_NULL_DEFAULT OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET ANSI_NULLS OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET ANSI_PADDING OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET ANSI_WARNINGS OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET ARITHABORT OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET AUTO_CLOSE OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET AUTO_SHRINK OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET AUTO_CREATE_STATISTICS ON
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET AUTO_UPDATE_STATISTICS ON
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET CURSOR_CLOSE_ON_COMMIT OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET CURSOR_DEFAULT  GLOBAL
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET CONCAT_NULL_YIELDS_NULL OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET NUMERIC_ROUNDABORT OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET QUOTED_IDENTIFIER OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET RECURSIVE_TRIGGERS OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET  DISABLE_BROKER
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET AUTO_UPDATE_STATISTICS_ASYNC OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET DATE_CORRELATION_OPTIMIZATION OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET PARAMETERIZATION SIMPLE
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET READ_COMMITTED_SNAPSHOT OFF
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET  READ_WRITE
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET RECOVERY SIMPLE
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET  MULTI_USER
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET PAGE_VERIFY CHECKSUM
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET TARGET_RECOVERY_TIME = 0 SECONDS
GO
ALTER DATABASE [$(AMBARIDBNAME)] SET DELAYED_DURABILITY = DISABLED
GO

USE [$(AMBARIDBNAME)]
GO

IF NOT EXISTS (SELECT name FROM sys.filegroups WHERE is_default=1 AND name = N'PRIMARY') ALTER DATABASE [$(AMBARIDBNAME)] MODIFY FILEGROUP [PRIMARY] DEFAULT
GO

ALTER authorization on DATABASE::$(AMBARIDBNAME) to [NT AUTHORITY\SYSTEM]
GO

--set AMBARIDBOWNER=hadoop
if exists (select 1 from master.sys.syslogins where name='$(AMBARIDBOWNER)')
BEGIN
    CREATE USER [$(AMBARIDBOWNER)] FOR LOGIN [$(AMBARIDBOWNER)]
    ALTER ROLE [db_owner] ADD MEMBER [$(AMBARIDBOWNER)]
END
GO

Print N'[dbo].[$(AMBARIDBNAME)] database created.'
