/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.PrivilegedExceptionAction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.http.HttpServer;
import org.apache.hadoop.mapred.ACLsManager;
import org.apache.hadoop.mapred.JobACLsManager;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobHistory;
import org.apache.hadoop.mapred.QueueManager;
import org.apache.hadoop.mapred.RawHistoryFileServlet;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.util.StringUtils;
import org.mortbay.jetty.webapp.WebAppContext;

public class JobHistoryServer {
    private static final Log LOG = LogFactory.getLog(JobHistoryServer.class);
    private static final String JH_USER_NAME = "mapreduce.jobhistory.kerberos.principal";
    private static final String JH_KEYTAB_FILE = "mapreduce.jobhistory.keytab.file";
    public static final String MAPRED_HISTORY_SERVER_HTTP_ADDRESS = "mapreduce.history.server.http.address";
    public static final String MAPRED_HISTORY_SERVER_EMBEDDED = "mapreduce.history.server.embedded";
    private HttpServer historyServer;
    private JobConf conf;
    private String historyInfoAddr;
    private WebAppContext context;

    public JobHistoryServer(JobConf conf) throws IOException {
        if (JobHistoryServer.isEmbedded(conf)) {
            throw new IllegalStateException("History server is configured to run within JobTracker. Aborting..");
        }
        this.historyInfoAddr = JobHistoryServer.getBindAddress(conf);
        this.login(conf);
        ACLsManager aclsManager = this.initializeACLsManager(conf);
        this.historyServer = this.initializeWebContainer(conf, aclsManager);
        this.initializeWebServer(conf, aclsManager);
    }

    public JobHistoryServer(JobConf conf, ACLsManager aclsManager, HttpServer httpServer) throws IOException {
        this.historyInfoAddr = JobHistoryServer.getBindAddress(conf);
        this.historyServer = httpServer;
        this.initializeWebServer(conf, aclsManager);
    }

    private void login(JobConf conf) throws IOException {
        UserGroupInformation.setConfiguration(conf);
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(this.historyInfoAddr);
        SecurityUtil.login(conf, JH_KEYTAB_FILE, JH_USER_NAME, infoSocAddr.getHostName());
        LOG.info("History server login successful");
    }

    private ACLsManager initializeACLsManager(JobConf conf) throws IOException {
        LOG.info("Initializing ACLs Manager");
        Configuration queuesConf = new Configuration(conf);
        QueueManager queueManager = new QueueManager(queuesConf);
        return new ACLsManager(conf, new JobACLsManager(conf), queueManager);
    }

    private void initializeWebServer(final JobConf conf, ACLsManager aclsManager) throws IOException {
        FileSystem fs;
        this.conf = conf;
        try {
            fs = aclsManager.getMROwner().doAs(new PrivilegedExceptionAction<FileSystem>(){

                @Override
                public FileSystem run() throws IOException {
                    return FileSystem.get(conf);
                }
            });
        }
        catch (InterruptedException e) {
            throw new IOException("Operation interrupted", e);
        }
        if (!JobHistoryServer.isEmbedded(conf)) {
            JobHistory.initDone(conf, fs, false);
        }
        String historyLogDir = JobHistory.getCompletedJobHistoryLocation().toString();
        FileSystem historyFS = new Path(historyLogDir).getFileSystem(conf);
        this.historyServer.setAttribute("historyLogDir", historyLogDir);
        this.historyServer.setAttribute("fileSys", historyFS);
        this.historyServer.setAttribute("jobConf", conf);
        this.historyServer.setAttribute("aclManager", aclsManager);
        this.historyServer.addServlet("historyfile", "/historyfile", RawHistoryFileServlet.class);
    }

    private HttpServer initializeWebContainer(JobConf conf, ACLsManager aclsManager) throws IOException {
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(this.historyInfoAddr);
        int tmpInfoPort = infoSocAddr.getPort();
        return new HttpServer("history", infoSocAddr.getHostName(), tmpInfoPort, tmpInfoPort == 0, (Configuration)conf, aclsManager.getAdminsAcl());
    }

    public void start() throws IOException {
        if (!JobHistoryServer.isEmbedded(this.conf)) {
            this.historyServer.start();
        }
        InetSocketAddress infoSocAddr = NetUtils.createSocketAddr(this.historyInfoAddr);
        this.conf.set(MAPRED_HISTORY_SERVER_HTTP_ADDRESS, infoSocAddr.getHostName() + ":" + this.historyServer.getPort());
        LOG.info("Started job history server at: " + JobHistoryServer.getAddress(this.conf));
    }

    public void join() throws InterruptedException {
        this.historyServer.join();
    }

    public void shutdown() throws Exception {
        if (this.historyServer != null && !JobHistoryServer.isEmbedded(this.conf)) {
            LOG.info("Shutting down history server");
            this.historyServer.stop();
        }
    }

    public static void main(String[] args) {
        StringUtils.startupShutdownMessage(JobHistoryServer.class, args, LOG);
        try {
            JobHistoryServer server = new JobHistoryServer(new JobConf());
            server.start();
            server.join();
        }
        catch (Throwable e) {
            LOG.fatal(StringUtils.stringifyException(e));
            System.exit(-1);
        }
    }

    static boolean isEmbedded(JobConf conf) {
        return conf.getBoolean(MAPRED_HISTORY_SERVER_EMBEDDED, true);
    }

    static String getAddress(JobConf conf) {
        return conf.get(MAPRED_HISTORY_SERVER_HTTP_ADDRESS);
    }

    static String getHistoryUrlPrefix(JobConf conf) {
        return JobHistoryServer.isEmbedded(conf) ? "" : "http://" + JobHistoryServer.getAddress(conf);
    }

    private static String getBindAddress(JobConf conf) {
        return conf.get(MAPRED_HISTORY_SERVER_HTTP_ADDRESS, "localhost:0");
    }

    static {
        Configuration.addDefaultResource("mapred-default.xml");
        Configuration.addDefaultResource("mapred-site.xml");
    }
}

