/*!
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
import { createIcon } from "@chakra-ui/react";

export const DagIcon = createIcon({
  defaultProps: {
    height: "1em",
    width: "1em",
  },
  displayName: "Dag Icon",
  path: (
    <g>
      <path
        d="M20.6667 7.33331C20.6667 9.54245 22.4575 11.3333 24.6667 11.3333C26.8758 11.3333 28.6667 9.54245 28.6667 7.33331C28.6667 5.12417 26.8758 3.33331 24.6667 3.33331C22.4575 3.33331 20.6667 5.12417 20.6667 7.33331Z"
        fill="none"
        stroke="currentColor"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth="2"
      />
      <path
        clipRule="evenodd"
        d="M7.66667 8C7.66667 7.44772 8.11439 7 8.66667 7C9.21896 7 9.66667 7.44772 9.66667 8L9.66667 20.6667C9.66667 21.2121 9.81375 21.6891 10.0194 21.9976C10.2247 22.3055 10.399 22.3333 10.4444 22.3333L15.7667 22.3333C16.23 20.0511 18.2477 18.3333 20.6667 18.3333C23.4281 18.3333 25.6667 20.5719 25.6667 23.3333C25.6667 26.0948 23.4281 28.3333 20.6667 28.3333C18.2477 28.3333 16.23 26.6156 15.7667 24.3333L10.4444 24.3333C9.54693 24.3333 8.81681 23.7992 8.35532 23.107C7.89419 22.4153 7.66667 21.5357 7.66667 20.6667L7.66667 8ZM17.6667 23.3333C17.6667 21.6765 19.0098 20.3333 20.6667 20.3333C22.3235 20.3333 23.6667 21.6765 23.6667 23.3333C23.6667 24.9902 22.3235 26.3333 20.6667 26.3333C19.0098 26.3333 17.6667 24.9902 17.6667 23.3333Z"
        fill="currentColor"
        fillRule="evenodd"
      />
      <path
        d="M20.6667 7.33331L4.66667 7.33331"
        stroke="currentColor"
        strokeLinecap="round"
        strokeLinejoin="round"
        strokeWidth="2"
      />
    </g>
  ),
  viewBox: "0 0 30 30",
});
