/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.connect.federation;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.activemq.artemis.api.core.ICoreMessage;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.server.AddressQueryResult;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationAddressPolicyManager;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConstants;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumer;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationConsumerConfiguration;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationMetrics;
import org.apache.activemq.artemis.protocol.amqp.connect.federation.AMQPFederationPolicySupport;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPNotFoundException;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationConsumerInfo;
import org.apache.activemq.artemis.protocol.amqp.federation.FederationReceiveFromAddressPolicy;
import org.apache.activemq.artemis.protocol.amqp.logger.ActiveMQAMQPProtocolMessageBundle;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpJmsSelectorFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpNoLocalFilter;
import org.apache.activemq.artemis.protocol.amqp.proton.AmqpSupport;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonServerReceiverContext;
import org.apache.qpid.proton.amqp.Symbol;
import org.apache.qpid.proton.amqp.messaging.DeliveryAnnotations;
import org.apache.qpid.proton.amqp.messaging.Outcome;
import org.apache.qpid.proton.amqp.messaging.Source;
import org.apache.qpid.proton.amqp.messaging.Target;
import org.apache.qpid.proton.amqp.messaging.TerminusDurability;
import org.apache.qpid.proton.amqp.messaging.TerminusExpiryPolicy;
import org.apache.qpid.proton.amqp.transport.ReceiverSettleMode;
import org.apache.qpid.proton.amqp.transport.SenderSettleMode;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Link;
import org.apache.qpid.proton.engine.Receiver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMQPFederationAddressConsumer
extends AMQPFederationConsumer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final SimpleString MESSAGE_HOPS_ANNOTATION = SimpleString.of((String)AMQPFederationPolicySupport.MESSAGE_HOPS_ANNOTATION.toString());
    private final FederationReceiveFromAddressPolicy policy;

    public AMQPFederationAddressConsumer(AMQPFederationAddressPolicyManager manager, AMQPFederationConsumerConfiguration configuration, AMQPSessionContext session, FederationConsumerInfo consumerInfo, AMQPFederationMetrics.ConsumerMetrics metrics) {
        super(manager, configuration, session, consumerInfo, manager.getPolicy(), metrics);
        this.policy = manager.getPolicy();
    }

    private String generateLinkName() {
        if (this.federation.getCapabilities().isUseFQQNAddressSubscriptions()) {
            return "federation-" + this.federation.getName() + "-policy-" + this.policy.getPolicyName() + "-address-receiver-" + this.consumerInfo.getAddress() + "-" + String.valueOf(this.federation.getServer().getNodeID()) + "-" + LINK_SEQUENCE_ID.incrementAndGet();
        }
        return "federation-" + this.federation.getName() + "-address-receiver-" + this.consumerInfo.getAddress() + "-" + String.valueOf(this.federation.getServer().getNodeID());
    }

    @Override
    public final int getReceiverIdleTimeout() {
        return this.configuration.getAddressReceiverIdleTimeout();
    }

    @Override
    protected final void doCreateReceiver() {
        try {
            Receiver protonReceiver = this.session.getSession().receiver(this.generateLinkName());
            Target target = new Target();
            Source source = new Source();
            if (RoutingType.ANYCAST.equals((Object)this.consumerInfo.getRoutingType())) {
                source.setCapabilities(new Symbol[]{AmqpSupport.QUEUE_CAPABILITY});
            } else {
                source.setCapabilities(new Symbol[]{AmqpSupport.TOPIC_CAPABILITY});
            }
            HashMap<Symbol, Object> filtersMap = new HashMap<Symbol, Object>();
            filtersMap.put(AmqpSupport.NO_LOCAL_NAME, AmqpNoLocalFilter.NO_LOCAL);
            if (this.consumerInfo.getFilterString() != null && !this.consumerInfo.getFilterString().isEmpty()) {
                AmqpJmsSelectorFilter jmsFilter = new AmqpJmsSelectorFilter(this.consumerInfo.getFilterString());
                filtersMap.put(AmqpSupport.JMS_SELECTOR_KEY, jmsFilter);
            }
            source.setOutcomes(Arrays.copyOf(OUTCOMES, OUTCOMES.length));
            source.setDefaultOutcome((Outcome)DEFAULT_OUTCOME);
            source.setDurable(TerminusDurability.NONE);
            source.setExpiryPolicy(TerminusExpiryPolicy.LINK_DETACH);
            source.setFilter(filtersMap);
            if (this.federation.getCapabilities().isUseFQQNAddressSubscriptions()) {
                source.setAddress(this.consumerInfo.getFqqn());
            } else {
                source.setAddress(this.consumerInfo.getAddress());
            }
            target.setAddress(this.consumerInfo.getAddress());
            HashMap<String, Comparable<Boolean>> addressSourceProperties = new HashMap<String, Comparable<Boolean>>();
            addressSourceProperties.put("auto-delete", Boolean.valueOf(this.policy.isAutoDelete()));
            addressSourceProperties.put("auto-delete-delay", Long.valueOf(this.policy.getAutoDeleteDelay()));
            addressSourceProperties.put("auto-delete-msg-count", Long.valueOf(this.policy.getAutoDeleteMessageCount()));
            HashMap<Symbol, Object> receiverProperties = new HashMap<Symbol, Object>();
            receiverProperties.put(AMQPFederationPolicySupport.FEDERATED_ADDRESS_SOURCE_PROPERTIES, addressSourceProperties);
            receiverProperties.put(AMQPFederationConstants.FEDERATION_POLICY_NAME, this.policy.getPolicyName());
            protonReceiver.setSenderSettleMode(SenderSettleMode.UNSETTLED);
            protonReceiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            protonReceiver.setDesiredCapabilities(new Symbol[]{AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER});
            if (this.configuration.isCoreMessageTunnelingEnabled()) {
                protonReceiver.setOfferedCapabilities(new Symbol[]{AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT});
            }
            protonReceiver.setProperties(receiverProperties);
            protonReceiver.setTarget((org.apache.qpid.proton.amqp.transport.Target)target);
            protonReceiver.setSource((org.apache.qpid.proton.amqp.transport.Source)source);
            protonReceiver.open();
            AtomicBoolean openTimedOut = new AtomicBoolean(false);
            ScheduledFuture<?> openTimeoutTask = this.configuration.getLinkAttachTimeout() > 0 ? this.federation.getServer().getScheduledPool().schedule(() -> {
                openTimedOut.set(true);
                this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.brokerConnectionTimeout()));
            }, (long)this.configuration.getLinkAttachTimeout(), TimeUnit.SECONDS) : null;
            this.protonReceiver = protonReceiver;
            protonReceiver.attachments().set(AmqpSupport.AMQP_LINK_INITIALIZER_KEY, Runnable.class, () -> {
                try {
                    boolean linkOpened;
                    if (openTimeoutTask != null) {
                        openTimeoutTask.cancel(false);
                    }
                    if (openTimedOut.get()) {
                        return;
                    }
                    if (protonReceiver.getRemoteSource() != null && !AmqpSupport.verifyOfferedCapabilities((Link)protonReceiver, AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER)) {
                        this.federation.signalResourceCreateError((Exception)((Object)ActiveMQAMQPProtocolMessageBundle.BUNDLE.missingOfferedCapability(AMQPFederationConstants.FEDERATION_ADDRESS_RECEIVER.toString())));
                        return;
                    }
                    this.federation.addLinkClosedInterceptor(this.consumerInfo.getId(), this.remoteCloseInterceptor);
                    this.receiver = this.createDeliveryHandler(protonReceiver);
                    boolean bl = linkOpened = protonReceiver.getRemoteSource() != null;
                    if (linkOpened) {
                        logger.debug("AMQP Federation {} address consumer {} completed open", (Object)this.federation.getName(), (Object)this.consumerInfo);
                    } else {
                        logger.debug("AMQP Federation {} address consumer {} rejected by remote", (Object)this.federation.getName(), (Object)this.consumerInfo);
                    }
                    this.session.addReceiver(protonReceiver, (session, protonRcvr) -> this.receiver);
                    if (linkOpened && this.remoteOpenHandler != null) {
                        this.remoteOpenHandler.accept(this);
                    }
                }
                catch (Exception e) {
                    this.federation.signalError(e);
                }
            });
        }
        catch (Exception e) {
            this.federation.signalError(e);
        }
        this.connection.flush();
    }

    protected abstract AMQPFederatedAddressDeliveryHandler createDeliveryHandler(Receiver var1);

    private static AMQPMessage incrementAMQPMessageHops(AMQPMessage message) {
        Object hops = message.getAnnotation(MESSAGE_HOPS_ANNOTATION);
        if (hops == null) {
            message.setAnnotation(MESSAGE_HOPS_ANNOTATION, 1);
        } else {
            Number numHops = (Number)hops;
            message.setAnnotation(MESSAGE_HOPS_ANNOTATION, numHops.intValue() + 1);
        }
        message.reencode();
        return message;
    }

    private static ICoreMessage incrementCoreMessageHops(ICoreMessage message) {
        Object hops = message.getObjectProperty("_AMQ_Fed_Hops");
        if (hops == null) {
            message.putObjectProperty("_AMQ_Fed_Hops", (Object)1);
        } else {
            Number numHops = (Number)hops;
            message.putObjectProperty("_AMQ_Fed_Hops", (Object)(numHops.intValue() + 1));
        }
        return message;
    }

    protected abstract class AMQPFederatedAddressDeliveryHandler
    extends ProtonServerReceiverContext {
        protected final SimpleString cachedAddress;
        protected boolean closed;

        AMQPFederatedAddressDeliveryHandler(AMQPSessionContext session, FederationConsumerInfo consumerInfo, Receiver receiver) {
            super(session.getSessionSPI(), session.getAMQPConnectionContext(), session, receiver);
            this.cachedAddress = SimpleString.of((String)consumerInfo.getAddress());
        }

        @Override
        public final void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
            if (!this.closed) {
                super.close(remoteLinkClose);
                this.closed = true;
                try {
                    AMQPFederationAddressConsumer.this.federation.unregisterFederationConsumerManagement(AMQPFederationAddressConsumer.this);
                }
                catch (Exception e) {
                    logger.trace("Error thrown when unregistering federation address consumer from management", (Throwable)e);
                }
                if (remoteLinkClose && AMQPFederationAddressConsumer.this.remoteCloseHandler != null) {
                    try {
                        AMQPFederationAddressConsumer.this.remoteCloseHandler.accept(AMQPFederationAddressConsumer.this);
                    }
                    catch (Exception e) {
                        logger.debug("User remote closed handler threw error: ", (Throwable)e);
                    }
                    finally {
                        AMQPFederationAddressConsumer.this.remoteCloseHandler = null;
                    }
                }
            }
        }

        @Override
        protected boolean isUseModifiedForTransientDeliveryErrors(AMQPConnectionContext connection) {
            return AMQPFederationAddressConsumer.this.configuration.isUseModifiedForTransientDeliveryErrors();
        }

        @Override
        protected boolean isDrainOnTransientDeliveryErrors(AMQPConnectionContext connection) {
            return AMQPFederationAddressConsumer.this.configuration.isDrainOnTransientDeliveryErrors();
        }

        @Override
        protected int getLinkQuiesceTimeout(AMQPConnectionContext connection) {
            return AMQPFederationAddressConsumer.this.configuration.getLinkQuiesceTimeout();
        }

        @Override
        protected final Runnable createCreditRunnable(AMQPConnectionContext connection) {
            return AMQPFederatedAddressDeliveryHandler.createCreditRunnable(AMQPFederationAddressConsumer.this.configuration.getReceiverCredits(), AMQPFederationAddressConsumer.this.configuration.getReceiverCreditsLow(), this.receiver, connection, this);
        }

        @Override
        protected final int getConfiguredMinLargeMessageSize(AMQPConnectionContext connection) {
            return AMQPFederationAddressConsumer.this.configuration.getLargeMessageThreshold();
        }

        @Override
        public final void initialize() throws Exception {
            this.initialized = true;
            Target target = (Target)this.receiver.getRemoteTarget();
            this.receiver.setSenderSettleMode(this.receiver.getRemoteSenderSettleMode());
            this.receiver.setReceiverSettleMode(ReceiverSettleMode.FIRST);
            if (target == null || target.getAddress() == null || target.getAddress().isEmpty()) {
                throw new ActiveMQAMQPInternalErrorException("Remote should have sent an valid Target but we got: " + String.valueOf(target));
            }
            this.address = SimpleString.of((String)target.getAddress());
            this.explicitRoutingType = this.getExplicitRoutingType(target.getCapabilities(), this.address);
            this.implicitRoutingType = this.getImplicitRoutingType(this.address);
            RoutingType selectedRoutingType = this.explicitRoutingType != null ? this.explicitRoutingType : this.implicitRoutingType;
            try {
                AddressQueryResult result = this.sessionSPI.addressQuery(this.address, selectedRoutingType, false);
                if (!result.isExists()) {
                    throw ActiveMQAMQPProtocolMessageBundle.BUNDLE.addressDoesntExist(this.address.toString());
                }
            }
            catch (ActiveMQAMQPNotFoundException e) {
                throw e;
            }
            catch (Exception e) {
                logger.debug(e.getMessage(), (Throwable)e);
                throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
            }
            if (AMQPFederationAddressConsumer.this.configuration.isCoreMessageTunnelingEnabled() && AmqpSupport.verifyDesiredCapability((Link)this.receiver, AmqpSupport.CORE_MESSAGE_TUNNELING_SUPPORT)) {
                this.enableCoreTunneling();
            }
            try {
                AMQPFederationAddressConsumer.this.federation.registerFederationConsumerManagement(AMQPFederationAddressConsumer.this);
            }
            catch (Exception e) {
                logger.debug("Error caught when trying to add federation address consumer to management", (Throwable)e);
            }
            this.topUpCreditIfNeeded();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected final void actualDelivery(Message message, Delivery delivery, DeliveryAnnotations deliveryAnnotations, Receiver receiver, Transaction tx) {
            try {
                AMQPMessage baseMessage;
                if (logger.isTraceEnabled()) {
                    logger.trace("AMQP Federation {} address consumer {} dispatching incoming message: {}", new Object[]{AMQPFederationAddressConsumer.this.federation.getName(), AMQPFederationAddressConsumer.this.consumerInfo, message});
                }
                if (message instanceof ICoreMessage) {
                    ICoreMessage coreMessage = (ICoreMessage)message;
                    baseMessage = AMQPFederationAddressConsumer.incrementCoreMessageHops(coreMessage);
                    baseMessage.putStringProperty("__AMQ_CID", this.getConnection().getRemoteContainer());
                } else {
                    baseMessage = AMQPFederationAddressConsumer.incrementAMQPMessageHops((AMQPMessage)message);
                }
                Message theMessage = AMQPFederationAddressConsumer.this.transformer.transform((Message)baseMessage);
                if (theMessage != baseMessage && logger.isTraceEnabled()) {
                    logger.trace("The transformer {} replaced the original message {} with a new instance {}", new Object[]{AMQPFederationAddressConsumer.this.transformer, baseMessage, theMessage});
                }
                AMQPFederationAddressConsumer.this.signalPluginBeforeFederationConsumerMessageHandled(theMessage);
                this.routeFederatedMessage(theMessage, delivery, receiver, tx);
                AMQPFederationAddressConsumer.this.signalPluginAfterFederationConsumerMessageHandled(theMessage);
            }
            catch (Exception e) {
                logger.warn("Inbound delivery for {} encountered an error: {}", new Object[]{AMQPFederationAddressConsumer.this.consumerInfo, e.getMessage(), e});
                this.deliveryFailed(delivery, receiver, e);
            }
            finally {
                AMQPFederationAddressConsumer.this.recordFederatedMessageReceived(message);
            }
        }

        protected abstract void routeFederatedMessage(Message var1, Delivery var2, Receiver var3, Transaction var4) throws Exception;
    }
}

