/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.codec.protobuf;

import java.util.Arrays;
import java.util.List;
import org.springframework.lang.Nullable;
import org.springframework.util.MimeType;

public abstract class ProtobufCodecSupport {
    static final MimeType[] MIME_TYPES = new MimeType[]{new MimeType("application", "x-protobuf"), new MimeType("application", "octet-stream"), new MimeType("application", "vnd.google.protobuf")};
    static final String DELIMITED_KEY = "delimited";
    static final String DELIMITED_VALUE = "true";

    protected boolean supportsMimeType(@Nullable MimeType mimeType) {
        if (mimeType == null) {
            return true;
        }
        for (MimeType m : MIME_TYPES) {
            if (!m.isCompatibleWith(mimeType)) continue;
            return true;
        }
        return false;
    }

    protected List<MimeType> getMimeTypes() {
        return Arrays.asList(MIME_TYPES);
    }
}

