

#ifdef __AROS__
#include <clib/boopsistubs.h>
#endif

#include <exec/types.h>
extern "C"
{     
#include <libraries/mui.h>
}     
#include <libraries/asl.h>
     
#include <proto/exec.h>
     
#include <proto/intuition.h>
extern "C"
{     
#include <proto/muimaster.h>
}
#include <proto/asl.h>

#include <mui/TextEditor_mcc.h>

/***************************************************************************/
/* This is neccessary, because the Zune get macro conflicts with the       */  
/* C++ istream get method. When you need the Zune get, use zuneget instead */
/***************************************************************************/
#undef get

#define zuneget(obj, attr, storage)                                     \
({                                                                      \
    IPTR  __zune_get_storage;                                           \
    ULONG __zune_get_ret = GetAttr((attr), (obj), &__zune_get_storage); \
    *storage = (typeof(*storage))__zune_get_storage;                    \
    __zune_get_ret;                                                     \
})
/***************************************************************************/
#undef set

#define zuneset(obj,attr,value) SetAttrs(obj,attr,(IPTR)(value),TAG_DONE)

#define XGET(object, attribute)                 \
({                                              \
    IPTR __storage = 0;                         \
    GetAttr((attribute), (object), &__storage); \
    __storage;                                  \
})

#include "txt.h"



//Defines for Button Messages
#define IDB_OPEN     10010
#define IDB_SAVE     10020
#define IDB_COPY     10030
#define IDB_CUT      10040
#define IDB_PASTE    10050
#define IDB_ERASE    10060
#define IDB_CLEAR    10070
#define IDB_UNDO     10080
#define IDB_REDO     10090
#define IDB_ABOUT    10100


int main(void)
{
 

   
    
   
    txt TXT;
    
    //Everything is an object 
    Object *wnd, *requester, *app, *slider, *editorgadget, *open, *save, *copy, *cut, *paste, *undo, *redo, *erase, *clear, *about;
    
    //for the File Requester that is opened later
    struct FileRequester *req;



    
    
    //GUI creation
      app = ApplicationObject, SubWindow, 
           wnd = WindowObject, MUIA_Window_Title, "Simple Text Editor",
                               MUIA_Window_AppWindow, TRUE, 
                               WindowContents, 
               
               // Be careful here ! Some Child needs an End, TAG and some not.
               VGroup, 
                       Child, VGroup, 
                              Child, HGroup, MUIA_Weight,10,
                                    Child, open = SimpleButton("open file"), 
                                    Child, save = SimpleButton("save file"), 
                                    Child, copy = SimpleButton("copy"), 
                                    Child, cut = SimpleButton("cut"), 
                                    Child, paste = SimpleButton("paste"),
                                                                                                          
                              End,
                              Child, HGroup, MUIA_Weight,10,
                                    Child, erase = SimpleButton("erase"), 
                                    Child, clear = SimpleButton("clear"),                                    
                                    Child, undo = SimpleButton("undo"), 
                                    Child, redo = SimpleButton("redo"), 
                                    Child, about = SimpleButton("about"), 
                                                                                                                                             
                              End,
                              
                              
                              
                              Child, HGroup, MUIA_Weight,80, 
                                     Child, editorgadget = TextEditorObject,
                                     MUIA_TextEditor_Slider, slider,
                                     MUIA_CycleChain, TRUE, 
                                     MUIA_TextEditor_RedoAvailable,TRUE, 
                                     MUIA_TextEditor_UndoAvailable, TRUE,
                                     End,
                                     Child, slider = ScrollbarObject,
                                     End,
                              End,
                       End,           
                End,       
           End,
      End;     
      
// Message handling      
      
if (app != NULL)
    {
        ULONG sigs = 0;
        ULONG id;
        BOOL running = TRUE;
        
                
        // Click Close gadget or hit Escape to quit
        DoMethod(wnd, MUIM_Notify, MUIA_Window_CloseRequest, TRUE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)MUIV_Application_ReturnID_Quit);
     
        // Click the button to open a file
        DoMethod(open, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_OPEN);
                 
        // Click the button to save a file
        DoMethod(save, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_SAVE);
                 
        // Click the button to copy
        DoMethod(copy, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_COPY);
                 
        // Click the button to cut
        DoMethod(cut, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_CUT);
                 
        // Click the button to paste
        DoMethod(paste, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_PASTE);
                 
         
        // Click the button to erase
        DoMethod(erase, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_ERASE); 
                 
        // Click the button to erase
        DoMethod(clear, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_CLEAR);          
                 
        // Click the button to undo last action
        DoMethod(undo, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_UNDO);
                 
        // Click the button to redo last action
        DoMethod(redo, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_REDO);
                 
        // Click the button to open about window
        DoMethod(about, MUIM_Notify, MUIA_Pressed, FALSE,
                 (IPTR)app, 2,
                 MUIM_Application_ReturnID, 
                 (ULONG)IDB_ABOUT);          
        
    
        // Open the window
        zuneset(wnd, MUIA_Window_Open, TRUE);
     
        // Check that the window opened
        if (XGET(wnd, MUIA_Window_Open))
        {
              //Main Loop
              //Event Handling 
              
            while (running) 
            {
             id = DoMethod(app, MUIM_Application_NewInput, (ULONG)&sigs);
             
                switch(id) 
                {
                           case MUIV_Application_ReturnID_Quit:
                           running = FALSE;
                           break;
                           
                           case IDB_OPEN:
                           
                           //getting the filename and path
                           
                            if ((req=(FileRequester*)MUI_AllocAslRequestTags(ASL_FileRequest,
                                ASLFR_Window,*requester ,
                                ASLFR_TitleText, "Open file",
                                ASLFR_InitialDrawer , TXT.sdrawer.c_str(),
                                ASLFR_InitialFile, TXT.sfilename.c_str(),
                                ASLFR_InitialPattern , "#?.txt",
                                ASLFR_DoPatterns , TRUE,
                                ASLFR_RejectIcons , TRUE,
                                TAG_DONE))) 
                                {
                                
                                    if (MUI_AslRequestTags(req,TAG_DONE)) 
                                    {
                                    /* you can find the drawer in req->fr_Drawer
                                    and the file in req->fr_File
                                    */
                                    TXT.LoadFile( req->fr_Drawer, req->fr_File );
                                                                        
                                    }
                                    
                                    //loading the file
                                    
                                    
                                    zuneset(editorgadget, MUIA_TextEditor_Contents, TXT.stext.c_str());
                                    
                                    
                                }                               
                           break;
                           
                           case IDB_SAVE:
                           //loading the content from our Text Editor
                           TXT.Get_Text( (STRPTR)DoMethod(editorgadget, MUIM_TextEditor_ExportText) );
                                    
                           if ((req=(FileRequester*)MUI_AllocAslRequestTags(ASL_FileRequest,
                                ASLFR_Window,*requester ,
                                ASLFR_TitleText, "Save file",
                                ASLFR_InitialDrawer , TXT.sdrawer.c_str(),
                                ASLFR_InitialFile, TXT.sfilename.c_str(),
                                ASLFR_InitialPattern , "#?.txt",
                                ASLFR_DoPatterns , TRUE,
                                ASLFR_RejectIcons , TRUE,
                                TAG_DONE))) 
                                {
                                
                                    if (MUI_AslRequestTags(req,TAG_DONE)) 
                                    {
                                    /* you can find the drawer in req->fr_Drawer
                                    and the file in req->fr_File
                                    */
                                    //saving the file
                                    TXT.SaveFile( req->fr_Drawer, req->fr_File );
                                    
                                    }
                                }                               
                                                                                                  
                                    
                           break;
                           
                           case IDB_COPY:
                           DoMethod(cut,   MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Cut");
						
                           //MUI_Request(app, wnd, 0L, "broad hint", "_OK", "Function not implemented.", NULL);
                           break;
                           
                           case IDB_CUT:
                           DoMethod(cut, MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Cut");
						
                           //MUI_Request(app, wnd, 0L, "broad hint", "_OK", "Function not implemented.", NULL);
                           break;
                           
                           case IDB_PASTE:
                           DoMethod(paste, MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Paste");
						
                           //MUI_Request(app, wnd, 0L, "broad hint", "_OK", "Function not implemented.", NULL);
                           break;
                           
                           case IDB_ERASE:
                           DoMethod(erase, MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Erase");
						                      
                           break;
                           
                           case IDB_CLEAR:
                           DoMethod(clear, MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Clear");
						                   
                           break;
                           
                           case IDB_UNDO:
                           DoMethod(undo,  MUIM_Notify, MUIA_Pressed, FALSE, (ULONG)editorgadget, 2, MUIM_TextEditor_ARexxCmd, (ULONG)"Undo");
						                
                           break;
                           
                           case IDB_ABOUT:
                           MUI_Request(app, wnd, 0L, "About this Program...", "_OK", "Simple Text Editor.\nHeinz-Raphael Reinke 04/2006", NULL);
                                       
                           break;
                }
                
                if (sigs && running) 
                {
                   sigs = Wait(sigs | SIGBREAKF_CTRL_C);
                   if (sigs & SIGBREAKF_CTRL_C) running = FALSE;
                }
                
           }
            
            
        }
             // Destroy our application and all its objects
        MUI_DisposeObject(app);
        
    }      
      
      
return 0;
}      
