(*---------------------------------------------------------------------------
    :Program.    IconSupport.mod
    :Author.     Fridtjof Siebert
    :Address.    Nobileweg 67, D-7-Stgt-40
    :Phone.      0711/822509
    :Shortcut.   [fbs]
    :Version.    1.0
    :History.    10.Mar.90 neucompiliert m2V3.3d Dimbeck
    :Date.       31-Jul-88
    :Copyright.  PD
    :Language.   Modula-II
    :Translator. M2Amiga
    :Imports.    none.
    :UpDate.     10.Mar.1990 neucompiliert mit m2V3.3d
    :Contents.   Exportiert PROCEDURE zum Erzeugen von Icons.
    :Remark.     Come On Let's Twists Again !
---------------------------------------------------------------------------*)

IMPLEMENTATION MODULE IconSupport;

FROM SYSTEM    IMPORT ADR, ADDRESS, LONGSET;

FROM Icon      IMPORT PutDiskObject;
FROM Intuition IMPORT GadgetFlags, GadgetFlagSet, ActivationFlags,
                      ActivationFlagSet, boolGadget, Image, ImagePtr;
FROM Workbench IMPORT DiskObject, diskVersion, noIconPosition,
                      WBObjectType, diskMagic, DrawerData;

VAR
  do: DiskObject;
  Drawer: DrawerData;

PROCEDURE CreateIcon(Name: ADDRESS; image,himage: ImagePtr;
                     BackFill: BOOLEAN; Type: WBObjectType;
                     DefTool: ADDRESS) : BOOLEAN;

(* This creates an Icon for a File named Name.                             *)
(* Name:     Points to the File's Name. `.info' will be added              *)
(* image:    An Intuition.ImagePtr containing the Icon's Image             *)
(* himgae:   Image for Highlighting or NIL if only one Image               *)
(* BackFill: Only used if himage is NIL. Specifies BackFill (TRUE) or      *)
(*           complement (FALSE) mode for Highliting                        *)
(* Type:     What kind of thing does this Icon stand for. This is a        *)
(*           WorkBench.WBObjectType. It can be disk, drawer, tool, project,*)
(*           garbage, device or kick.                                      *)
(* DefTool:  The projects Default Tool or NIL if none. This points to a    *)
(*           an array of char, like ":c/more" for a text to be shown.      *)
(* Result:   FALSE in case of any error. Errornumber can be shown via      *)
(*           Dos.IOErr().                                                  *)

BEGIN
  WITH do DO
    magic := diskMagic;
    version := diskVersion;
    WITH gadget DO
      nextGadget := NIL;
      leftEdge := 0;
      topEdge := 0;
      width := image^.width;
      height := image^.height;
      flags := GadgetFlagSet{gadgImage};
      IF himage#NIL THEN
        INCL(flags,gadgHImage);
      ELSIF BackFill THEN
        INCL(flags,gadgHBox);
      END;
      activation := ActivationFlagSet{relVerify,gadgImmediate};
      gadgetType := boolGadget;
      gadgetRender := image;
      selectRender := himage;
      gadgetText := NIL;
      mutualExclude := LONGSET{};
      specialInfo := NIL;
    END;
    type := Type;
    defaultTool := DefTool;
    toolTypes := NIL;
    currentX := noIconPosition;
    currentY := noIconPosition;
    CASE Type OF disk,drawer,garbage:
      drawerData := ADR(Drawer);
      WITH Drawer DO
        WITH newWindow DO
          leftEdge  := 160;
          topEdge   := 64;
          width     := 320;
          height    := 128;
          detailPen := 0;
          blockPen  := 1;
        END;
        currentX := 160;
        currentY := 64;
      END;
    ELSE
      drawerData := NIL;
    END;
    toolWindow := NIL;
    stackSize := 0;
  END;
  RETURN PutDiskObject(Name,ADR(do)) ;
END CreateIcon;

END IconSupport.
