/*
 * Decompiled with CFR 0.152.
 */
package jamal;

import jamal.AbkViewer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

public class AbkGfx {
    AbkViewer parent;
    Graphics2D g2 = null;
    Image offImg = null;
    Graphics2D[] testgraphic;
    Image[] testimage;

    int SpritePaletteEntry(int index) {
        if (!this.parent.usehalfbright || index < 32) {
            return this.parent.palette[index];
        }
        return this.parent.palette[index % 32];
    }

    int objectWidth(int obj) {
        return this.parent.xsize[obj];
    }

    int objectHeight(int obj) {
        return this.parent.ysize[obj];
    }

    int objectBitplanes(int obj) {
        return this.parent.bitplanes[obj];
    }

    int objectHotSpotX(int obj) {
        return this.parent.xhandle[obj];
    }

    int objectHotSpotY(int obj) {
        return this.parent.yhandle[obj];
    }

    Color colorPixel(int obj, int x, int y) {
        return this.parent.image32[obj][x][y];
    }

    Color colorSpritePaletteEntry(int index) {
        if (!this.parent.usehalfbright || index / 32 % 2 == 0) {
            return this.parent.colorpalette[index % 32];
        }
        return this.getHalfBrite(this.parent.colorpalette[index % 64 % 32]);
    }

    Color getHalfBrite(Color victim) {
        int red = victim.getRed() / 2;
        int green = victim.getGreen() / 2;
        int blue = victim.getBlue() / 2;
        return new Color(red, green, blue);
    }

    int numObjects() {
        return this.parent.numobjects;
    }

    AbkGfx(AbkViewer par) {
        this.parent = par;
        this.init();
    }

    void init() {
    }

    public void plotsprites(Graphics2D g, int scale, int dispwidth, int dispheight, boolean usehotspots) {
        int xinitialposition = 0;
        int yinitialposition = 0;
        if (usehotspots) {
            int obj = 0;
            while (obj < this.parent.numobjects) {
                if (xinitialposition < this.objectHotSpotX(obj)) {
                    xinitialposition = this.objectHotSpotX(obj);
                }
                if (yinitialposition < this.objectHotSpotY(obj)) {
                    yinitialposition = this.objectHotSpotY(obj);
                }
                ++obj;
            }
        }
        int xspace = 10;
        int yspace = 10;
        int width = dispwidth;
        int xposition = xinitialposition += 2;
        int yposition = yinitialposition += 2;
        int maxy = 0;
        int obj = 0;
        while (obj < this.parent.numobjects) {
            int y = 0;
            while (y < this.parent.ysize[obj]) {
                if (y > maxy) {
                    maxy = y;
                }
                int x = 0;
                while (x < this.parent.xsize[obj]) {
                    int paletteindex = this.parent.image[obj][x][y];
                    if (paletteindex > 0) {
                        int l;
                        g.setColor(this.colorPixel(obj, x, y));
                        if (usehotspots) {
                            l = 0;
                            while (l < scale) {
                                g.drawLine((x + xposition - this.objectHotSpotX(obj)) * scale, (y + yposition - this.objectHotSpotY(obj)) * scale + l, (x + xposition - this.objectHotSpotX(obj)) * scale + (scale - 1), (y + yposition - this.objectHotSpotY(obj)) * scale + l);
                                ++l;
                            }
                        } else {
                            l = 0;
                            while (l < scale) {
                                g.drawLine((x + xposition) * scale, (y + yposition) * scale + l, (x + xposition) * scale + (scale - 1), (y + yposition) * scale + l);
                                ++l;
                            }
                        }
                    }
                    ++x;
                }
                ++y;
            }
            if ((xposition += this.parent.xsize[obj] + xspace) + this.objectWidth(obj) > (width - xinitialposition) / scale) {
                xposition = xinitialposition;
                yposition += maxy + yspace;
            }
            ++obj;
        }
        if (xposition > xinitialposition) {
            yposition += maxy + yspace;
        }
    }

    public void simpleplotsprite(Graphics2D g, int spritenum, int scale) {
        int y = 0;
        while (y < this.parent.ysize[spritenum]) {
            int x = 0;
            while (x < this.parent.xsize[spritenum]) {
                int paletteindex = this.parent.image[spritenum][x][y];
                if (paletteindex > 0) {
                    g.setColor(this.colorPixel(spritenum, x, y));
                    int l = 0;
                    while (l < scale) {
                        g.drawLine(x * scale, y * scale + l, x * scale + (scale - 1), y * scale + l);
                        ++l;
                    }
                }
                ++x;
            }
            ++y;
        }
    }

    public void getimages(int scale) {
        if (this.testgraphic != null && this.testimage != null) {
            return;
        }
        this.testgraphic = new Graphics2D[this.numObjects()];
        this.testimage = new Image[this.numObjects()];
        int n = 0;
        while (n < this.numObjects()) {
            this.testgraphic[n] = this.createSpriteGraphics2D(n, scale);
            this.testimage[n] = this.offImg;
            ++n;
        }
    }

    public void drawimages(Graphics2D g, int scale, int dispwidth, int dispheight, boolean usehotspots) {
        int xinitialposition = 0;
        int yinitialposition = 0;
        if (usehotspots) {
            int obj = 0;
            while (obj < this.parent.numobjects) {
                if (xinitialposition < this.objectHotSpotX(obj)) {
                    xinitialposition = this.objectHotSpotX(obj);
                }
                if (yinitialposition < this.objectHotSpotY(obj)) {
                    yinitialposition = this.objectHotSpotY(obj);
                }
                ++obj;
            }
        }
        int xspace = 10;
        int yspace = 10;
        int width = dispwidth;
        int xposition = xinitialposition += 2;
        int yposition = yinitialposition += 2;
        int maxy = 0;
        int obj = 0;
        while (obj < this.numObjects()) {
            this.offImg = this.testimage[obj];
            if (usehotspots) {
                g.drawImage(this.offImg, (xposition - this.objectHotSpotX(obj)) * scale, (yposition - this.objectHotSpotY(obj)) * scale, null);
            } else {
                g.drawImage(this.offImg, xposition * scale, yposition * scale, null);
            }
            int y = 0;
            while (y < this.parent.ysize[obj]) {
                if (y > maxy) {
                    maxy = y;
                }
                ++y;
            }
            if ((xposition += this.parent.xsize[obj] + xspace) + this.objectWidth(obj) > (width - xinitialposition) / scale) {
                xposition = xinitialposition;
                yposition += maxy + yspace;
            }
            ++obj;
        }
        if (xposition > xinitialposition) {
            yposition += maxy + yspace;
        }
    }

    public Graphics2D createSpriteGraphics2D(int spritenum, int scale) {
        this.g2 = null;
        this.offImg = null;
        int width = this.parent.xsize[spritenum];
        int height = this.parent.ysize[spritenum];
        if (width > 0 && height > 0) {
            this.offImg = (BufferedImage)this.parent.frame.createImage(width * scale, height * scale);
        }
        if (this.offImg != null) {
            this.g2 = ((BufferedImage)this.offImg).createGraphics();
            this.g2.setBackground(Color.black);
            this.g2.setBackground(this.colorSpritePaletteEntry(0));
            this.g2.setColor(this.colorSpritePaletteEntry(0));
        }
        if (this.g2 != null) {
            this.g2.clearRect(0, 0, width * scale, height * scale);
            this.simpleplotsprite(this.g2, spritenum, scale);
        }
        return this.g2;
    }

    public void drawspritepaletteasband(Graphics2D g, int x, int y, int h, int numcolours) {
        int size = 16;
        numcolours = 32;
        if (this.parent.usehalfbright) {
            numcolours = 64;
        }
        int index = 0;
        while (index < numcolours) {
            g.setColor(this.colorSpritePaletteEntry(index));
            int col = 0;
            while (col < size) {
                g.drawLine(x + index * size + col, y, index * size + col, y + h);
                ++col;
            }
            ++index;
        }
    }

    public void drawall(Graphics2D g) {
        g.setBackground(this.colorSpritePaletteEntry(0));
        g.setColor(this.colorSpritePaletteEntry(0));
        g.fillRect(0, 0, this.parent.panel.getWidth(), this.parent.panel.getHeight());
        int numplanes = 0;
        int n = 0;
        while (n < this.numObjects()) {
            if (numplanes < this.objectBitplanes(n)) {
                numplanes = this.objectBitplanes(n);
            }
            ++n;
        }
        if (numplanes == 6 && !this.parent.useaga && !this.parent.useham) {
            this.parent.usehalfbright = true;
        }
        this.getimages(this.parent.scale);
        this.drawimages(g, this.parent.scale, this.parent.panel.getWidth(), this.parent.panel.getHeight(), false);
    }
}

