;; Apollo-Core m68080 description.
;; Copyright (C) 2007-2016 Free Software Foundation, Inc.
;; Contributed by CodeSourcery Inc., www.codesourcery.com
;;
;; This file is part of GCC.
;;
;; GCC is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 3, or (at your option)
;; any later version.
;;
;; GCC is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.
;;
;; You should have received a copy of the GNU General Public License
;; along with this program; see the file COPYING3.  If not see
;; <http://www.gnu.org/licenses/>.

;; 
(define_automaton "m68080_automaton")

;; model the pipelines.
(define_cpu_unit "i0_pipeline, i1_pipeline" "m68080_automaton")
(define_cpu_unit "f0_pipeline, f1_pipeline, f2_pipeline, f3_pipeline, f4_pipeline, f5_pipeline, f6_pipeline, f7_pipeline, f8_pipeline" "m68080_automaton")
;;(define_cpu_unit "f_pipeline" "m68080_automaton")

;; and the out ports
(define_cpu_unit "port0, port1" "m68080_automaton")

;; abbreviations
(define_reservation "i_pipelines" "(i0_pipeline | i1_pipeline)")
(define_reservation "i_ports" "(port0 | port1)")
;;(define_reservation "f_pipelines" "(f0_pipeline | f1_pipeline| f2_pipeline| f3_pipeline| f4_pipeline| f5_pipeline| f6_pipeline| f7_pipeline| f8_pipeline)")
;;(define_reservation "f_pipelines" "(f_pipeline)")


;; simple insns with 1 cycle
(define_insn_reservation "simple" 1 (eq_attr "type" "alu_l")
"i_pipelines, i_ports")

;; mul takes 2 cycles
(define_insn_reservation "mul" 2 (eq_attr "type" "mul_w,mul_l")
"(i0_pipeline*2 | i1_pipeline*2), i_ports")

;; div takes 2 cycles
;;(define_insn_reservation "div" 32 (eq_attr "type" "div_l")
;;"(i0_pipeline*32 | i1_pipeline*32), i_ports")

;; all insns with latency 9
(define_insn_reservation "m68080_fpu_9" 9
  (and (eq_attr "cpu" "m68080")
	   (eq_attr "type" "fdiv"))
  "f0_pipeline, f1_pipeline, f2_pipeline, f3_pipeline, f4_pipeline, f5_pipeline, f6_pipeline, f7_pipeline, f8_pipeline")

;; all insns with latency 6
(define_insn_reservation "m68080_fpu_6" 6
  (and (eq_attr "cpu" "m68080")
	   (eq_attr "type" "fmul,falu,fcmp,ftst"))
  "f0_pipeline, f1_pipeline, f2_pipeline, f3_pipeline, f4_pipeline, f5_pipeline")
  
;; all insns with latency 1
(define_insn_reservation "m68080_fpu_1" 1
  (and (eq_attr "cpu" "m68080")
	   (eq_attr "type" "fmove,fbcc"))
  "f0_pipeline")

