#ifndef EXEC_TYPES_H
#include <exec/types.h>
#endif

#ifndef LIBRARIES_DOSEXTENS_H
#include <libraries/dosextens.h>
#endif

#ifndef _STDIO_H
#include <stdio.h>
#endif

#ifndef NL_NL_H
#include <dlg/nl.h>
#endif

/* Cron routines */
LONG CronEvent(UBYTE,ULONG,char *);
LONG WhenEvent(char *);


/* Handler routines */
LONG SendCtlMsg(LONG, LONG, char *);
LONG TSetFlags(ULONG,char *);
LONG TUnSetFlags(ULONG,char *);
LONG TBaud(LONG,char *);
LONG TColors(USHORT *,char *);
LONG TCont(char *);
LONG TDevQuery(struct tdev_info *,char *);
LONG TFreeze(char *);
LONG TGetSer(struct TPTSerStuff *,char *);
LONG TGetTitle(char *,char *);
LONG TKill(char *);
LONG TRecover(char *);
LONG TScreen(LONG,struct ScrStruct *,char *);
LONG TString(char *,char *);
LONG TTimeDelay(LONG,char *);
LONG TTitle(char *,char *);
LONG TWindow(LONG,struct WinStruct *,char *);
LONG TWinHeight(char *,char *);
LONG TInTrans(char *,char *);
LONG TOutTrans(char *,char *);
LONG TCheckCarrier(char *);
LONG TSendBreak(char *);

/* String comparison routines */
/* Check to see if utility.library is being used first */
#ifndef CLIB_UTILITY_PROTOS_H
#ifndef UTILITY_PROTOS_H
LONG Stricmp(char *,char *);
LONG Strnicmp(char *,char *,USHORT);
#endif
#endif

/* String formatting routines */
void Upper(char *);
void Capitalize(char *);
void UnderScore(char *);
void DeScore(char *);
void StripSpaces(char *);


/* Formatting routines*/
LONG           XASPrintf(struct USER_DATA *,char *,char *,void *);
LONG           XAFPrintf(struct USER_DATA *,BPTR,char *,void *);
LONG           AFormat(struct USER_DATA *,void *,long (*putsub)(),char *,char *);


/* Time routines */
void  MDate(char *);
void  SMDate(ULONG,char *);
ULONG AmigaTime(void);
void  UnpackTime(ULONG, struct ATime *);
LONG  TimeUntilShutdown(char *);
void  SuspendTime(struct Ram_File *, char *);
void  ResumeTime(struct Ram_File *, char *);


/* Resource management routines */
LONG ResourceMsg(struct RMMessage *);
LONG ActivatePort(char *,char *);
LONG DeActivatePort(char *,char *);
LONG LockPort(char *,char *,char *,char,char *);
LONG ImmedLockPort(char *,char *,char *,char,char *);
LONG TransferPortLock(char *,char *,char *,char *,char,char *);
LONG FreePort(char *,char *);
LONG GetPortInfo(struct PortInfo *);
LONG FreePortInfo(struct PortInfo *);
LONG LockArea(USHORT,char *,char *,char,UBYTE);
LONG BorrowArea(USHORT,char *,char *,char,UBYTE);
LONG FreeArea(USHORT,char *,UBYTE);
LONG EnterArea(USHORT,UBYTE);
LONG LeaveArea(USHORT,UBYTE);
LONG GetAreaInfo(struct DLGAreaInfo *,UBYTE);
LONG FreeAreaInfo(struct DLGAreaInfo *);
LONG ListPorts(char *,char *);
LONG LoadLang(char *,char *);
struct LangStruct *GetLang(char *);
LONG LockResource(char *,char *,char *,char,UBYTE);
LONG FreeResource(char *,char *);
struct List *GetResReport(void);
LONG FreeResReport(struct List *);
LONG LockMenu(char *,struct MenuStuff *,USHORT,char *,char *,char,UBYTE);
LONG FreeMenu(char *,char *,char *);
LONG PurgeMenu(char *,char *);


/* Structured File I/O routines */
LONG AddStruct(char *,char *,ULONG,USHORT);
LONG DeleteStruct(char *,char *,ULONG,USHORT);
LONG GetStruct(char *,char *,ULONG,USHORT);
LONG GetFirstStruct(char *,char *,ULONG);
BOOL Exists(char *);
LONG FileSize(char *,ULONG *);
LONG GetComment(char *, char *);
BOOL GetFileDate(char *, long *);
BOOL DelDir(char *, struct USER_DATA *);
LONG DirSize(char *);
BOOL CD(char *);
LONG Cat(char *, char *, char *);
LONG Copy(char *, char *);
LONG SmartRename(char *, char *);
LONG AppendFile(char *,char *);
LONG BinPos(BPTR,ULONG,char *,USHORT,USHORT,ULONG *);
LONG FileCopy(BPTR,BPTR,ULONG,ULONG,ULONG);


/* Broadcast routines */
LONG BroadCast(char *,char *,UBYTE);
LONG BCPend(char *);
LONG BCResume(char *);
LONG BCGet(char *,char *);
LONG HandleBCMsgs(char *);
LONG BCMsg(char *,char *,UBYTE,UBYTE);
BOOL Inform(char *,char *,char *,UBYTE);
BOOL WaitingMail(char *,char *,char *,USHORT,char *,SHORT,char *);


/* User access routines */
LONG  GetDevName(char *);
BOOL  ReadRam(struct Ram_File *,char *);
BOOL  WriteRam(struct Ram_File *,char *);
BOOL  ReadUser(struct Ram_File *,struct USER_DATA *,char *);
BOOL  WriteUser(char *,struct USER_DATA *);
LONG  GetComputerType(SHORT,char *);
LONG  Age(SHORT,SHORT,SHORT);
LONG  CheckUser(char *);
SHORT GetLevel(char *);
void  LogOut(struct Ram_File *, struct USER_DATA *, char *, char *);


/* Logging routines */
BOOL WriteLog(UBYTE,char *,char *,char *);
BOOL WriteEvent(char *,char *);


/* Routines for accessing groups */
BPTR OpenGroup(char *);
BOOL NextInGroup(BPTR,char *);
void CloseGroup(BPTR);


/* Translation routines */
LONG TranslateBuffer(char *,char *,ULONG,struct USER_DATA *,struct Ram_File *,char *);
BOOL Substitute(char *,char *,struct USER_DATA *,struct Ram_File *,char *);
BOOL ScreenMsg(char *,char *,UBYTE,USHORT);
BOOL ScreenBuffer(char *,char *,ULONG,char *);


/* Search routines */
struct SearchCookie *SearchStart(char *,char *);
char *SearchNext(struct SearchCookie *);
void  SearchEnd(struct SearchCookie *);
BOOL  DLGPatternMatch(char *,char *);
char *DLGSearch(char *,char *,USHORT,USHORT,USHORT);
char *DLGBinSearch(char *,char *,USHORT,USHORT,USHORT);


/* Argument parsing routines */
LONG ArgParse(char *,char **,UBYTE);
char *StripPath(char *);


/* Input Routines */
LONG DLGQuery(struct Query *,struct UserInfo *);
char GetChar(void);
char ReadChar(ULONG);
void PutChar(char,BPTR);
void ClearLine(void);
LONG IntQuery(char *,long,long,long,struct UserInfo *);
BOOL BoolQuery(char *,UBYTE,struct UserInfo *);
LONG More(BPTR,UBYTE,UBYTE);
BOOL Pause(void);


/* Display Routines */
LONG DispBuffer(BPTR,char *,USHORT *,USHORT,char *,USHORT,char *,struct USER_DATA *);
LONG DispMsg(struct MsgDisplay *,struct USER_DATA *);
BOOL DispForm(char *,struct USER_DATA *,struct USER_DATA *,struct Ram_File *,char *);
void Clr(UBYTE);
BOOL PrintSpace(BPTR,UBYTE,USHORT);
void Draw_Line(UBYTE);
void SDraw_Line(char *, UBYTE);


/* Message access routines */
LONG SendPrivateMsg(struct Msg_Header *,char *,USHORT,char *,char *);
LONG SendPublicMsg(struct MsgStruct *,struct fido *,char *,char *);
LONG ImportPublicMsg(struct Msg_Header *,char *,struct Msg_Area *,char *);
LONG SendRawMsg(struct MsgStruct *,char *,char *);
BOOL KillMsg(LONG,USHORT,char *,char *);
LONG SendBulletin(struct Bulletin *,char *,char *);
void GetHiLowPointers(USHORT,char *,LONG *,LONG *,char *);
BOOL PutHiLowPointers(USHORT,char *,LONG,LONG,char *);
BOOL GetOrigin(char *, SHORT *, SHORT *, SHORT *, SHORT *);
LONG CallEditor(char *, char *, char *, char , struct USER_DATA *, struct Ram_File *, char *);


/* Area management routines */
BOOL ReadArea(USHORT, struct Msg_Area *, UBYTE);
BOOL AddArea         (char *, USHORT);
BOOL DelArea         (char *, USHORT);
BOOL ExistsGlobalArea(char *, USHORT);
LONG ListAreas(char *, struct USER_DATA *, char , UBYTE );
BYTE ListSIGS(struct USER_DATA *, char , char );


/* DLG File tranfer protocol routines */
struct DLGSerInfo *DLGGetSer(char *,char);
void               DLGReleaseSer(struct DLGSerInfo *);
void               DLGProtoStatus(struct DLGSerInfo *,ULONG,ULONG,char *);


/* Debugging Routine */
BOOL  DB(char *);


/* File access Routines */
void  GetHiLowFPointers(USHORT,char *,LONG *,LONG *,char *);
BOOL  PutHiLowFPointers(USHORT,char *,LONG,LONG,char *);
LONG  GetPath(char *, USHORT , struct Msg_Area *, char *);
void  ScreenPath(char *);
BOOL  ReceiveFile(char *, struct Protocol *, struct File_Header *, struct USER_DATA *, struct Ram_File *, char *);
BOOL  SendFile(struct Protocol *, char *, char *, struct USER_DATA *, struct Ram_File *, char *);


/* Execute Routines */
LONG  OverlayProgram(char *);
BOOL  ChainProgram(char *, char *);
BOOL  DialogBatch(char *, struct USER_DATA *, struct Ram_File *, char *);

/* Prototypes for functions defined in debug.c */
//BOOL DeBug(char *);
//BOOL SDB(char *);
//BOOL PDB(char *);
//void Oldb(char *);

/* Prototypes for functions defined in displayfile.c */
SHORT Display_File(char *, int , int , char , USHORT *, long , char , char *);

/* Prototypes for functions defined in translatecall.c*/
void TranslateCall(char *, char *, char *, char *);

/* Prototypes for functions in fido.lib */

//UWORD FixNumber(UWORD);

//char *CenterText(char *,int);

//void StripQuote(char *);

/* v4 */

ULONG CalcCRC(unsigned char *, int, ULONG);
BOOL  CheckRange(long, char *, long);


/* dlg_file.lib */
//BOOL AddNewScanFArea(SHORT , SHORT , ULONG , char , char *);

