#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include <ctype.h>
#include <fcntl.h>
#include <libraries/dosextens.h>

#include <dlg/cron.h>
#include <dlg/resman.h>
#include <dlg/dlg.h>
#include <dlg/user.h>

#include <link/io.h>
#include <link/lang.h>

#include <proto/dos.h>
#include <proto/exec.h>
#include <proto/dlg.h>

#include <pragmas/dlg.h>

#include <private/Version.h>
#define  ObjRev "1"
const UBYTE version[]="\0$VER: AddTime " BUILDVER "." ObjRev " " COPYRIGHT " by Digerati Dreams "__AMIGADATE__;

extern struct DosLibrary *DOSBase;


LONG  AddTm(SHORT toadd, char *ext);
void  Usage(char *);
BOOL  UserOnline(char *);
void  Break(void);

BPTR              sout;
char              Ext[4]  = "";
struct Library   *DLGBase = NULL;
char            **SA;

VOID main(int argc,char *argv[])

{
   char *s;
   SHORT minutes = 0;
   SHORT newtime;

   sout = Output();
   if (!(DLGBase = OpenLibrary(DLGNAME, DLGVERSION)))  exit(5);
   if (!(SA = getlang(NULL)))                          exit(5);

/// parse args
   while(--argc>0)
   {
      s = *++argv;

      if (*s++ == '-')
      {
         while(*s)
         {
            switch(*s++)
            {
               case 'm':
               case 'M': if (!--argc)  break;
               minutes = atoi(*++argv);
               break;

               case 'p':
               case 'P': if (!--argc)  break;
               strncpy(Ext, *++argv, 3);
               Ext[3] = 0;
               Upper(Ext);
               break;
            }
         }
      }
      else
      Usage(NULL);
   }
//-

   if (!Ext[0])  Usage(SA[0]);

   if (UserOnline(Ext))
   {
      newtime = AddTm(minutes, Ext);
      AFPrintf(NULL, sout, SA[1],newtime+2,Ext);
   }
   else
   AFPrintf(NULL, sout, SA[2],Ext);

   CloseLibrary(DLGBase);
}


LONG AddTm(SHORT toadd, char *ext)

{
   char         string[40];
   LONG         shutdown;
   LONG         timeleft;

   ASPrintf(NULL, string, "> NIL: DLG:REMOVEUSER %s", ext);

   timeleft = WhenEvent(string);
   if (timeleft < 0)
   {
      Break();
      timeleft = 0;
   }

   timeleft += toadd;
   if (timeleft < 0)  timeleft = 0;

   shutdown = TimeUntilShutdown(ext) - 2;
   if (shutdown < timeleft)  timeleft = shutdown;

   CronEvent(DELEVENT,    0,     string);
   CronEvent(ADDEVENT, timeleft, string);

   return(timeleft);
}


VOID Usage(char *str)

{
   if (str)  AFPrintf(NULL, sout, SA[3],str);

   AFPrintf(NULL, sout, SA[4]);
   AFPrintf(NULL, sout, SA[5]);
   AFPrintf(NULL, sout, SA[6]);
   AFPrintf(NULL, sout, SA[7]);
   AFPrintf(NULL, sout, SA[8]);
   AFPrintf(NULL, sout, SA[9]);
   AFPrintf(NULL, sout, SA[10]);

   CloseLibrary(DLGBase);

   exit(5);
}


BOOL UserOnline(char *port)

{
   long            retval;
   struct PortInfo istruct;

   istruct.port = port;
   retval       = GetPortInfo(&istruct);

   if (retval==RMNOERR)
   {
      if (!strcmp(istruct.passwd,"BBS"))
      {
         FreePortInfo(&istruct);
         return(TRUE);
      }
      else
      FreePortInfo(&istruct);
   }

   return(FALSE);
}


void Break()

{
   long                         max_cli;
   long                         cli_num;
   struct Process              *proc;
   struct CommandLineInterface *cli;
   char                        *cname;
   char                         cmd[40];

   max_cli = MaxCli();
   ASPrintf(NULL, cmd, "%s_RemoveUser", Ext);

   Forbid();
   for(cli_num = 1; cli_num <= max_cli; cli_num++)
   if ((proc = FindCliProc(cli_num)))
   {
      if (proc->pr_CLI)
      {
         cli   = BADDR(proc->pr_CLI);
         cname = BADDR(cli->cli_CommandName);
         if (cname)
         if (!strcmp(cname+1, cmd))
         {
            Signal((struct Task *)proc, SIGBREAKF_CTRL_C);
            Permit();
            return;
         }
      }
   }
   Permit();
}
