#include "UserEdit.h"

void ViewStats(void);

/// EditStats()
void EditStats(void)
{
   BOOL  Write    = FALSE;
   char  c[2];
   long  l;

   while(TRUE)
   {
      ViewStats();

      DLGInput("Select letter to edit parameter -> ",NULL,c,NULL,1,1,1);
      TwoLines();

      if(Sysop)
      {

///      Change Total Time Online (A)
         if(!Strnicmp(c,"A",1))
         {
            l = IntQuery("Total Time Online -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Online_Time != l)
            {
               udat.Online_Time = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Time Used Today (B)
         if(!Strnicmp(c,"B",1))
         {
            l = IntQuery("Total Time Used Today -> ",1,1440,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Daily_Used != l)
            {
               udat.Daily_Used = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Calls (C)
         if(!Strnicmp(c,"C",1))
         {
            l = IntQuery("Total Number of Calls -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Total_Calls != l)
            {
               udat.Total_Calls = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Sysop Pages (D)
         if(!Strnicmp(c,"D",1))
         {
            l = IntQuery("Total Number of Sysop Pages -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Sysop_Pages != l)
            {
               udat.Sysop_Pages = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Messages Written (E)
         if(!Strnicmp(c,"E",1))
         {
            l = IntQuery("Total Number of Messages Written -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Messages_Entered != l)
            {
               udat.Messages_Entered = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Messages Read (F)
         if(!Strnicmp(c,"F",1))
         {
            l = IntQuery("Total Number of Messages Read -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Messages_Read != l)
            {
               udat.Messages_Read = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Files Uploaded (G)
         if(!Strnicmp(c,"G",1))
         {
            l = IntQuery("Total Number of Files Uploaded -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Files_Uploaded != l)
            {
               udat.Files_Uploaded = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of Files Downloaded (I)
         if(!Strnicmp(c,"I",1))
         {
            l = IntQuery("Total Number of Files Downloaded -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;

            if(udat.Files_Downloaded != l)
            {
               udat.Files_Downloaded = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of bytes Uploaded (J)
         if(!Strnicmp(c,"J",1))
         {
            l = IntQuery("Total Number of kilobytes Uploaded -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;
            l = l * 1024;

            if(udat.Bytes_Uploaded != l)
            {
               udat.Bytes_Uploaded = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

///      Change Number of bytes Downloaded (K)
         if(!Strnicmp(c,"K",1))
         {
            l = IntQuery("Total Number of kilobytes Downloaded -> ",1,999999,0,&uin);
            TwoLines();

            if(l == 0) continue;
            l = l * 1024;

            if(udat.Bytes_Downloaded != l)
            {
               udat.Bytes_Downloaded = l;
               AFPrintf(&UserDat,sout,"%a7Changed!\n\n");
               Write = TRUE;
            }
         }
//-

      }

///   Exit
      if(!Strnicmp(c,"X",1))
      {
         if(Write && Sysop)
         {
            struct NameStruct ns;

            strcpy(ns.name,name);

            if(0 == DeleteStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30))
            {
               char fname[128];

               strcpy(ns.alias,udat.Alias);
               strcpy(ns.email,udat.Email);
               AddStruct(NAMERECORD,(char *)&ns,sizeof(struct NameStruct),30);

               ASPrintf(NULL,fname,"USER:%s/User.Data",name);
               UnderScore(fname);

               if(Same) memcpy(&UserDat,&udat,sizeof(struct USER_DATA));
               DeleteFile(fname);
               DumpFile(fname,(char *)&udat,sizeof(struct USER_DATA));
            }

            AFPrintf(&UserDat,sout,"%a7Changes saved.\n\n");
            Pause();
         }
         else
         {
            if(Sysop)
            {
               AFPrintf(&UserDat,sout,"%a7User record unchanged.\n\n");
               Pause();
            }
         }

         break;
      }
//-

///   Quit
      if(!Strnicmp(c,"Q",1))
      {
         if(Write)
         {
            AFPrintf(&UserDat,sout,"%b7 %a1NOTE: %b0%a7 Changes not saved!\n\n");
            Pause();
         }

         break;
      }
//-

   }

   return;
}
//-

/// ViewStats()
void ViewStats(void)
{
   char temp[128];

   Clr(UserDat.Ansi_Flag);
   AFPrintf(&UserDat,sout,"\n%a6Statistics for user %a2[%au%a7%s%ao%a2]%a7\n",name);
   Draw_Line(UserDat.Screen_Width);

   SMDate(udat.DateJoined,temp);
   AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6JOINED ............... %b7%a1 %-20.20s \n",temp);
   AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6LAST LOGIN ........... %b7%a1 %-20.20s \n",udat.Last_Login);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7A%a2] %a6TOTAL TIME ONLINE .... %b7%a4 %7ld \n",udat.Online_Time);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6TOTAL TIME ONLINE .... %b7%a1 %7ld \n",udat.Online_Time);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7B%a2] %a6TIME USED TODAY ...... %b7%a4 %7ld \n",udat.Daily_Used);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6TIME USED TODAY ...... %b7%a1 %7ld \n",udat.Daily_Used);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7C%a2] %a6NUMBER OF CALLS ...... %b7%a4 %7ld \n",udat.Total_Calls);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6NUMBER OF CALLS ...... %b7%a1 %7ld \n",udat.Total_Calls);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7D%a2] %a6SYSOP PAGES .......... %b7%a4 %7ld \n",udat.Sysop_Pages);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6SYSOP PAGES .......... %b7%a1 %7ld \n",udat.Sysop_Pages);

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7E%a2] %a6MESSAGES WRITTEN ..... %b7%a4 %7ld ",udat.Messages_Entered);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6MESSAGES WRITTEN ..... %b7%a1 %7ld ",udat.Messages_Entered);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0    %a2[%a7F%a2] %a6MESSAGES READ ........ %b7%a4 %7ld \n",udat.Messages_Read);
   else
      AFPrintf(&UserDat,sout,"%b0    %a2[ ] %a6MESSAGES READ ........ %b7%a1 %7ld \n",udat.Messages_Read);

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7G%a2] %a6FILES UPLOADED ....... %b7%a4 %7ld ",udat.Files_Uploaded);
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6FILES UPLOADED ....... %b7%a1 %7ld ",udat.Files_Uploaded);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0    %a2[%a7I%a2] %a6FILES DOWNLOADED ..... %b7%a4 %7ld \n",udat.Files_Downloaded);
   else
      AFPrintf(&UserDat,sout,"%b0    %a2[ ] %a6FILES DOWNLOADED ..... %b7%a1 %7ld \n",udat.Files_Downloaded);

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0%a2[%a7J%a2] %a6KILOBYTES UPLOADED ... %b7%a4 %7ld %b0%a6Kb",(udat.Bytes_Uploaded / (ULONG)1024));
   else
      AFPrintf(&UserDat,sout,"%b0%a2[ ] %a6KILOBYTES UPLOADED ... %b7%a1 %7ld %b0%a6Kb",(udat.Bytes_Uploaded / (ULONG)1024));

   if(Sysop)
      AFPrintf(&UserDat,sout,"%b0  %a2[%a7K%a2] %a6KILOBYTES DOWNLOADED . %b7%a4 %7ld %b0%a6Kb\n",(udat.Bytes_Downloaded / (ULONG)1024));
   else
      AFPrintf(&UserDat,sout,"%b0  %a2[ ] %a6KILOBYTES DOWNLOADED . %b7%a1 %7ld %b0%a6Kb\n",(udat.Bytes_Downloaded / (ULONG)1024));

   AFPrintf(&UserDat,sout,"%b0%a7");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"%a2[%a7H%a2] %a6Help    %a2[%a7?%a2] %a6Re-Display    %a2[%a7X%a2] %a6Save and Exit   %a2[%a7Q%a2] %a6Quit (no save)%a7\n");
   Draw_Line(UserDat.Screen_Width);

   AFPrintf(&UserDat,sout,"    %a6Text in %b7 %a1Red Text %b0%a6 is not editable.%a7\n");
   Draw_Line(UserDat.Screen_Width);
   OneLine();

   return;
}
//-
